/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.scala.modifiers;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeModifier;
import java.lang.reflect.Type;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.immutable.IntMap;
import scala.collection.immutable.LongMap;
import scala.util.Either;

public class ScalaTypeModifier
extends TypeModifier {
    private final Class<Option<?>> optionClass = Option.class;
    private final Class<Either<?, ?>> eitherClass = Either.class;
    private final Class<Map<?, ?>> mapClass = Map.class;
    private final Class<Object> intClass = Integer.TYPE;
    private final Class<IntMap<?>> intMapClass = IntMap.class;
    private final Class<Object> longClass = Long.TYPE;
    private final Class<LongMap<?>> immutableLongMapClass = LongMap.class;
    private final Class<scala.collection.mutable.LongMap<?>> mutableLongMapClass = scala.collection.mutable.LongMap.class;
    private final Class<IterableOnce<?>> iterableOnceClass = IterableOnce.class;

    public JavaType modifyType(JavaType javaType, Type jdkType, TypeBindings context, TypeFactory typeFactory) {
        if (javaType.isTypeOrSubTypeOf(this.optionClass)) {
            JavaType javaType2 = javaType;
            if (javaType2 instanceof ReferenceType) {
                ReferenceType rt = (ReferenceType)javaType2;
                return rt;
            }
            return ReferenceType.upgradeFrom((JavaType)javaType, (JavaType)javaType.containedTypeOrUnknown(0));
        }
        if (javaType.isTypeOrSubTypeOf(this.mapClass)) {
            if (javaType.isTypeOrSubTypeOf(this.intMapClass)) {
                return MapLikeType.upgradeFrom((JavaType)javaType, (JavaType)typeFactory.constructType(this.intClass), (JavaType)javaType.containedTypeOrUnknown(0));
            }
            if (javaType.isTypeOrSubTypeOf(this.immutableLongMapClass) || javaType.isTypeOrSubTypeOf(this.mutableLongMapClass)) {
                return MapLikeType.upgradeFrom((JavaType)javaType, (JavaType)typeFactory.constructType(this.longClass), (JavaType)javaType.containedTypeOrUnknown(0));
            }
            return MapLikeType.upgradeFrom((JavaType)javaType, (JavaType)javaType.containedTypeOrUnknown(0), (JavaType)javaType.containedTypeOrUnknown(1));
        }
        if (javaType.isTypeOrSubTypeOf(this.iterableOnceClass)) {
            return CollectionLikeType.upgradeFrom((JavaType)javaType, (JavaType)javaType.containedTypeOrUnknown(0));
        }
        if (javaType.isTypeOrSubTypeOf(this.eitherClass)) {
            return ReferenceType.upgradeFrom((JavaType)javaType, (JavaType)javaType);
        }
        return javaType;
    }
}

