/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.action;

import com.o19s.es.ltr.action.CreateModelFromSetAction;
import com.o19s.es.ltr.action.FeatureStoreAction;
import com.o19s.es.ltr.action.TransportFeatureStoreAction;
import com.o19s.es.ltr.feature.store.StorableElement;
import com.o19s.es.ltr.feature.store.StoredFeatureSet;
import com.o19s.es.ltr.feature.store.StoredLtrModel;
import com.o19s.es.ltr.feature.store.index.IndexFeatureStore;
import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.get.TransportGetAction;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.ltr.breaker.LTRCircuitBreakerService;
import org.opensearch.ltr.exception.LimitExceededException;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportCreateModelFromSetAction
extends HandledTransportAction<CreateModelFromSetAction.CreateModelFromSetRequest, CreateModelFromSetAction.CreateModelFromSetResponse> {
    private final ClusterService clusterService;
    private final TransportGetAction getAction;
    private final TransportFeatureStoreAction featureStoreAction;
    private final LTRCircuitBreakerService ltrCircuitBreakerService;

    @Inject
    public TransportCreateModelFromSetAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, ClusterService clusterService, TransportGetAction getAction, TransportFeatureStoreAction featureStoreAction, LTRCircuitBreakerService ltrCircuitBreakerService) {
        super("cluster:admin/ltr/store/create-model-from-set", transportService, actionFilters, CreateModelFromSetAction.CreateModelFromSetRequest::new);
        this.clusterService = clusterService;
        this.getAction = getAction;
        this.featureStoreAction = featureStoreAction;
        this.ltrCircuitBreakerService = ltrCircuitBreakerService;
    }

    protected void doExecute(Task task, CreateModelFromSetAction.CreateModelFromSetRequest request, ActionListener<CreateModelFromSetAction.CreateModelFromSetResponse> listener) {
        if (!this.clusterService.state().routingTable().hasIndex(request.getStore())) {
            throw new IllegalArgumentException("Store [" + request.getStore() + "] does not exist, please create it first.");
        }
        if (this.ltrCircuitBreakerService.isOpen().booleanValue()) {
            throw new LimitExceededException("Store [" + request.getStore() + "] creating model is not allowed as memory circuit is broken.");
        }
        GetRequest getRequest = new GetRequest(request.getStore()).id(StorableElement.generateId("featureset", request.getFeatureSetName()));
        getRequest.setParentTask(this.clusterService.localNode().getId(), task.getId());
        this.getAction.execute((ActionRequest)getRequest, ActionListener.wrap(r -> this.doStore(task, (GetResponse)r, request, listener), arg_0 -> listener.onFailure(arg_0)));
    }

    private void doStore(Task parentTask, GetResponse response, CreateModelFromSetAction.CreateModelFromSetRequest request, ActionListener<CreateModelFromSetAction.CreateModelFromSetResponse> listener) {
        StoredFeatureSet set;
        if (!response.isExists()) {
            throw new IllegalArgumentException("Stored feature set [" + request.getFeatureSetName() + "] does not exist");
        }
        if (request.getExpectedSetVersion() != null && request.getExpectedSetVersion().longValue() != response.getVersion()) {
            throw new IllegalArgumentException("Stored feature set [" + request.getFeatureSetName() + "] has version [" + response.getVersion() + "] but [" + request.getExpectedSetVersion() + "] was expected.");
        }
        try {
            set = IndexFeatureStore.parse(StoredFeatureSet.class, "featureset", response.getSourceAsBytesRef());
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot parse stored feature set [" + request.getFeatureSetName() + "]", ioe);
        }
        StoredLtrModel model = new StoredLtrModel(request.getModelName(), set, request.getDefinition());
        FeatureStoreAction.FeatureStoreRequest featureStoreRequest = new FeatureStoreAction.FeatureStoreRequest(request.getStore(), (StorableElement)model, FeatureStoreAction.FeatureStoreRequest.Action.CREATE);
        featureStoreRequest.setRouting(request.getRouting());
        featureStoreRequest.setParentTask(this.clusterService.localNode().getId(), parentTask.getId());
        featureStoreRequest.setValidation(request.getValidation());
        this.featureStoreAction.execute(featureStoreRequest, ActionListener.wrap(r -> listener.onResponse((Object)new CreateModelFromSetAction.CreateModelFromSetResponse(r.getResponse())), arg_0 -> listener.onFailure(arg_0)));
    }
}

