/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.model.builder;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.SearchModule;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.experiment.QuerySourceUtil;

public class SearchRequestBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(SearchRequestBuilder.class);
    private static final NamedXContentRegistry NAMED_CONTENT_REGISTRY;
    private static final SearchModule SEARCH_MODULE;
    private static final String QUERY_FIELD_NAME = "query";
    private static final String SIZE_FIELD_NAME = "size";

    public static SearchRequest buildSearchRequest(String index, String query, String queryText, String searchPipeline, int size) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        try {
            int querySize;
            String processedQuery = query.replace("%SearchText%", queryText);
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, processedQuery);
            Map fullQueryMap = parser.map();
            Object queryObject = fullQueryMap.remove(QUERY_FIELD_NAME);
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.map(fullQueryMap);
            parser = JsonXContent.jsonXContent.createParser(NAMED_CONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, builder.toString());
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
            if (queryObject != null) {
                builder = JsonXContent.contentBuilder();
                builder.value(queryObject);
                String queryBody = builder.toString();
                sourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryBody));
            }
            if (fullQueryMap.containsKey(SIZE_FIELD_NAME) && (querySize = ((Number)fullQueryMap.get(SIZE_FIELD_NAME)).intValue()) != size) {
                log.debug("Size mismatch detected. Query size: {}, Search Configuration Input size: {}. Using Search Configuration Input size.", (Object)querySize, (Object)size);
            }
            sourceBuilder.size(size);
            if (searchPipeline != null && !searchPipeline.isEmpty()) {
                searchRequest.pipeline(searchPipeline);
            }
            searchRequest.source(sourceBuilder);
            return searchRequest;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to build search request", ex);
        }
    }

    public static SearchRequest buildRequestForHybridSearch(String index, String query, Map<String, Object> temporarySearchPipeline, String queryText, int size) {
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        try {
            int querySize;
            String processedQuery = query.replace("%SearchText%", queryText);
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.IGNORE_DEPRECATIONS, processedQuery);
            Map fullQueryMap = parser.map();
            QuerySourceUtil.validateHybridQuery(fullQueryMap);
            Object queryObject = fullQueryMap.remove(QUERY_FIELD_NAME);
            XContentBuilder builder = JsonXContent.contentBuilder();
            builder.map(fullQueryMap);
            parser = JsonXContent.jsonXContent.createParser(NAMED_CONTENT_REGISTRY, DeprecationHandler.IGNORE_DEPRECATIONS, builder.toString());
            SearchSourceBuilder sourceBuilder = SearchSourceBuilder.fromXContent((XContentParser)parser);
            if (Objects.nonNull(sourceBuilder.searchPipelineSource()) && !sourceBuilder.searchPipelineSource().isEmpty()) {
                log.error("query in search configuration does have temporary search pipeline in its source");
                throw new IllegalArgumentException("search pipeline is not allowed in search request");
            }
            if (!temporarySearchPipeline.isEmpty()) {
                sourceBuilder.searchPipelineSource(temporarySearchPipeline);
            } else {
                log.debug("no temporary search pipeline");
            }
            if (queryObject != null) {
                builder = JsonXContent.contentBuilder();
                builder.value(queryObject);
                String queryBody = builder.toString();
                sourceBuilder.query((QueryBuilder)QueryBuilders.wrapperQuery((String)queryBody));
            }
            if (fullQueryMap.containsKey(SIZE_FIELD_NAME) && (querySize = ((Number)fullQueryMap.get(SIZE_FIELD_NAME)).intValue()) != size) {
                log.debug("Size mismatch detected. Query size: {}, Search Configuration Input size: {}. Using Search Configuration Input size.", (Object)querySize, (Object)size);
            }
            sourceBuilder.size(size);
            searchRequest.source(sourceBuilder);
            return searchRequest;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException("Failed to build search request", ex);
        }
    }

    static {
        SEARCH_MODULE = new SearchModule(Settings.EMPTY, Collections.emptyList());
        NAMED_CONTENT_REGISTRY = new NamedXContentRegistry(SEARCH_MODULE.getNamedXContents());
    }
}

