/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.transport.monitor;

import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.commons.alerting.AlertingPluginInterface;
import org.opensearch.commons.alerting.action.SearchMonitorRequest;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.search.SearchHit;
import org.opensearch.securityanalytics.settings.SecurityAnalyticsSettings;
import org.opensearch.securityanalytics.threatIntel.action.monitor.request.SearchThreatIntelMonitorRequest;
import org.opensearch.securityanalytics.threatIntel.sacommons.monitor.ThreatIntelMonitorDto;
import org.opensearch.securityanalytics.threatIntel.util.ThreatIntelMonitorUtils;
import org.opensearch.securityanalytics.transport.SecureTransportAction;
import org.opensearch.securityanalytics.util.DetectorUtils;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;
import org.opensearch.transport.client.node.NodeClient;

public class TransportSearchThreatIntelMonitorAction
extends HandledTransportAction<SearchThreatIntelMonitorRequest, SearchResponse>
implements SecureTransportAction {
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final ClusterService clusterService;
    private final Settings settings;
    private final ThreadPool threadPool;
    private Boolean filterByEnabled;

    @Inject
    public TransportSearchThreatIntelMonitorAction(TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, NamedXContentRegistry xContentRegistry, Settings settings, Client client, ThreadPool threadPool) {
        super("cluster:admin/opensearch/securityanalytics/threatintel/monitors/search", transportService, actionFilters, SearchThreatIntelMonitorRequest::new);
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.clusterService = clusterService;
        this.settings = settings;
        this.threadPool = threadPool;
        this.filterByEnabled = (Boolean)SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES.get(this.settings);
        this.clusterService.getClusterSettings().addSettingsUpdateConsumer(SecurityAnalyticsSettings.FILTER_BY_BACKEND_ROLES, this::setFilterByEnabled);
    }

    protected void doExecute(Task task, SearchThreatIntelMonitorRequest request, ActionListener<SearchResponse> listener) {
        User user = this.readUserFromThreadContext(this.threadPool);
        String validateBackendRoleMessage = this.validateUserBackendRoles(user, this.filterByEnabled);
        if (!"".equals(validateBackendRoleMessage)) {
            listener.onFailure((Exception)new OpenSearchStatusException("Do not have permissions to resource", RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        this.threadPool.getThreadContext().stashContext();
        AlertingPluginInterface.INSTANCE.searchMonitors((NodeClient)this.client, new SearchMonitorRequest(request.searchRequest()), ActionListener.wrap(response -> {
            for (SearchHit hit : response.getHits().getHits()) {
                XContentParser parser = XContentType.JSON.xContent().createParser(this.xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
                ScheduledJob monitor = ScheduledJob.Companion.parse(parser, hit.getId(), hit.getVersion());
                ThreatIntelMonitorDto threatIntelMonitorDto = ThreatIntelMonitorUtils.buildThreatIntelMonitorDto(hit.getId(), (Monitor)monitor, this.xContentRegistry);
                XContentBuilder builder = threatIntelMonitorDto.toXContent(XContentBuilder.builder((XContent)XContentType.JSON.xContent()), null);
                hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
            }
            listener.onResponse(response);
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                listener.onResponse((Object)DetectorUtils.getEmptySearchResponse());
                return;
            }
            log.error("Failed to search threat intel monitors", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void setFilterByEnabled(boolean filterByEnabled) {
        this.filterByEnabled = filterByEnabled;
    }
}

