/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.plugin.insights.core.service.categorizer;

import java.util.Collection;
import java.util.Map;
import org.opensearch.plugin.insights.core.service.categorizer.SearchQueryCounters;
import org.opensearch.plugin.insights.rules.model.Measurement;
import org.opensearch.plugin.insights.rules.model.MetricType;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.PipelineAggregationBuilder;
import org.opensearch.telemetry.metrics.tags.Tags;

public class SearchQueryAggregationCategorizer {
    static final String AGGREGATION_TYPE_TAG = "agg_type";
    private final SearchQueryCounters searchQueryCounters;

    public SearchQueryAggregationCategorizer(SearchQueryCounters searchQueryCounters) {
        this.searchQueryCounters = searchQueryCounters;
    }

    public void incrementSearchQueryAggregationCounters(Collection<AggregationBuilder> aggregatorFactories, Map<MetricType, Measurement> measurements) {
        for (AggregationBuilder aggregationBuilder : aggregatorFactories) {
            this.incrementCountersRecursively(aggregationBuilder, measurements);
        }
    }

    private void incrementCountersRecursively(AggregationBuilder aggregationBuilder, Map<MetricType, Measurement> measurements) {
        String aggregationType = aggregationBuilder.getType();
        this.searchQueryCounters.incrementAggCounter(1.0, Tags.create().addTag(AGGREGATION_TYPE_TAG, aggregationType), measurements);
        Collection subAggregations = aggregationBuilder.getSubAggregations();
        if (subAggregations != null && !subAggregations.isEmpty()) {
            for (AggregationBuilder subAggregation : subAggregations) {
                this.incrementCountersRecursively(subAggregation, measurements);
            }
        }
        Collection pipelineAggregations = aggregationBuilder.getPipelineAggregations();
        for (PipelineAggregationBuilder pipelineAggregation : pipelineAggregations) {
            String pipelineAggregationType = pipelineAggregation.getType();
            this.searchQueryCounters.incrementAggCounter(1.0, Tags.create().addTag(AGGREGATION_TYPE_TAG, pipelineAggregationType), measurements);
        }
    }
}

