/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoHashLocation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, GeoHashLocation> {
    @Nonnull
    private final String geohash;
    public static final JsonpDeserializer<GeoHashLocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoHashLocation::setupGeoHashLocationDeserializer);

    private GeoHashLocation(Builder builder) {
        this.geohash = ApiTypeHelper.requireNonNull(builder.geohash, this, "geohash");
    }

    public static GeoHashLocation of(Function<Builder, ObjectBuilder<GeoHashLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String geohash() {
        return this.geohash;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("geohash");
        generator.write(this.geohash);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoHashLocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::geohash, JsonpDeserializer.stringDeserializer(), "geohash");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.geohash.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoHashLocation other = (GeoHashLocation)o;
        return this.geohash.equals(other.geohash);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, GeoHashLocation> {
        private String geohash;

        public Builder() {
        }

        private Builder(GeoHashLocation o) {
            this.geohash = o.geohash;
        }

        private Builder(Builder o) {
            this.geohash = o.geohash;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder geohash(String value) {
            this.geohash = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoHashLocation build() {
            this._checkSingleUse();
            return new GeoHashLocation(this);
        }
    }
}

