/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.BucketAggregationBase;
import org.opensearch.client.opensearch._types.aggregations.TermsExclude;
import org.opensearch.client.opensearch._types.aggregations.TermsInclude;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RareTermsAggregation
extends BucketAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, RareTermsAggregation> {
    @Nullable
    private final TermsExclude exclude;
    @Nullable
    private final String field;
    @Nullable
    private final TermsInclude include;
    @Nullable
    private final Long maxDocCount;
    @Nullable
    private final FieldValue missing;
    @Nullable
    private final Double precision;
    @Nullable
    private final String valueType;
    public static final JsonpDeserializer<RareTermsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RareTermsAggregation::setupRareTermsAggregationDeserializer);

    private RareTermsAggregation(Builder builder) {
        super(builder);
        this.exclude = builder.exclude;
        this.field = builder.field;
        this.include = builder.include;
        this.maxDocCount = builder.maxDocCount;
        this.missing = builder.missing;
        this.precision = builder.precision;
        this.valueType = builder.valueType;
    }

    public static RareTermsAggregation of(Function<Builder, ObjectBuilder<RareTermsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.RareTerms;
    }

    @Nullable
    public final TermsExclude exclude() {
        return this.exclude;
    }

    @Nullable
    public final String field() {
        return this.field;
    }

    @Nullable
    public final TermsInclude include() {
        return this.include;
    }

    @Nullable
    public final Long maxDocCount() {
        return this.maxDocCount;
    }

    @Nullable
    public final FieldValue missing() {
        return this.missing;
    }

    @Nullable
    public final Double precision() {
        return this.precision;
    }

    @Nullable
    public final String valueType() {
        return this.valueType;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.exclude != null) {
            generator.writeKey("exclude");
            this.exclude.serialize(generator, mapper);
        }
        if (this.field != null) {
            generator.writeKey("field");
            generator.write(this.field);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.maxDocCount != null) {
            generator.writeKey("max_doc_count");
            generator.write(this.maxDocCount.longValue());
        }
        if (this.missing != null) {
            generator.writeKey("missing");
            this.missing.serialize(generator, mapper);
        }
        if (this.precision != null) {
            generator.writeKey("precision");
            generator.write(this.precision.doubleValue());
        }
        if (this.valueType != null) {
            generator.writeKey("value_type");
            generator.write(this.valueType);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRareTermsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        RareTermsAggregation.setupBucketAggregationBaseDeserializer(op);
        op.add(Builder::exclude, TermsExclude._DESERIALIZER, "exclude");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::include, TermsInclude._DESERIALIZER, "include");
        op.add(Builder::maxDocCount, JsonpDeserializer.longDeserializer(), "max_doc_count");
        op.add(Builder::missing, FieldValue._DESERIALIZER, "missing");
        op.add(Builder::precision, JsonpDeserializer.doubleDeserializer(), "precision");
        op.add(Builder::valueType, JsonpDeserializer.stringDeserializer(), "value_type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.exclude);
        result = 31 * result + Objects.hashCode(this.field);
        result = 31 * result + Objects.hashCode(this.include);
        result = 31 * result + Objects.hashCode(this.maxDocCount);
        result = 31 * result + Objects.hashCode(this.missing);
        result = 31 * result + Objects.hashCode(this.precision);
        result = 31 * result + Objects.hashCode(this.valueType);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RareTermsAggregation other = (RareTermsAggregation)o;
        return Objects.equals(this.exclude, other.exclude) && Objects.equals(this.field, other.field) && Objects.equals(this.include, other.include) && Objects.equals(this.maxDocCount, other.maxDocCount) && Objects.equals(this.missing, other.missing) && Objects.equals(this.precision, other.precision) && Objects.equals(this.valueType, other.valueType);
    }

    public static class Builder
    extends BucketAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, RareTermsAggregation> {
        @Nullable
        private TermsExclude exclude;
        @Nullable
        private String field;
        @Nullable
        private TermsInclude include;
        @Nullable
        private Long maxDocCount;
        @Nullable
        private FieldValue missing;
        @Nullable
        private Double precision;
        @Nullable
        private String valueType;

        public Builder() {
        }

        private Builder(RareTermsAggregation o) {
            super(o);
            this.exclude = o.exclude;
            this.field = o.field;
            this.include = o.include;
            this.maxDocCount = o.maxDocCount;
            this.missing = o.missing;
            this.precision = o.precision;
            this.valueType = o.valueType;
        }

        private Builder(Builder o) {
            super(o);
            this.exclude = o.exclude;
            this.field = o.field;
            this.include = o.include;
            this.maxDocCount = o.maxDocCount;
            this.missing = o.missing;
            this.precision = o.precision;
            this.valueType = o.valueType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder exclude(@Nullable TermsExclude value) {
            this.exclude = value;
            return this;
        }

        @Nonnull
        public final Builder exclude(Function<TermsExclude.Builder, ObjectBuilder<TermsExclude>> fn) {
            return this.exclude(fn.apply(new TermsExclude.Builder()).build());
        }

        @Nonnull
        public final Builder field(@Nullable String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder include(@Nullable TermsInclude value) {
            this.include = value;
            return this;
        }

        @Nonnull
        public final Builder include(Function<TermsInclude.Builder, ObjectBuilder<TermsInclude>> fn) {
            return this.include(fn.apply(new TermsInclude.Builder()).build());
        }

        @Nonnull
        public final Builder maxDocCount(@Nullable Long value) {
            this.maxDocCount = value;
            return this;
        }

        @Nonnull
        public final Builder missing(@Nullable FieldValue value) {
            this.missing = value;
            return this;
        }

        @Nonnull
        public final Builder missing(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.missing(fn.apply(new FieldValue.Builder()).build());
        }

        @Nonnull
        public final Builder precision(@Nullable Double value) {
            this.precision = value;
            return this;
        }

        @Nonnull
        public final Builder valueType(@Nullable String value) {
            this.valueType = value;
            return this;
        }

        @Override
        @Nonnull
        public RareTermsAggregation build() {
            this._checkSingleUse();
            return new RareTermsAggregation(this);
        }
    }
}

