/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer.memory;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryRequest;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.helper.MemoryEmbeddingHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportUpdateMemoryAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUpdateMemoryAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MemoryEmbeddingHelper memoryEmbeddingHelper;

    @Inject
    public TransportUpdateMemoryAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting, MLModelManager mlModelManager, MemoryContainerHelper memoryContainerHelper, MemoryEmbeddingHelper memoryEmbeddingHelper) {
        super("cluster:admin/opensearch/ml/memory_containers/memory/update", transportService, actionFilters, MLUpdateMemoryRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.mlModelManager = mlModelManager;
        this.memoryContainerHelper = memoryContainerHelper;
        this.memoryEmbeddingHelper = memoryEmbeddingHelper;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLUpdateMemoryRequest updateRequest = MLUpdateMemoryRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = updateRequest.getMemoryContainerId();
        String memoryId = updateRequest.getMemoryId();
        String newText = updateRequest.getMlUpdateMemoryInput().getText();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to update memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            if (!this.memoryContainerHelper.validateMemoryIndexExists((MLMemoryContainer)container, "update", actionListener)) {
                return;
            }
            String memoryIndexName = this.memoryContainerHelper.getMemoryIndexName((MLMemoryContainer)container);
            GetRequest getRequest = new GetRequest(memoryIndexName, memoryId);
            this.client.get(getRequest, ActionListener.wrap(getResponse -> {
                if (!getResponse.isExists()) {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Memory not found", RestStatus.NOT_FOUND, new Object[0]));
                    return;
                }
                HashMap<String, Object> updateFields = new HashMap<String, Object>();
                updateFields.put("memory", newText);
                updateFields.put("last_updated_time", Instant.now().toEpochMilli());
                MemoryStorageConfig storageConfig = container.getMemoryStorageConfig();
                if (storageConfig != null && storageConfig.isSemanticStorageEnabled()) {
                    this.memoryEmbeddingHelper.generateEmbedding(newText, storageConfig, (ActionListener<Object>)ActionListener.wrap(embedding -> {
                        if (embedding != null) {
                            updateFields.put("memory_embedding", embedding);
                        }
                        this.performUpdate(memoryIndexName, memoryId, updateFields, actionListener);
                    }, error -> {
                        log.error("Failed to generate embedding for memory update, proceeding without embedding", (Throwable)error);
                        this.performUpdate(memoryIndexName, memoryId, updateFields, actionListener);
                    }));
                } else {
                    this.performUpdate(memoryIndexName, memoryId, updateFields, actionListener);
                }
            }, arg_0 -> ((ActionListener)actionListener).onFailure(arg_0)));
        }, arg_0 -> actionListener.onFailure(arg_0)));
    }

    private void performUpdate(String indexName, String memoryId, Map<String, Object> updateFields, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(indexName, memoryId).doc(updateFields);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            log.error("Failed to update memory {}", (Object)memoryId, (Object)e);
            listener.onFailure(e);
        }
    }
}

