/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 92\u00020\u00012\u00020\u0002:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B1\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eBE\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001dJ\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\t\u0010!\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0007H\u00c6\u0003J\t\u0010#\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\rH\u00c6\u0003JS\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020+H\u0002J\u0013\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010\u001eH\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\t\u00100\u001a\u00020\u0007H\u00d6\u0001J\u0018\u00101\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u00102\u001a\u000203H\u0016J\u000e\u00104\u001a\u00020(2\u0006\u0010)\u001a\u00020(J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006:"}, d2={"Lorg/opensearch/commons/alerting/model/Comment;", "Lorg/opensearch/core/common/io/stream/Writeable;", "Lorg/opensearch/core/xcontent/ToXContent;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "entityId", "", "entityType", "content", "createdTime", "Ljava/time/Instant;", "user", "Lorg/opensearch/commons/authuser/User;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Lorg/opensearch/commons/authuser/User;)V", "id", "lastUpdatedTime", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/commons/authuser/User;)V", "getContent", "()Ljava/lang/String;", "getCreatedTime", "()Ljava/time/Instant;", "getEntityId", "getEntityType", "getId", "getLastUpdatedTime", "getUser", "()Lorg/opensearch/commons/authuser/User;", "asTemplateArg", "", "", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "createXContentBuilder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "includeFullUser", "", "equals", "other", "hashCode", "", "toString", "toXContent", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "common-utils"})
public final class Comment
implements Writeable,
ToXContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String entityId;
    @NotNull
    private final String entityType;
    @NotNull
    private final String content;
    @NotNull
    private final Instant createdTime;
    @Nullable
    private final Instant lastUpdatedTime;
    @Nullable
    private final User user;
    @NotNull
    public static final String ENTITY_ID_FIELD = "entity_id";
    @NotNull
    public static final String ENTITY_TYPE_FIELD = "entity_type";
    @NotNull
    public static final String COMMENT_CONTENT_FIELD = "content";
    @NotNull
    public static final String COMMENT_CREATED_TIME_FIELD = "created_time";
    @NotNull
    public static final String COMMENT_LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String COMMENT_USER_FIELD = "user";
    @NotNull
    public static final String NO_ID = "";

    public Comment(@NotNull String id, @NotNull String entityId, @NotNull String entityType, @NotNull String content, @NotNull Instant createdTime, @Nullable Instant lastUpdatedTime, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)content, (String)COMMENT_CONTENT_FIELD);
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        this.id = id;
        this.entityId = entityId;
        this.entityType = entityType;
        this.content = content;
        this.createdTime = createdTime;
        this.lastUpdatedTime = lastUpdatedTime;
        this.user = user;
    }

    public /* synthetic */ Comment(String string, String string2, String string3, String string4, Instant instant, Instant instant2, User user, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = NO_ID;
        }
        if ((n & 2) != 0) {
            string2 = NO_ID;
        }
        this(string, string2, string3, string4, instant, instant2, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getEntityId() {
        return this.entityId;
    }

    @NotNull
    public final String getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final String getContent() {
        return this.content;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @Nullable
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public Comment(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readString(...)");
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readString(...)");
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        this(string, string2, string3, string4, instant, sin.readOptionalInstant(), sin.readBoolean() ? new User(sin) : null);
    }

    public Comment(@NotNull String entityId, @NotNull String entityType, @NotNull String content, @NotNull Instant createdTime, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)content, (String)COMMENT_CONTENT_FIELD);
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        this(null, entityId, entityType, content, createdTime, null, user, 1, null);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        block0: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeString(this.entityId);
            out.writeString(this.entityType);
            out.writeString(this.content);
            out.writeInstant(this.createdTime);
            out.writeOptionalInstant(this.lastUpdatedTime);
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user == null) break block0;
            user.writeTo(out);
        }
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)"_id", (Object)this.id);
        pairArray[1] = TuplesKt.to((Object)ENTITY_ID_FIELD, (Object)this.entityId);
        pairArray[2] = TuplesKt.to((Object)ENTITY_TYPE_FIELD, (Object)this.entityType);
        pairArray[3] = TuplesKt.to((Object)COMMENT_CONTENT_FIELD, (Object)this.content);
        pairArray[4] = TuplesKt.to((Object)COMMENT_CREATED_TIME_FIELD, (Object)this.createdTime);
        pairArray[5] = TuplesKt.to((Object)COMMENT_LAST_UPDATED_TIME_FIELD, (Object)this.lastUpdatedTime);
        User user = this.user;
        pairArray[6] = TuplesKt.to((Object)COMMENT_USER_FIELD, (Object)(user != null ? user.getName() : null));
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, false);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        return this.createXContentBuilder(builder, true);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, boolean includeFullUser) {
        XContentBuilder xContentBuilder = builder.startObject().field(ENTITY_ID_FIELD, this.entityId).field(ENTITY_TYPE_FIELD, this.entityType).field(COMMENT_CONTENT_FIELD, this.content);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        IndexUtilsKt.optionalTimeField(IndexUtilsKt.optionalTimeField(xContentBuilder, COMMENT_CREATED_TIME_FIELD, this.createdTime), COMMENT_LAST_UPDATED_TIME_FIELD, this.lastUpdatedTime);
        if (includeFullUser) {
            IndexUtilsKt.optionalUserField(builder, COMMENT_USER_FIELD, this.user);
        } else {
            IndexUtilsKt.optionalUsernameField(builder, COMMENT_USER_FIELD, this.user);
        }
        builder.endObject();
        return builder;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.entityId;
    }

    @NotNull
    public final String component3() {
        return this.entityType;
    }

    @NotNull
    public final String component4() {
        return this.content;
    }

    @NotNull
    public final Instant component5() {
        return this.createdTime;
    }

    @Nullable
    public final Instant component6() {
        return this.lastUpdatedTime;
    }

    @Nullable
    public final User component7() {
        return this.user;
    }

    @NotNull
    public final Comment copy(@NotNull String id, @NotNull String entityId, @NotNull String entityType, @NotNull String content, @NotNull Instant createdTime, @Nullable Instant lastUpdatedTime, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)entityId, (String)"entityId");
        Intrinsics.checkNotNullParameter((Object)entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)content, (String)COMMENT_CONTENT_FIELD);
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        return new Comment(id, entityId, entityType, content, createdTime, lastUpdatedTime, user);
    }

    public static /* synthetic */ Comment copy$default(Comment comment, String string, String string2, String string3, String string4, Instant instant, Instant instant2, User user, int n, Object object) {
        if ((n & 1) != 0) {
            string = comment.id;
        }
        if ((n & 2) != 0) {
            string2 = comment.entityId;
        }
        if ((n & 4) != 0) {
            string3 = comment.entityType;
        }
        if ((n & 8) != 0) {
            string4 = comment.content;
        }
        if ((n & 0x10) != 0) {
            instant = comment.createdTime;
        }
        if ((n & 0x20) != 0) {
            instant2 = comment.lastUpdatedTime;
        }
        if ((n & 0x40) != 0) {
            user = comment.user;
        }
        return comment.copy(string, string2, string3, string4, instant, instant2, user);
    }

    @NotNull
    public String toString() {
        return "Comment(id=" + this.id + ", entityId=" + this.entityId + ", entityType=" + this.entityType + ", content=" + this.content + ", createdTime=" + this.createdTime + ", lastUpdatedTime=" + this.lastUpdatedTime + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + this.entityId.hashCode();
        result = result * 31 + this.entityType.hashCode();
        result = result * 31 + this.content.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + (this.lastUpdatedTime == null ? 0 : this.lastUpdatedTime.hashCode());
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Comment)) {
            return false;
        }
        Comment comment = (Comment)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)comment.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.entityId, (Object)comment.entityId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.entityType, (Object)comment.entityType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.content, (Object)comment.content)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)comment.createdTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)comment.lastUpdatedTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)comment.user);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Comment parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @NotNull
    public static final Comment readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Comment parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/commons/alerting/model/Comment$Companion;", "", "()V", "COMMENT_CONTENT_FIELD", "", "COMMENT_CREATED_TIME_FIELD", "COMMENT_LAST_UPDATED_TIME_FIELD", "COMMENT_USER_FIELD", "ENTITY_ID_FIELD", "ENTITY_TYPE_FIELD", "NO_ID", "parse", "Lorg/opensearch/commons/alerting/model/Comment;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Comment parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Instant instant;
            String string;
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String entityId = null;
            String entityType = null;
            String content = Comment.NO_ID;
            Instant createdTime = null;
            Instant lastUpdatedTime = null;
            User user = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string2 = fieldName;
                if (string2 == null) continue;
                int n = -1;
                switch (string2.hashCode()) {
                    case 2003148228: {
                        if (string2.equals(Comment.COMMENT_CREATED_TIME_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case 1281710614: {
                        if (string2.equals(Comment.ENTITY_TYPE_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case -1670470950: {
                        if (string2.equals(Comment.COMMENT_LAST_UPDATED_TIME_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case -740565257: {
                        if (string2.equals(Comment.ENTITY_ID_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 3599307: {
                        if (string2.equals(Comment.COMMENT_USER_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 951530617: {
                        if (string2.equals(Comment.COMMENT_CONTENT_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 4: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 2: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 6: {
                        Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"text(...)");
                        break;
                    }
                    case 1: {
                        if (IndexUtilsKt.instant(xcp) == null) {
                            String string3 = "Required value was null.";
                            throw new IllegalArgumentException(string3.toString());
                        }
                        break;
                    }
                    case 3: {
                        lastUpdatedTime = IndexUtilsKt.instant(xcp);
                        break;
                    }
                    case 5: {
                        user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse(xcp);
                    }
                }
            }
            String string4 = entityId;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entityId");
                string4 = null;
            }
            if ((string = entityType) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"entityType");
                string = null;
            }
            if ((instant = createdTime) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"createdTime");
                instant = null;
            }
            return new Comment(id, string4, string, content, instant, lastUpdatedTime, user);
        }

        public static /* synthetic */ Comment parse$default(Companion companion, XContentParser xContentParser, String string, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Comment.NO_ID;
            }
            return companion.parse(xContentParser, string);
        }

        @JvmStatic
        @NotNull
        public final Comment readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Comment(sin);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Comment parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.commons.alerting.model.Comment$Companion.parse$default(this, xcp, null, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

