/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.sql.completion.cloud.context;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/ml/llm/sql/completion/cloud/context/TextTracker;", "Lcom/intellij/openapi/util/ModificationTracker;", "e", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "state", "Ljava/util/concurrent/atomic/AtomicReference;", "Lcom/intellij/ml/llm/sql/completion/cloud/context/TextTracker$State;", "kotlin.jvm.PlatformType", "currentPsiCount", "", "computeHash", "", "nextState", "s", "getModificationCount", "State", "intellij.ml.llm.sql.completion"})
public final class TextTracker
implements ModificationTracker {
    @NotNull
    private final PsiElement e;
    @NotNull
    private final AtomicReference<State> state;

    public TextTracker(@NotNull PsiElement e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.e = e;
        this.state = new AtomicReference<State>(new State(0L, this.currentPsiCount(), this.computeHash()));
    }

    private final long currentPsiCount() {
        return PsiModificationTracker.getInstance((Project)this.e.getProject()).getModificationCount();
    }

    private final int computeHash() {
        return this.e.getText().hashCode();
    }

    private final State nextState(State s) {
        long cpc = this.currentPsiCount();
        if (cpc == s.getPsiCount()) {
            return s;
        }
        int curHash = this.computeHash();
        if (curHash == s.getTextHash()) {
            return State.copy$default(s, 0L, cpc, 0, 5, null);
        }
        return new State(s.getCount() + 1L, cpc, curHash);
    }

    public long getModificationCount() {
        State next;
        State prev;
        do {
            prev = this.state.get();
            Intrinsics.checkNotNull((Object)prev);
        } while (prev != (next = this.nextState(prev)) && !this.state.compareAndSet(prev, next));
        return next.getCount();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ml/llm/sql/completion/cloud/context/TextTracker$State;", "", "count", "", "psiCount", "textHash", "", "<init>", "(JJI)V", "getCount", "()J", "getPsiCount", "getTextHash", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.ml.llm.sql.completion"})
    public static final class State {
        private final long count;
        private final long psiCount;
        private final int textHash;

        public State(long count, long psiCount, int textHash) {
            this.count = count;
            this.psiCount = psiCount;
            this.textHash = textHash;
        }

        public final long getCount() {
            return this.count;
        }

        public final long getPsiCount() {
            return this.psiCount;
        }

        public final int getTextHash() {
            return this.textHash;
        }

        public final long component1() {
            return this.count;
        }

        public final long component2() {
            return this.psiCount;
        }

        public final int component3() {
            return this.textHash;
        }

        @NotNull
        public final State copy(long count, long psiCount, int textHash) {
            return new State(count, psiCount, textHash);
        }

        public static /* synthetic */ State copy$default(State state, long l, long l2, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                l = state.count;
            }
            if ((n2 & 2) != 0) {
                l2 = state.psiCount;
            }
            if ((n2 & 4) != 0) {
                n = state.textHash;
            }
            return state.copy(l, l2, n);
        }

        @NotNull
        public String toString() {
            return "State(count=" + this.count + ", psiCount=" + this.psiCount + ", textHash=" + this.textHash + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.count);
            result2 = result2 * 31 + Long.hashCode(this.psiCount);
            result2 = result2 * 31 + Integer.hashCode(this.textHash);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state = (State)other;
            if (this.count != state.count) {
                return false;
            }
            if (this.psiCount != state.psiCount) {
                return false;
            }
            return this.textHash == state.textHash;
        }
    }
}

