/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.BaseInclusionModel;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J\u0016\u0010\u0018\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016R\u0016\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel;", "Lcom/intellij/openapi/vcs/changes/ui/BaseInclusionModel;", "inclusionHashingStrategy", "Lcom/intellij/util/containers/HashingStrategy;", "", "<init>", "(Lcom/intellij/util/containers/HashingStrategy;)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "inclusion", "", "getInclusion", "", "getInclusionState", "Lcom/intellij/util/ui/ThreeStateCheckBox$State;", "item", "isInclusionEmpty", "", "addInclusion", "", "items", "", "removeInclusion", "setInclusion", "retainInclusion", "clearInclusion", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nDefaultInclusionModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultInclusionModel.kt\ncom/intellij/openapi/vcs/changes/ui/DefaultInclusionModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class DefaultInclusionModel
extends BaseInclusionModel {
    @Nullable
    private final HashingStrategy<Object> inclusionHashingStrategy;
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Set<Object> inclusion;

    public DefaultInclusionModel(@Nullable HashingStrategy<Object> inclusionHashingStrategy) {
        Set set;
        this.inclusionHashingStrategy = inclusionHashingStrategy;
        this.lock = new ReentrantReadWriteLock();
        if (this.inclusionHashingStrategy == null) {
            set = new HashSet();
        } else {
            Set set2 = CollectionFactory.createCustomHashingStrategySet(this.inclusionHashingStrategy);
            set = set2;
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"createCustomHashingStrategySet(...)");
        }
        this.inclusion = set;
    }

    public /* synthetic */ DefaultInclusionModel(HashingStrategy hashingStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            hashingStrategy = null;
        }
        this((HashingStrategy<Object>)hashingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<Object> getInclusion() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            Set set;
            boolean bl = false;
            if (this.inclusionHashingStrategy == null) {
                set = new HashSet(this.inclusion);
            } else {
                Set set2;
                Set it = set2 = CollectionFactory.createCustomHashingStrategySet(this.inclusionHashingStrategy);
                boolean bl2 = false;
                it.addAll((Collection)this.inclusion);
                set = set2;
            }
            Set set3 = set;
            Intrinsics.checkNotNull((Object)set3);
            Set set4 = set3;
            Set<Object> set5 = Collections.unmodifiableSet(set4);
            Intrinsics.checkNotNullExpressionValue(set5, (String)"unmodifiableSet(...)");
            Set<Object> set6 = set5;
            return set6;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ThreeStateCheckBox.State getInclusionState(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean isIncluded = this.inclusion.contains(item);
            ThreeStateCheckBox.State state = isIncluded ? ThreeStateCheckBox.State.SELECTED : ThreeStateCheckBox.State.NOT_SELECTED;
            return state;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInclusionEmpty() {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            boolean bl2 = this.inclusion.isEmpty();
            return bl2;
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInclusion(@NotNull Collection<? extends Object> items) {
        boolean bl;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            bl = this.inclusion.addAll(items);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        boolean wasChanged = bl;
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInclusion(@NotNull Collection<? extends Object> items) {
        boolean bl;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            bl = VcsUtil.removeAllFromSet(this.inclusion, items);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        boolean wasChanged = bl;
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInclusion(@NotNull Collection<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        boolean wasChanged = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Set<Object> oldInclusion = this.getInclusion();
            this.inclusion.clear();
            this.inclusion.addAll(items);
            wasChanged = !Intrinsics.areEqual(oldInclusion, this.inclusion);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retainInclusion(@NotNull Collection<? extends Object> items) {
        boolean bl;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl2 = false;
            bl = this.inclusion.retainAll(items);
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        boolean wasChanged = bl;
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInclusion() {
        boolean wasChanged = false;
        ReentrantReadWriteLock reentrantReadWriteLock = this.lock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            if (!((Collection)this.inclusion).isEmpty()) {
                this.inclusion.clear();
                wasChanged = true;
            } else {
                wasChanged = false;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        if (wasChanged) {
            this.fireInclusionChanged();
        }
    }

    public DefaultInclusionModel() {
        this(null, 1, null);
    }
}

