# -*- coding: utf-8 -*-
# Copyright 2023 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

from __future__ import absolute_import, division, print_function


__metaclass__ = type

#############################################
#                WARNING                    #
#############################################
#
# This file is auto generated by the
# ansible.content_builder.
#
# Manually editing this file is not advised.
#
# To update the argspec make the desired changes
# in the documentation in the module file and re-run
# ansible.content_builder commenting out
# the path to external 'docstring' in build.yaml.
#
##############################################

"""
The arg spec for the nxos_static_routes module
"""


class Static_routesArgs(object):  # pylint: disable=R0903
    """The arg spec for the nxos_static_routes module"""

    argument_spec = {
        "running_config": {"type": "str"},
        "config": {
            "type": "list",
            "elements": "dict",
            "options": {
                "vrf": {"type": "str"},
                "address_families": {
                    "type": "list",
                    "elements": "dict",
                    "options": {
                        "afi": {
                            "type": "str",
                            "choices": ["ipv4", "ipv6"],
                            "required": True,
                        },
                        "routes": {
                            "elements": "dict",
                            "type": "list",
                            "options": {
                                "dest": {"type": "str", "required": True},
                                "next_hops": {
                                    "type": "list",
                                    "elements": "dict",
                                    "options": {
                                        "forward_router_address": {"type": "str"},
                                        "interface": {"type": "str"},
                                        "admin_distance": {"type": "int"},
                                        "route_name": {"type": "str"},
                                        "tag": {"type": "int"},
                                        "track": {"type": "int"},
                                        "dest_vrf": {"type": "str"},
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        "state": {
            "type": "str",
            "choices": [
                "deleted",
                "merged",
                "overridden",
                "replaced",
                "gathered",
                "rendered",
                "parsed",
            ],
            "default": "merged",
        },
    }  # pylint: disable=C0301
