﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>
#include <aws/glue/model/ColumnRowFilter.h>
#include <aws/glue/model/Permission.h>
#include <aws/glue/model/Table.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class GetUnfilteredTableMetadataResult {
 public:
  AWS_GLUE_API GetUnfilteredTableMetadataResult() = default;
  AWS_GLUE_API GetUnfilteredTableMetadataResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API GetUnfilteredTableMetadataResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A Table object containing the table metadata.</p>
   */
  inline const Table& GetTable() const { return m_table; }
  template <typename TableT = Table>
  void SetTable(TableT&& value) {
    m_tableHasBeenSet = true;
    m_table = std::forward<TableT>(value);
  }
  template <typename TableT = Table>
  GetUnfilteredTableMetadataResult& WithTable(TableT&& value) {
    SetTable(std::forward<TableT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of column names that the user has been granted access to.</p>
   */
  inline const Aws::Vector<Aws::String>& GetAuthorizedColumns() const { return m_authorizedColumns; }
  template <typename AuthorizedColumnsT = Aws::Vector<Aws::String>>
  void SetAuthorizedColumns(AuthorizedColumnsT&& value) {
    m_authorizedColumnsHasBeenSet = true;
    m_authorizedColumns = std::forward<AuthorizedColumnsT>(value);
  }
  template <typename AuthorizedColumnsT = Aws::Vector<Aws::String>>
  GetUnfilteredTableMetadataResult& WithAuthorizedColumns(AuthorizedColumnsT&& value) {
    SetAuthorizedColumns(std::forward<AuthorizedColumnsT>(value));
    return *this;
  }
  template <typename AuthorizedColumnsT = Aws::String>
  GetUnfilteredTableMetadataResult& AddAuthorizedColumns(AuthorizedColumnsT&& value) {
    m_authorizedColumnsHasBeenSet = true;
    m_authorizedColumns.emplace_back(std::forward<AuthorizedColumnsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A Boolean value that indicates whether the partition location is registered
   * with Lake Formation.</p>
   */
  inline bool GetIsRegisteredWithLakeFormation() const { return m_isRegisteredWithLakeFormation; }
  inline void SetIsRegisteredWithLakeFormation(bool value) {
    m_isRegisteredWithLakeFormationHasBeenSet = true;
    m_isRegisteredWithLakeFormation = value;
  }
  inline GetUnfilteredTableMetadataResult& WithIsRegisteredWithLakeFormation(bool value) {
    SetIsRegisteredWithLakeFormation(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A list of column row filters.</p>
   */
  inline const Aws::Vector<ColumnRowFilter>& GetCellFilters() const { return m_cellFilters; }
  template <typename CellFiltersT = Aws::Vector<ColumnRowFilter>>
  void SetCellFilters(CellFiltersT&& value) {
    m_cellFiltersHasBeenSet = true;
    m_cellFilters = std::forward<CellFiltersT>(value);
  }
  template <typename CellFiltersT = Aws::Vector<ColumnRowFilter>>
  GetUnfilteredTableMetadataResult& WithCellFilters(CellFiltersT&& value) {
    SetCellFilters(std::forward<CellFiltersT>(value));
    return *this;
  }
  template <typename CellFiltersT = ColumnRowFilter>
  GetUnfilteredTableMetadataResult& AddCellFilters(CellFiltersT&& value) {
    m_cellFiltersHasBeenSet = true;
    m_cellFilters.emplace_back(std::forward<CellFiltersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A cryptographically generated query identifier generated by Glue or Lake
   * Formation.</p>
   */
  inline const Aws::String& GetQueryAuthorizationId() const { return m_queryAuthorizationId; }
  template <typename QueryAuthorizationIdT = Aws::String>
  void SetQueryAuthorizationId(QueryAuthorizationIdT&& value) {
    m_queryAuthorizationIdHasBeenSet = true;
    m_queryAuthorizationId = std::forward<QueryAuthorizationIdT>(value);
  }
  template <typename QueryAuthorizationIdT = Aws::String>
  GetUnfilteredTableMetadataResult& WithQueryAuthorizationId(QueryAuthorizationIdT&& value) {
    SetQueryAuthorizationId(std::forward<QueryAuthorizationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Specifies whether the view supports the SQL dialects of one or more different
   * query engines and can therefore be read by those engines.</p>
   */
  inline bool GetIsMultiDialectView() const { return m_isMultiDialectView; }
  inline void SetIsMultiDialectView(bool value) {
    m_isMultiDialectViewHasBeenSet = true;
    m_isMultiDialectView = value;
  }
  inline GetUnfilteredTableMetadataResult& WithIsMultiDialectView(bool value) {
    SetIsMultiDialectView(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates if a table is a materialized view.</p>
   */
  inline bool GetIsMaterializedView() const { return m_isMaterializedView; }
  inline void SetIsMaterializedView(bool value) {
    m_isMaterializedViewHasBeenSet = true;
    m_isMaterializedView = value;
  }
  inline GetUnfilteredTableMetadataResult& WithIsMaterializedView(bool value) {
    SetIsMaterializedView(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The resource ARN of the parent resource extracted from the request.</p>
   */
  inline const Aws::String& GetResourceArn() const { return m_resourceArn; }
  template <typename ResourceArnT = Aws::String>
  void SetResourceArn(ResourceArnT&& value) {
    m_resourceArnHasBeenSet = true;
    m_resourceArn = std::forward<ResourceArnT>(value);
  }
  template <typename ResourceArnT = Aws::String>
  GetUnfilteredTableMetadataResult& WithResourceArn(ResourceArnT&& value) {
    SetResourceArn(std::forward<ResourceArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A flag that instructs the engine not to push user-provided operations into
   * the logical plan of the view during query planning. However, if set this flag
   * does not guarantee that the engine will comply. Refer to the engine's
   * documentation to understand the guarantees provided, if any.</p>
   */
  inline bool GetIsProtected() const { return m_isProtected; }
  inline void SetIsProtected(bool value) {
    m_isProtectedHasBeenSet = true;
    m_isProtected = value;
  }
  inline GetUnfilteredTableMetadataResult& WithIsProtected(bool value) {
    SetIsProtected(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Lake Formation data permissions of the caller on the table. Used to
   * authorize the call when no view context is found.</p>
   */
  inline const Aws::Vector<Permission>& GetPermissions() const { return m_permissions; }
  template <typename PermissionsT = Aws::Vector<Permission>>
  void SetPermissions(PermissionsT&& value) {
    m_permissionsHasBeenSet = true;
    m_permissions = std::forward<PermissionsT>(value);
  }
  template <typename PermissionsT = Aws::Vector<Permission>>
  GetUnfilteredTableMetadataResult& WithPermissions(PermissionsT&& value) {
    SetPermissions(std::forward<PermissionsT>(value));
    return *this;
  }
  inline GetUnfilteredTableMetadataResult& AddPermissions(Permission value) {
    m_permissionsHasBeenSet = true;
    m_permissions.push_back(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The filter that applies to the table. For example when applying the filter in
   * SQL, it would go in the <code>WHERE</code> clause and can be evaluated by using
   * an <code>AND</code> operator with any other predicates applied by the user
   * querying the table.</p>
   */
  inline const Aws::String& GetRowFilter() const { return m_rowFilter; }
  template <typename RowFilterT = Aws::String>
  void SetRowFilter(RowFilterT&& value) {
    m_rowFilterHasBeenSet = true;
    m_rowFilter = std::forward<RowFilterT>(value);
  }
  template <typename RowFilterT = Aws::String>
  GetUnfilteredTableMetadataResult& WithRowFilter(RowFilterT&& value) {
    SetRowFilter(std::forward<RowFilterT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetUnfilteredTableMetadataResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Table m_table;

  Aws::Vector<Aws::String> m_authorizedColumns;

  bool m_isRegisteredWithLakeFormation{false};

  Aws::Vector<ColumnRowFilter> m_cellFilters;

  Aws::String m_queryAuthorizationId;

  bool m_isMultiDialectView{false};

  bool m_isMaterializedView{false};

  Aws::String m_resourceArn;

  bool m_isProtected{false};

  Aws::Vector<Permission> m_permissions;

  Aws::String m_rowFilter;

  Aws::String m_requestId;
  bool m_tableHasBeenSet = false;
  bool m_authorizedColumnsHasBeenSet = false;
  bool m_isRegisteredWithLakeFormationHasBeenSet = false;
  bool m_cellFiltersHasBeenSet = false;
  bool m_queryAuthorizationIdHasBeenSet = false;
  bool m_isMultiDialectViewHasBeenSet = false;
  bool m_isMaterializedViewHasBeenSet = false;
  bool m_resourceArnHasBeenSet = false;
  bool m_isProtectedHasBeenSet = false;
  bool m_permissionsHasBeenSet = false;
  bool m_rowFilterHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
