/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.qm.meta;

import org.jkiss.dbeaver.model.exec.DBCSavepoint;
import org.jkiss.dbeaver.model.qm.meta.QMMConnectionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMMTransactionInfo
extends QMMObject {
    private final QMMConnectionInfo connection;
    private final transient QMMTransactionInfo previous;
    private boolean committed;
    private final transient QMMTransactionSavepointInfo savepointStack = new QMMTransactionSavepointInfo(this, null, null, null);

    QMMTransactionInfo(QMMConnectionInfo connection, QMMTransactionInfo previous) {
        super(QMMetaObjectType.TRANSACTION_INFO);
        this.connection = connection;
        this.previous = previous;
    }

    public QMMTransactionInfo(QMMConnectionInfo connection, long openTime) {
        super(QMMetaObjectType.TRANSACTION_INFO, openTime, openTime);
        this.connection = connection;
        this.previous = null;
    }

    void commit() {
        this.committed = true;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (!sp.isClosed()) {
                sp.close(true);
            }
            sp = sp.getPrevious();
        }
        super.close();
    }

    void rollback(DBCSavepoint toSavepoint) {
        this.committed = false;
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            sp.close(false);
            if (toSavepoint != null && sp.getReference() == toSavepoint) break;
            sp = sp.getPrevious();
        }
        super.close();
    }

    @Override
    public QMMConnectionInfo getConnection() {
        return this.connection;
    }

    public QMMTransactionInfo getPrevious() {
        return this.previous;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public QMMTransactionSavepointInfo getCurrentSavepoint() {
        return this.savepointStack;
    }

    public QMMObject getSavepoint(DBCSavepoint savepoint) {
        QMMTransactionSavepointInfo sp = this.savepointStack;
        while (sp != null) {
            if (sp.getReference() == savepoint) {
                return sp;
            }
            sp = sp.getPrevious();
        }
        return null;
    }

    public String toString() {
        return "TRANSACTION";
    }

    @Override
    public String getText() {
        return this.connection.getText();
    }
}

