/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.freeplane.core.util.Compat;

public class ClassLoaderFactory {
    private static final FilenameFilter jarFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    };

    public static URLClassLoader getClassLoaderForUserLib() {
        List<URL> userJars = ClassLoaderFactory.findJars(new String[]{Compat.getApplicationUserDirectory() + "/lib"});
        URLClassLoader urlClassLoader = new URLClassLoader(userJars.toArray(new URL[userJars.size()]), ClassLoaderFactory.class.getClassLoader());
        return urlClassLoader;
    }

    public static List<URL> jarsInExtDir() {
        String extDirsProperty = System.getProperty("java.ext.dirs");
        String[] strings = extDirsProperty == null ? new String[]{} : extDirsProperty.split(File.pathSeparator);
        return ClassLoaderFactory.findJars(strings);
    }

    public static List<URL> findJars(String[] directories) {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            for (String path : directories) {
                File dir = new File(path);
                if (!dir.isDirectory()) continue;
                for (File file : dir.listFiles(jarFileFilter)) {
                    urls.add(file.toURI().toURL());
                }
            }
            return urls;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

