/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.ai.tools.content;

import java.util.Locale;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.plugin.ai.tools.content.ContentType;

public class ContentTypeConverter {
    private static final String LATEX_PREFIX = "\\latex";
    private static final String UNPARSED_LATEX_PREFIX = "\\unparsedlatex";

    public ContentType toContentType(String freeplaneContentType, boolean isFormula, String rawValue) {
        if (isFormula) {
            return ContentType.FORMULA;
        }
        if (freeplaneContentType == null) {
            if (rawValue != null && HtmlUtils.isHtml((String)rawValue)) {
                return ContentType.HTML;
            }
            return ContentType.PLAIN_TEXT;
        }
        String normalized = freeplaneContentType.trim().toLowerCase(Locale.ROOT);
        if ("auto".equals(normalized) || "html".equals(normalized)) {
            return ContentType.HTML;
        }
        if ("markdown".equals(normalized)) {
            return ContentType.MARKDOWN;
        }
        if ("latex".equals(normalized)) {
            return ContentType.LATEX;
        }
        return ContentType.PLAIN_TEXT;
    }

    public ContentType toTextContentTypeForNode(String nodeFormat, String rawValue) {
        if (this.findLatexPrefix(rawValue) != null) {
            return ContentType.LATEX;
        }
        if (this.isMarkdownFormat(nodeFormat)) {
            return ContentType.MARKDOWN;
        }
        if (this.isLatexFormat(nodeFormat)) {
            return ContentType.LATEX;
        }
        if (rawValue != null && HtmlUtils.isHtml((String)rawValue)) {
            return ContentType.HTML;
        }
        return ContentType.PLAIN_TEXT;
    }

    public String findLatexPrefix(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        String plainValue = HtmlUtils.htmlToPlain((String)rawValue);
        if (this.startsWithPrefix(plainValue, LATEX_PREFIX)) {
            return LATEX_PREFIX;
        }
        if (this.startsWithPrefix(plainValue, UNPARSED_LATEX_PREFIX)) {
            return UNPARSED_LATEX_PREFIX;
        }
        return null;
    }

    public String stripLatexPrefix(String rawValue) {
        if (rawValue == null) {
            return null;
        }
        String plainValue = HtmlUtils.htmlToPlain((String)rawValue);
        if (this.startsWithPrefix(plainValue, LATEX_PREFIX)) {
            return plainValue.substring(LATEX_PREFIX.length() + 1);
        }
        if (this.startsWithPrefix(plainValue, UNPARSED_LATEX_PREFIX)) {
            return plainValue.substring(UNPARSED_LATEX_PREFIX.length() + 1);
        }
        return plainValue;
    }

    private boolean isMarkdownFormat(String nodeFormat) {
        return "markdown".equals(this.normalizeContentType(nodeFormat));
    }

    private boolean isLatexFormat(String nodeFormat) {
        return "latex".equals(this.normalizeContentType(nodeFormat));
    }

    private String normalizeContentType(String contentType) {
        return contentType == null ? null : contentType.trim().toLowerCase(Locale.ROOT);
    }

    private boolean startsWithPrefix(String text, String prefix) {
        if (text == null) {
            return false;
        }
        int startLength = prefix.length() + 1;
        return text.length() > startLength && text.startsWith(prefix) && Character.isWhitespace(text.charAt(startLength - 1));
    }
}

