<!--
* Use this template for documentation issues identified
* by [Vale](https://docs.gitlab.com/development/documentation/testing/vale/)
* or [markdownlint](https://docs.gitlab.com/development/documentation/testing/markdownlint/).
* This template is meant to describe work for first-time contributors or
* for work during Hackathons.
*
* Feature development work should not use this template. Use the Feature Request template instead.
-->

## Hi community contributors! :wave:

Do you want to work on this issue?

- **If the issue is unassigned**, in a comment, type `@docs-hackathon I would like to work on this issue` and a writer will assign it to you.

  To be fair to others, do not ask for more than three issues at a time.

- **If the issue is assigned to someone already**, choose another issue. Do not open a merge request for this issue if you are not assigned.

## To resolve the issue

[Follow these instructions to create a merge request](https://docs.gitlab.com/development/documentation/workflow/#how-to-update-the-docs).

- Don't submit your merge request until after the Hackathon has started.
- Try to address the issue in a single merge request.
- Try to stick to the scope of the issue. If you see other improvements that can be made in the file, open a separate merge request.
- When you create the merge request, select the **Documentation** merge request description template.
- In the merge request's description, add a link to this issue.
- Follow the [commit message guidelines](https://docs.gitlab.com/development/contributing/merge_request_workflow/#commit-messages-guidelines).
  Use three to five words for your commit message, start with message with a capital letter, and do **not** end it in a period.
  Other commit messages can cause the pipeline to fail.

Thank you again for contributing to the GitLab documentation! :tada:

## Documentation issue

/labels ~"documentation" ~"docs-only" ~"documentation" ~"docs::improvement" ~"type::maintenance" ~"maintenance::refactor" ~"Seeking community contributions"  ~"quick win" ~"Technical Writing"
