/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc;

import java.util.Arrays;
import org.keycloak.common.enums.SslRequired;
import org.keycloak.common.util.UriUtils;
import org.keycloak.models.IdentityProviderModel;
import org.keycloak.models.RealmModel;

public class OAuth2IdentityProviderConfig
extends IdentityProviderModel {
    public static final String PKCE_ENABLED = "pkceEnabled";
    public static final String PKCE_METHOD = "pkceMethod";
    public static final String TOKEN_ENDPOINT_URL = "tokenUrl";
    public static final String TOKEN_INTROSPECTION_URL = "tokenIntrospectionUrl";
    public static final String JWT_X509_HEADERS_ENABLED = "jwtX509HeadersEnabled";
    public static final String REQUIRES_SHORT_STATE_PARAMETER = "requiresShortStateParameter";

    public OAuth2IdentityProviderConfig(IdentityProviderModel model) {
        super(model);
    }

    public OAuth2IdentityProviderConfig() {
    }

    public String getAuthorizationUrl() {
        return (String)this.getConfig().get("authorizationUrl");
    }

    public void setAuthorizationUrl(String authorizationUrl) {
        this.getConfig().put("authorizationUrl", authorizationUrl);
    }

    public String getTokenUrl() {
        return (String)this.getConfig().get(TOKEN_ENDPOINT_URL);
    }

    public void setTokenUrl(String tokenUrl) {
        this.getConfig().put(TOKEN_ENDPOINT_URL, tokenUrl);
    }

    public String getUserInfoUrl() {
        return (String)this.getConfig().get("userInfoUrl");
    }

    public void setUserInfoUrl(String userInfoUrl) {
        this.getConfig().put("userInfoUrl", userInfoUrl);
    }

    public String getTokenIntrospectionUrl() {
        return (String)this.getConfig().get(TOKEN_INTROSPECTION_URL);
    }

    public void setTokenIntrospectionUrl(String introspectionEndpointUrl) {
        this.getConfig().put(TOKEN_INTROSPECTION_URL, introspectionEndpointUrl);
    }

    public String getClientId() {
        return (String)this.getConfig().get("clientId");
    }

    public void setClientId(String clientId) {
        this.getConfig().put("clientId", clientId);
    }

    public String getClientAuthMethod() {
        return this.getConfig().getOrDefault("clientAuthMethod", "client_secret_post");
    }

    public void setClientAuthMethod(String clientAuth) {
        this.getConfig().put("clientAuthMethod", clientAuth);
    }

    public String getClientSecret() {
        return (String)this.getConfig().get("clientSecret");
    }

    public void setClientSecret(String clientSecret) {
        this.getConfig().put("clientSecret", clientSecret);
    }

    public String getDefaultScope() {
        return (String)this.getConfig().get("defaultScope");
    }

    public void setDefaultScope(String defaultScope) {
        this.getConfig().put("defaultScope", defaultScope);
    }

    public boolean isJWTAuthentication() {
        return this.getClientAuthMethod().equals("client_secret_jwt") || this.getClientAuthMethod().equals("private_key_jwt");
    }

    public boolean isBasicAuthentication() {
        return this.getClientAuthMethod().equals("client_secret_basic");
    }

    public boolean isUiLocales() {
        return Boolean.valueOf((String)this.getConfig().get("uiLocales"));
    }

    public void setUiLocales(boolean uiLocales) {
        this.getConfig().put("uiLocales", String.valueOf(uiLocales));
    }

    public String getPrompt() {
        return (String)this.getConfig().get("prompt");
    }

    public boolean isRequiresShortStateParameter() {
        return Boolean.parseBoolean((String)this.getConfig().get(REQUIRES_SHORT_STATE_PARAMETER));
    }

    public void setRequiresShortStateParameter(boolean requiresShortStateParameter) {
        this.getConfig().put(REQUIRES_SHORT_STATE_PARAMETER, String.valueOf(requiresShortStateParameter));
    }

    public String getForwardParameters() {
        return (String)this.getConfig().get("forwardParameters");
    }

    public void setForwardParameters(String forwardParameters) {
        this.getConfig().put("forwardParameters", forwardParameters);
    }

    public boolean isPkceEnabled() {
        return Boolean.parseBoolean(this.getConfig().getOrDefault(PKCE_ENABLED, "false"));
    }

    public void setPkceEnabled(boolean enabled) {
        this.getConfig().put(PKCE_ENABLED, String.valueOf(enabled));
    }

    public String getPkceMethod() {
        return (String)this.getConfig().get(PKCE_METHOD);
    }

    public String setPkceMethod(String method) {
        return this.getConfig().put(PKCE_METHOD, method);
    }

    public String getClientAssertionSigningAlg() {
        return (String)this.getConfig().get("clientAssertionSigningAlg");
    }

    public void setClientAssertionSigningAlg(String signingAlg) {
        this.getConfig().put("clientAssertionSigningAlg", signingAlg);
    }

    public String getClientAssertionAudience() {
        return (String)this.getConfig().get("clientAssertionAudience");
    }

    public void setClientAssertionAudience(String audience) {
        this.getConfig().put("clientAssertionAudience", audience);
    }

    public boolean isJwtX509HeadersEnabled() {
        return this.getClientAuthMethod().equals("private_key_jwt") && Boolean.parseBoolean(this.getConfig().getOrDefault(JWT_X509_HEADERS_ENABLED, "false"));
    }

    public void setJwtX509HeadersEnabled(boolean enabled) {
        this.getConfig().put(JWT_X509_HEADERS_ENABLED, String.valueOf(enabled));
    }

    public String getUserIDClaim() {
        return this.getConfig().getOrDefault("userIDClaim", "sub");
    }

    public String getUserNameClaim() {
        return this.getConfig().getOrDefault("userNameClaim", "preferred_username");
    }

    public String getFullNameClaim() {
        return this.getConfig().getOrDefault("fullNameClaim", "name");
    }

    public String getGivenNameClaim() {
        return this.getConfig().getOrDefault("givenNameClaim", "given_name");
    }

    public String getFamilyNameClaim() {
        return this.getConfig().getOrDefault("familyNameClaim", "family_name");
    }

    public String getEmailClaim() {
        return this.getConfig().getOrDefault("emailClaim", "email");
    }

    public void validate(RealmModel realm) {
        SslRequired sslRequired = realm.getSslRequired();
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getAuthorizationUrl(), (String)"authorization_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getTokenUrl(), (String)"token_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getUserInfoUrl(), (String)"userinfo_url");
        UriUtils.checkUrl((SslRequired)sslRequired, (String)this.getTokenIntrospectionUrl(), (String)"tokenIntrospection_url");
        if (this.isPkceEnabled()) {
            String pkceMethod = this.getPkceMethod();
            if (!Arrays.asList("plain", "S256").contains(pkceMethod)) {
                throw new IllegalArgumentException("PKCE Method not supported: " + pkceMethod);
            }
        }
    }
}

