/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function.xml;

import java.util.List;
import org.hibernate.dialect.function.xml.XmlForestFunction;
import org.hibernate.metamodel.model.domain.ReturnableType;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.AliasedExpression;
import org.hibernate.type.spi.TypeConfiguration;

public class H2XmlForestFunction
extends XmlForestFunction {
    public H2XmlForestFunction(TypeConfiguration typeConfiguration) {
        super(typeConfiguration);
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> sqlAstArguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        String separator = "";
        sqlAppender.appendSql('(');
        for (SqlAstNode sqlAstNode : sqlAstArguments) {
            AliasedExpression expression = (AliasedExpression)sqlAstNode;
            sqlAppender.appendSql(separator);
            sqlAppender.appendSql("xmlnode(");
            sqlAppender.appendSingleQuoteEscapedString(expression.getAlias());
            sqlAppender.appendSql(",null,");
            expression.getExpression().accept(walker);
            sqlAppender.appendSql(",false)");
            separator = "||";
        }
        sqlAppender.appendSql(')');
    }
}

