/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.infinispan;

import java.time.Instant;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.FileLookup;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.util.EmbeddedTimeService;
import org.jboss.logging.Logger;
import org.jgroups.JChannel;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.connections.infinispan.TopologyInfo;
import org.keycloak.models.KeycloakSession;
import org.keycloak.spi.infinispan.impl.embedded.CacheConfigurator;

public class InfinispanUtil {
    protected static final Logger logger = Logger.getLogger(InfinispanUtil.class);
    public static final int MAXIMUM_REPLACE_RETRIES = 25;
    private static final Object CHANNEL_INIT_SYNCHRONIZER = new Object();
    public static final TimeService KEYCLOAK_TIME_SERVICE = new EmbeddedTimeService(){

        private long getCurrentTimeMillis() {
            return Time.currentTimeMillis();
        }

        public long wallClockTime() {
            return this.getCurrentTimeMillis();
        }

        public long time() {
            return TimeUnit.MILLISECONDS.toNanos(this.getCurrentTimeMillis());
        }

        public Instant instant() {
            return Instant.ofEpochMilli(this.getCurrentTimeMillis());
        }
    };

    public static TopologyInfo getTopologyInfo(KeycloakSession session) {
        return ((InfinispanConnectionProvider)session.getProvider(InfinispanConnectionProvider.class)).getTopologyInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="26.3", forRemoval=true)
    public static void configureTransport(GlobalConfigurationBuilder gcb, String nodeName, String siteName, String jgroupsUdpMcastAddr, String jgroupsBindAddr, String jgroupsConfigPath) {
        if (nodeName == null) {
            gcb.transport().defaultTransport();
        } else {
            FileLookup fileLookup = FileLookupFactory.newInstance();
            Object object = CHANNEL_INIT_SYNCHRONIZER;
            synchronized (object) {
                String originalMcastAddr = System.getProperty("jgroups.mcast_addr");
                if (jgroupsUdpMcastAddr == null) {
                    System.getProperties().remove("jgroups.mcast_addr");
                } else {
                    System.setProperty("jgroups.mcast_addr", jgroupsUdpMcastAddr);
                }
                String originalBindAddr = System.getProperty("jgroups.bind.address");
                if (jgroupsBindAddr == null) {
                    System.getProperties().remove("jgroups.bind.address");
                } else {
                    System.setProperty("jgroups.bind.address", jgroupsBindAddr);
                }
                try {
                    JChannel channel = new JChannel(fileLookup.lookupFileLocation(jgroupsConfigPath, InfinispanUtil.class.getClassLoader()).openStream());
                    channel.setName(nodeName);
                    JGroupsTransport transport = new JGroupsTransport(channel);
                    TransportConfigurationBuilder transportBuilder = gcb.transport().nodeName(nodeName).siteId(siteName).transport((Transport)transport);
                    if (siteName != null) {
                        transportBuilder.clusterName(siteName);
                    }
                    transportBuilder.jmx().domain("jboss.datagrid-infinispan-" + nodeName).enable();
                    logger.infof("Configured jgroups transport with the channel name: %s", (Object)nodeName);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (originalMcastAddr == null) {
                        System.getProperties().remove("jgroups.mcast_addr");
                    } else {
                        System.setProperty("jgroups.mcast_addr", originalMcastAddr);
                    }
                    if (originalBindAddr == null) {
                        System.getProperties().remove("jgroups.bind.address");
                    } else {
                        System.setProperty("jgroups.bind.address", originalBindAddr);
                    }
                }
            }
        }
    }

    @Deprecated(since="26.3", forRemoval=true)
    public static ConfigurationBuilder createCacheConfigurationBuilder() {
        return CacheConfigurator.createCacheConfigurationBuilder();
    }

    @Deprecated(since="26.3", forRemoval=true)
    public static ConfigurationBuilder getActionTokenCacheConfig() {
        ConfigurationBuilder cb = CacheConfigurator.createCacheConfigurationBuilder();
        cb.memory().whenFull(EvictionStrategy.MANUAL).maxCount(-1L);
        cb.expiration().maxIdle(-1L, TimeUnit.SECONDS).wakeUpInterval(300000L, TimeUnit.SECONDS);
        return cb;
    }

    @Deprecated(since="26.3", forRemoval=true)
    public static ConfigurationBuilder getCrlCacheConfig() {
        return CacheConfigurator.getCrlCacheConfig();
    }

    @Deprecated(since="26.3", forRemoval=true)
    public static ConfigurationBuilder getRevisionCacheConfig(long maxEntries) {
        return CacheConfigurator.getRevisionCacheConfig(maxEntries);
    }

    public static Runnable setTimeServiceToKeycloakTime(EmbeddedCacheManager cacheManager) {
        TimeService previousTimeService = InfinispanUtil.replaceComponent(cacheManager, TimeService.class, KEYCLOAK_TIME_SERVICE, true);
        AtomicReference<TimeService> ref = new AtomicReference<TimeService>(previousTimeService);
        return () -> {
            if (ref.get() == null) {
                logger.warn((Object)"Calling revert of the TimeService when testing TimeService was already reverted");
                return;
            }
            logger.info((Object)"Revert set KeycloakIspnTimeService to the infinispan cacheManager");
            InfinispanUtil.replaceComponent(cacheManager, TimeService.class, ref.getAndSet(null), true);
        };
    }

    private static <T> T replaceComponent(EmbeddedCacheManager cacheMgr, Class<T> componentType, T replacementComponent, boolean rewire) {
        GlobalComponentRegistry cr = GlobalComponentRegistry.of((EmbeddedCacheManager)cacheMgr);
        BasicComponentRegistry bcr = (BasicComponentRegistry)cr.getComponent(BasicComponentRegistry.class);
        ComponentRef old = bcr.getComponent(componentType);
        bcr.replaceComponent(componentType.getName(), replacementComponent, true);
        if (rewire) {
            cr.rewire();
            cr.rewireNamedRegistries();
        }
        return (T)(old != null ? old.wired() : null);
    }
}

