/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.deployment.binder;

import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.micrometer.runtime.MicrometerRecorder;
import io.quarkus.micrometer.runtime.config.MicrometerConfig;
import java.util.function.BooleanSupplier;

public class RedisBinderProcessor {
    static final String OBSERVABLE_CLIENT = "io.quarkus.redis.runtime.client.ObservableRedis";
    static final String METRICS_BEAN_CLASS = "io.quarkus.micrometer.runtime.binder.redis.RedisMetricsBean";
    static final Class<?> OBSERVABLE_CLIENT_CLASS = MicrometerRecorder.getClassForName((String)"io.quarkus.redis.runtime.client.ObservableRedis");

    @BuildStep(onlyIf={RedisMetricsSupportEnabled.class})
    AdditionalBeanBuildItem addRedisClientMetric() {
        return AdditionalBeanBuildItem.unremovableOf((String)METRICS_BEAN_CLASS);
    }

    static class RedisMetricsSupportEnabled
    implements BooleanSupplier {
        MicrometerConfig mConfig;

        RedisMetricsSupportEnabled() {
        }

        @Override
        public boolean getAsBoolean() {
            return OBSERVABLE_CLIENT_CLASS != null && this.mConfig.checkBinderEnabledWithDefault((MicrometerConfig.CapabilityEnabled)this.mConfig.binder().redis());
        }
    }
}

