/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.health.checks;

import io.smallrye.health.checks.HealthChecksLogging;
import java.io.IOException;
import java.net.InetAddress;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;

public class InetAddressHealthCheck
implements HealthCheck {
    static final String DEFAULT_NAME = "Internet Address Check";
    static final int DEFAULT_TIMEOUT = 2000;
    private String host;
    private String name;
    private int timeout;

    public InetAddressHealthCheck(String host) {
        this.host = host;
        this.name = DEFAULT_NAME;
        this.timeout = 2000;
    }

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder healthCheckResponseBuilder = HealthCheckResponse.named((String)this.name);
        healthCheckResponseBuilder.withData("host", this.host);
        try {
            InetAddress addr = InetAddress.getByName(this.host);
            boolean reachable = addr.isReachable(this.timeout);
            if (!reachable) {
                healthCheckResponseBuilder.withData("error", String.format("Host %s not reachable.", this.host));
            }
            healthCheckResponseBuilder.status(reachable);
        }
        catch (IOException e) {
            HealthChecksLogging.logger.inetAddressHealthCheckError(e);
            healthCheckResponseBuilder.withData("error", e.getMessage());
            healthCheckResponseBuilder.down();
        }
        return healthCheckResponseBuilder.build();
    }

    public InetAddressHealthCheck timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public InetAddressHealthCheck name(String name) {
        this.name = name;
        return this;
    }
}

