/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.logging.Level;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnectionStatus;
import oracle.ucp.common.Failoverable;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.jdbc.oracle.FailoverActionResult;
import oracle.ucp.jdbc.oracle.FailoverablePooledConnection;
import oracle.ucp.jdbc.oracle.RACManager;
import oracle.ucp.jdbc.oracle.RACManagerImpl;
import oracle.ucp.util.TaskManager;
import oracle.ucp.util.TimerManager;

class ReplayableRACManagerImpl
extends RACManagerImpl
implements RACManager,
Failoverable {
    static final String CLASS_NAME = ReplayableRACManagerImpl.class.getName();

    ReplayableRACManagerImpl(TaskManager taskManager, TimerManager timerManager, boolean isStrictWebSessionAffinity, boolean isStrictXAAffinity, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(taskManager, timerManager, isStrictWebSessionAffinity, isStrictXAAffinity, diagnosticsCollector);
    }

    @Override
    FailoverActionResult processFailoverAction(FailoverablePooledConnection pc, boolean isAvailableConnection, boolean isPlannedDownEvent, int actionFlag) {
        FailoverActionResult result = FailoverActionResult.NOOP;
        switch (actionFlag) {
            case 0: {
                try {
                    if (!isAvailableConnection && isPlannedDownEvent) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_CLOSE_ON_RETURN);
                        result = FailoverActionResult.MARKED_CLOSE_ON_RETURN;
                        break;
                    }
                    if (!isAvailableConnection) {
                        pc.setStatus(UniversalPooledConnectionStatus.STATUS_RECONNECTING);
                        result = FailoverActionResult.MARKED_BAD;
                        break;
                    }
                    pc.setStatus(UniversalPooledConnectionStatus.STATUS_BAD);
                    result = FailoverActionResult.MARKED_BAD;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.WARNING, CLASS_NAME, "processFailoverAction", "", null, ucpe, new Object[0]);
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
            case 1: {
                if (pc.getStatus() != UniversalPooledConnectionStatus.STATUS_BAD && pc.getStatus() != UniversalPooledConnectionStatus.STATUS_RECONNECTING) {
                    this.trace(Level.FINEST, CLASS_NAME, "processFailoverAction", "AC replugging already happened - no FCF cleanup", null, null, new Object[0]);
                    break;
                }
                try {
                    pc.abort();
                }
                catch (Exception exc) {
                    this.trace(Level.WARNING, CLASS_NAME, "processFailoverAction", "", null, exc, new Object[0]);
                    this.m_errorInfo.append(", ").append(exc.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                try {
                    pc.close(!isAvailableConnection);
                    result = FailoverActionResult.ABORTED_AND_CLOSED;
                }
                catch (UniversalConnectionPoolException ucpe) {
                    this.trace(Level.WARNING, CLASS_NAME, "processFailoverAction", "", null, ucpe, new Object[0]);
                    this.m_errorInfo.append(", ").append(ucpe.getStackTrace()[0].toString());
                    result = FailoverActionResult.FAILED;
                }
                break;
            }
        }
        return result;
    }
}

