/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.List;
import java.util.Objects;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.opensearch.client.ResponseWarningsExtractor;

public class Response {
    private final RequestLine requestLine;
    private final HttpHost host;
    private final ClassicHttpResponse response;

    Response(RequestLine requestLine, HttpHost host, ClassicHttpResponse response) {
        Objects.requireNonNull(requestLine, "requestLine cannot be null");
        Objects.requireNonNull(host, "host cannot be null");
        Objects.requireNonNull(response, "response cannot be null");
        this.requestLine = requestLine;
        this.host = host;
        this.response = response;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public HttpHost getHost() {
        return this.host;
    }

    public StatusLine getStatusLine() {
        return new StatusLine((HttpResponse)this.response);
    }

    public Header[] getHeaders() {
        return this.response.getHeaders();
    }

    public String getHeader(String name) {
        Header header = this.response.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public HttpEntity getEntity() {
        return this.response.getEntity();
    }

    public List<String> getWarnings() {
        return ResponseWarningsExtractor.getWarnings((HttpResponse)this.response);
    }

    public boolean hasWarnings() {
        Header[] warnings = this.response.getHeaders("Warning");
        return warnings != null && warnings.length > 0;
    }

    ClassicHttpResponse getHttpResponse() {
        return this.response;
    }

    public String toString() {
        return "Response{requestLine=" + this.requestLine + ", host=" + this.host + ", response=" + this.getStatusLine() + '}';
    }
}

