/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.profile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.search.internal.ShardSearchRequest;
import org.opensearch.search.profile.NetworkTime;
import org.opensearch.search.profile.ProfileResult;
import org.opensearch.search.profile.ProfileShardResult;
import org.opensearch.search.profile.Profilers;
import org.opensearch.search.profile.aggregation.AggregationProfileShardResult;
import org.opensearch.search.profile.aggregation.AggregationProfiler;
import org.opensearch.search.profile.fetch.FetchProfileShardResult;
import org.opensearch.search.profile.fetch.FetchProfiler;
import org.opensearch.search.profile.query.QueryProfileShardResult;
import org.opensearch.search.profile.query.QueryProfiler;

public final class SearchProfileShardResults
implements Writeable,
ToXContentFragment {
    private static final String SEARCHES_FIELD = "searches";
    private static final String ID_FIELD = "id";
    private static final String SHARDS_FIELD = "shards";
    public static final String PROFILE_FIELD = "profile";
    public static final String INBOUND_NETWORK_FIELD = "inbound_network_time_in_millis";
    public static final String OUTBOUND_NETWORK_FIELD = "outbound_network_time_in_millis";
    private Map<String, ProfileShardResult> shardResults;

    public SearchProfileShardResults(Map<String, ProfileShardResult> shardResults) {
        this.shardResults = Collections.unmodifiableMap(shardResults);
    }

    public SearchProfileShardResults(StreamInput in) throws IOException {
        int size = in.readInt();
        this.shardResults = new HashMap<String, ProfileShardResult>(size);
        for (int i = 0; i < size; ++i) {
            String key = in.readString();
            ProfileShardResult shardResult = new ProfileShardResult(in);
            this.shardResults.put(key, shardResult);
        }
        this.shardResults = Collections.unmodifiableMap(this.shardResults);
    }

    public Map<String, ProfileShardResult> getShardResults() {
        return this.shardResults;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.shardResults.size());
        for (Map.Entry<String, ProfileShardResult> entry : this.shardResults.entrySet()) {
            out.writeString(entry.getKey());
            entry.getValue().writeTo(out);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(PROFILE_FIELD).startArray(SHARDS_FIELD);
        TreeSet<String> sortedKeys = new TreeSet<String>(this.shardResults.keySet());
        for (String key : sortedKeys) {
            builder.startObject();
            builder.field(ID_FIELD, key);
            builder.field(INBOUND_NETWORK_FIELD, this.shardResults.get(key).getNetworkTime().getInboundNetworkTime());
            builder.field(OUTBOUND_NETWORK_FIELD, this.shardResults.get(key).getNetworkTime().getOutboundNetworkTime());
            builder.startArray(SEARCHES_FIELD);
            ProfileShardResult profileShardResult = this.shardResults.get(key);
            for (QueryProfileShardResult result : profileShardResult.getQueryProfileResults()) {
                result.toXContent(builder, params);
            }
            builder.endArray();
            profileShardResult.getAggregationProfileResults().toXContent(builder, params);
            profileShardResult.getFetchProfileResult().toXContent(builder, params);
            builder.endObject();
        }
        builder.endArray().endObject();
        return builder;
    }

    public static SearchProfileShardResults fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        HashMap<String, ProfileShardResult> searchProfileResults = new HashMap<String, ProfileShardResult>();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.START_ARRAY) {
                if (SHARDS_FIELD.equals(parser.currentName())) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        SearchProfileShardResults.parseSearchProfileResultsEntry(parser, searchProfileResults);
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token != XContentParser.Token.START_OBJECT) continue;
            parser.skipChildren();
        }
        return new SearchProfileShardResults(searchProfileResults);
    }

    private static void parseSearchProfileResultsEntry(XContentParser parser, Map<String, ProfileShardResult> searchProfileResults) throws IOException {
        XContentParser.Token token = parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        ArrayList<QueryProfileShardResult> queryProfileResults = new ArrayList<QueryProfileShardResult>();
        AggregationProfileShardResult aggProfileShardResult = null;
        FetchProfileShardResult fetchProfileShardResult = null;
        String id = null;
        String currentFieldName = null;
        long inboundNetworkTime = 0L;
        long outboundNetworkTime = 0L;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (ID_FIELD.equals(currentFieldName)) {
                    id = parser.text();
                    continue;
                }
                if (INBOUND_NETWORK_FIELD.equals(currentFieldName)) {
                    inboundNetworkTime = parser.longValue();
                    continue;
                }
                if (OUTBOUND_NETWORK_FIELD.equals(currentFieldName)) {
                    outboundNetworkTime = parser.longValue();
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (SEARCHES_FIELD.equals(currentFieldName)) {
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        queryProfileResults.add(QueryProfileShardResult.fromXContent(parser));
                    }
                    continue;
                }
                if ("aggregations".equals(currentFieldName)) {
                    aggProfileShardResult = AggregationProfileShardResult.fromXContent(parser);
                    continue;
                }
                if ("fetch".equals(currentFieldName)) {
                    fetchProfileShardResult = FetchProfileShardResult.fromXContent(parser);
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        NetworkTime networkTime = new NetworkTime(inboundNetworkTime, outboundNetworkTime);
        if (fetchProfileShardResult == null) {
            fetchProfileShardResult = new FetchProfileShardResult(Collections.emptyList());
        }
        searchProfileResults.put(id, new ProfileShardResult(queryProfileResults, aggProfileShardResult, fetchProfileShardResult, networkTime));
    }

    public static ProfileShardResult buildShardResults(Profilers profilers, ShardSearchRequest request) {
        List<QueryProfiler> queryProfilers = profilers.getQueryProfilers();
        AggregationProfiler aggProfiler = profilers.getAggregationProfiler();
        FetchProfiler fetchProfiler = profilers.getFetchProfiler();
        ArrayList<QueryProfileShardResult> queryResults = new ArrayList<QueryProfileShardResult>(queryProfilers.size());
        for (QueryProfiler queryProfiler : queryProfilers) {
            QueryProfileShardResult result = new QueryProfileShardResult(queryProfiler.getTree(), queryProfiler.getRewriteTime(), queryProfiler.getCollector());
            queryResults.add(result);
        }
        AggregationProfileShardResult aggResults = new AggregationProfileShardResult(aggProfiler.getTree());
        List<ProfileResult> fetchTree = fetchProfiler.getTree();
        FetchProfileShardResult fetchResult = new FetchProfileShardResult(fetchTree);
        NetworkTime networkTime = new NetworkTime(0L, 0L);
        if (request != null) {
            networkTime.setInboundNetworkTime(request.getInboundNetworkTime());
            networkTime.setOutboundNetworkTime(request.getOutboundNetworkTime());
        }
        return new ProfileShardResult(queryResults, aggResults, fetchResult, networkTime);
    }

    public static ProfileShardResult buildFetchOnlyShardResults(Profilers profilers, ShardSearchRequest request) {
        FetchProfiler fetchProfiler = profilers.getFetchProfiler();
        List<ProfileResult> fetchTree = fetchProfiler.getTree();
        FetchProfileShardResult fetchResult = new FetchProfileShardResult(fetchTree);
        NetworkTime networkTime = new NetworkTime(0L, 0L);
        if (request != null) {
            networkTime.setInboundNetworkTime(request.getInboundNetworkTime());
            networkTime.setOutboundNetworkTime(request.getOutboundNetworkTime());
        }
        return new ProfileShardResult(Collections.emptyList(), new AggregationProfileShardResult(Collections.emptyList()), fetchResult, networkTime);
    }
}

