/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensearch.cli.SuppressForbidden;
import org.opensearch.tools.cli.fips.truststore.CommonOptions;
import org.opensearch.tools.cli.fips.truststore.ConfigurationService;
import org.opensearch.tools.cli.fips.truststore.FipsTrustStoreExceptionHandler;
import org.opensearch.tools.cli.fips.truststore.GeneratedTrustStoreCommand;
import org.opensearch.tools.cli.fips.truststore.ShowProvidersCommand;
import org.opensearch.tools.cli.fips.truststore.SystemTrustStoreCommand;
import org.opensearch.tools.cli.fips.truststore.TrustStoreService;
import org.opensearch.tools.cli.fips.truststore.UserInteractionService;
import picocli.CommandLine;

@CommandLine.Command(name="opensearch-fips-demo-installer", description={"OpenSearch FIPS Demo Configuration Installer"}, subcommands={GeneratedTrustStoreCommand.class, SystemTrustStoreCommand.class, ShowProvidersCommand.class}, mixinStandardHelpOptions=true, usageHelpAutoWidth=true, headerHeading="Usage:%n", synopsisHeading="%n", descriptionHeading="%nDescription:%n", parameterListHeading="%nParameters:%n", optionListHeading="%nOptions:%n", commandListHeading="%nCommands:%n")
public class FipsTrustStoreCommand
implements Callable<Integer> {
    private static final CommandLine.Help.ColorScheme COLOR_SCHEME = new CommandLine.Help.ColorScheme.Builder().commands(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.bold, CommandLine.Help.Ansi.Style.underline}).options(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).parameters(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_yellow}).optionParams(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).errors(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.fg_red, CommandLine.Help.Ansi.Style.bold}).stackTraces(new CommandLine.Help.Ansi.IStyle[]{CommandLine.Help.Ansi.Style.italic}).applySystemProperties().build();
    @CommandLine.Spec
    protected CommandLine.Model.CommandSpec spec;
    @CommandLine.Mixin
    protected CommonOptions common;
    @CommandLine.Unmatched
    private List<String> unmatchedArgs;

    @Override
    public final Integer call() {
        if (this.unmatchedArgs != null && !this.unmatchedArgs.isEmpty()) {
            this.spec.commandLine().getOut().println(this.spec.commandLine().getColorScheme().ansi().string("@|yellow Warning: Ignoring unrecognized arguments: " + String.valueOf(this.unmatchedArgs) + "|@"));
        }
        Path confPath = Path.of(System.getProperty("opensearch.path.conf"), new String[0]);
        ConfigurationService.verifyJvmOptionsFile(this.spec, this.common, confPath);
        return new TrustStoreService(UserInteractionService.getInstance()).executeInteractiveSelection(this.spec, this.common, confPath);
    }

    @SuppressForbidden(reason="Allowed to exit explicitly from #main()")
    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new FipsTrustStoreCommand()).setColorScheme(COLOR_SCHEME).setExecutionExceptionHandler((CommandLine.IExecutionExceptionHandler)new FipsTrustStoreExceptionHandler()).execute(args);
        System.exit(exitCode);
    }
}

