/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.jobscheduler.transport.response;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.jobscheduler.spi.LockModel;

public class GetLocksResponse
extends ActionResponse
implements ToXContentObject {
    private Map<String, LockModel> locks;

    public GetLocksResponse() {
        this.locks = new HashMap<String, LockModel>();
    }

    public GetLocksResponse(Map<String, LockModel> locks) {
        this.locks = locks;
    }

    public GetLocksResponse(StreamInput in) throws IOException {
        super(in);
        this.locks = in.readMap(StreamInput::readString, LockModel::new);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.locks.size());
        out.writeMap(this.locks, StreamOutput::writeString, (stream, lock) -> lock.writeTo(stream));
    }

    public Map<String, LockModel> getLocks() {
        return this.locks;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("total_locks", this.locks.size());
        builder.startObject("locks");
        for (Map.Entry<String, LockModel> entry : this.locks.entrySet()) {
            builder.field(entry.getKey());
            entry.getValue().toXContent(builder, params);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }
}

