/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.combination;

import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationTechnique;
import org.opensearch.neuralsearch.processor.combination.ScoreCombinationUtil;
import org.opensearch.neuralsearch.processor.explain.ExplainableTechnique;
import org.opensearch.neuralsearch.processor.explain.ExplanationUtils;

public class HarmonicMeanScoreCombinationTechnique
implements ScoreCombinationTechnique,
ExplainableTechnique {
    public static final String TECHNIQUE_NAME = "harmonic_mean";
    private static final Set<String> SUPPORTED_PARAMS = Set.of("weights");
    private static final Float ZERO_SCORE = Float.valueOf(0.0f);
    private final List<Float> weights;
    private final ScoreCombinationUtil scoreCombinationUtil;

    public HarmonicMeanScoreCombinationTechnique(Map<String, Object> params, ScoreCombinationUtil combinationUtil) {
        this.scoreCombinationUtil = combinationUtil;
        this.scoreCombinationUtil.validateParams(params, SUPPORTED_PARAMS);
        this.weights = this.scoreCombinationUtil.getWeights(params);
    }

    @Override
    public float combine(float[] scores) {
        this.scoreCombinationUtil.validateIfWeightsMatchScores(scores, this.weights);
        float sumOfWeights = 0.0f;
        float sumOfHarmonics = 0.0f;
        for (int indexOfSubQuery = 0; indexOfSubQuery < scores.length; ++indexOfSubQuery) {
            float score = scores[indexOfSubQuery];
            if (score <= 0.0f) continue;
            float weightOfSubQuery = this.scoreCombinationUtil.getWeightForSubQuery(this.weights, indexOfSubQuery);
            sumOfWeights += weightOfSubQuery;
            sumOfHarmonics += weightOfSubQuery / score;
        }
        return sumOfHarmonics > 0.0f ? sumOfWeights / sumOfHarmonics : ZERO_SCORE.floatValue();
    }

    @Override
    public String techniqueName() {
        return TECHNIQUE_NAME;
    }

    @Override
    public String describe() {
        return ExplanationUtils.describeCombinationTechnique(TECHNIQUE_NAME, this.weights);
    }

    @Generated
    public String toString() {
        return "HarmonicMeanScoreCombinationTechnique(TECHNIQUE_NAME=harmonic_mean)";
    }
}

