/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.lucene.search.Query;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryRewriteContext;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.WithFieldName;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.parser.KNNQueryBuilderParser;
import org.opensearch.knn.index.query.parser.MethodParametersParser;
import org.opensearch.knn.index.query.parser.RescoreParser;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.index.util.IndexUtil;
import org.opensearch.neuralsearch.common.MinClusterVersionUtil;
import org.opensearch.neuralsearch.query.NeuralKNNQuery;

public class NeuralKNNQueryBuilder
extends AbstractQueryBuilder<NeuralKNNQueryBuilder>
implements WithFieldName {
    public static final String NAME = "neural_knn";
    public static final String ORIGINAL_QUERY_TEXT_FIELD = "original_query_text";
    private final KNNQueryBuilder knnQueryBuilder;
    private final String originalQueryText;

    public static Builder builder() {
        return new Builder();
    }

    public String fieldName() {
        return this.knnQueryBuilder.fieldName();
    }

    public int k() {
        return this.knnQueryBuilder.getK();
    }

    private NeuralKNNQueryBuilder(KNNQueryBuilder knnQueryBuilder, String originalQueryText) {
        this.knnQueryBuilder = knnQueryBuilder;
        this.originalQueryText = originalQueryText;
    }

    public void doWriteTo(StreamOutput out) throws IOException {
        KNNQueryBuilderParser.streamOutput((StreamOutput)out, (KNNQueryBuilder)this.knnQueryBuilder, IndexUtil::isClusterOnOrAfterMinRequiredVersion);
        if (MinClusterVersionUtil.isVersionOnOrAfterMinReqVersionForNeuralKNNQueryText(out.getVersion())) {
            out.writeOptionalString(this.originalQueryText);
        }
    }

    public NeuralKNNQueryBuilder(StreamInput in) throws IOException {
        this.knnQueryBuilder = new KNNQueryBuilder(in);
        this.originalQueryText = MinClusterVersionUtil.isVersionOnOrAfterMinReqVersionForNeuralKNNQueryText(in.getVersion()) ? in.readOptionalString() : null;
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.knnQueryBuilder.doXContent(builder, params);
    }

    protected QueryBuilder doRewrite(QueryRewriteContext context) throws IOException {
        QueryBuilder rewritten = this.knnQueryBuilder.rewrite(context);
        if (rewritten == this.knnQueryBuilder) {
            return this;
        }
        return new NeuralKNNQueryBuilder((KNNQueryBuilder)rewritten, this.originalQueryText);
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query knnQuery = this.knnQueryBuilder.toQuery(context);
        return new NeuralKNNQuery(knnQuery, this.originalQueryText);
    }

    public String getOriginalQueryText() {
        return this.originalQueryText;
    }

    protected boolean doEquals(NeuralKNNQueryBuilder other) {
        return Objects.equals(this.knnQueryBuilder, other.knnQueryBuilder) && Objects.equals(this.originalQueryText, other.originalQueryText);
    }

    protected int doHashCode() {
        return Objects.hash(this.knnQueryBuilder, this.originalQueryText);
    }

    public String getWriteableName() {
        return NAME;
    }

    public static NeuralKNNQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = parser.currentName();
        KNNQueryBuilder.Builder builder = new KNNQueryBuilder.Builder();
        String originalQueryText = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            String currentFieldName = parser.currentName();
            token = parser.nextToken();
            if (KNNQueryBuilder.VECTOR_FIELD.equals(currentFieldName)) {
                ArrayList<Float> vector = new ArrayList<Float>();
                if (token == XContentParser.Token.START_ARRAY) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        vector.add(Float.valueOf(parser.floatValue()));
                    }
                    float[] vectorArray = new float[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        vectorArray[i] = ((Float)vector.get(i)).floatValue();
                    }
                    builder.vector(vectorArray);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[neural_knn] vector must be an array of floats", new Object[0]);
            }
            if (KNNQueryBuilder.K_FIELD.equals(currentFieldName)) {
                builder.k(Integer.valueOf(parser.intValue()));
                continue;
            }
            if (KNNQueryBuilder.FILTER_FIELD.equals(currentFieldName)) {
                builder.filter(AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)parser));
                continue;
            }
            if (KNNQueryBuilder.MAX_DISTANCE_FIELD.equals(currentFieldName)) {
                builder.maxDistance(Float.valueOf(parser.floatValue()));
                continue;
            }
            if (KNNQueryBuilder.MIN_SCORE_FIELD.equals(currentFieldName)) {
                builder.minScore(Float.valueOf(parser.floatValue()));
                continue;
            }
            if (KNNQueryBuilder.EXPAND_NESTED_FIELD.equals(currentFieldName)) {
                builder.expandNested(Boolean.valueOf(parser.booleanValue()));
                continue;
            }
            if (KNNQueryBuilder.METHOD_PARAMS_FIELD.equals(currentFieldName)) {
                builder.methodParameters(MethodParametersParser.fromXContent((XContentParser)parser));
                continue;
            }
            if (KNNQueryBuilder.RESCORE_FIELD.equals(currentFieldName)) {
                builder.rescoreContext(RescoreParser.fromXContent((XContentParser)parser));
                continue;
            }
            if (ORIGINAL_QUERY_TEXT_FIELD.equals(currentFieldName)) {
                originalQueryText = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[neural_knn] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        KNNQueryBuilder knnBuilder = builder.build();
        return new NeuralKNNQueryBuilder(knnBuilder, originalQueryText);
    }

    @Generated
    public KNNQueryBuilder getKnnQueryBuilder() {
        return this.knnQueryBuilder;
    }

    public static class Builder {
        private String fieldName;
        private float[] vector;
        private Integer k;
        private QueryBuilder filter;
        private Float maxDistance;
        private Float minScore;
        private Boolean expandNested;
        private Map<String, ?> methodParameters;
        private RescoreContext rescoreContext;
        private String originalQueryText;

        private Builder() {
        }

        public Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public Builder vector(float[] vector) {
            this.vector = vector;
            return this;
        }

        public Builder k(Integer k) {
            this.k = k;
            return this;
        }

        public Builder filter(QueryBuilder filter) {
            this.filter = filter;
            return this;
        }

        public Builder maxDistance(Float maxDistance) {
            this.maxDistance = maxDistance;
            return this;
        }

        public Builder minScore(Float minScore) {
            this.minScore = minScore;
            return this;
        }

        public Builder expandNested(Boolean expandNested) {
            this.expandNested = expandNested;
            return this;
        }

        public Builder methodParameters(Map<String, ?> methodParameters) {
            this.methodParameters = methodParameters;
            return this;
        }

        public Builder rescoreContext(RescoreContext rescoreContext) {
            this.rescoreContext = rescoreContext;
            return this;
        }

        public Builder originalQueryText(String originalQueryText) {
            this.originalQueryText = originalQueryText;
            return this;
        }

        public NeuralKNNQueryBuilder build() {
            KNNQueryBuilder knnBuilder = KNNQueryBuilder.builder().fieldName(this.fieldName).vector(this.vector).k(this.k).filter(this.filter).maxDistance(this.maxDistance).minScore(this.minScore).expandNested(this.expandNested).methodParameters(this.methodParameters).rescoreContext(this.rescoreContext).build();
            return new NeuralKNNQueryBuilder(knnBuilder, this.originalQueryText);
        }
    }
}

