/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleSerializers;
import com.fasterxml.jackson.databind.ser.Serializers;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.google.api.client.util.ObjectParser;
import com.google.cloud.StringEnumValue;
import com.google.cloud.storage.CrossTransportUtils;
import com.google.cloud.storage.StorageClass;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

final class XmlObjectParser
implements ObjectParser {
    private final XmlMapper xmlMapper;

    @VisibleForTesting
    public XmlObjectParser(XmlMapper xmlMapper) {
        this.xmlMapper = xmlMapper;
        this.xmlMapper.registerModule((Module)new JavaTimeModule());
        this.xmlMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.xmlMapper.registerModule(new Module(){

            public String getModuleName() {
                return ((Object)((Object)this)).getClass().getPackage().getName();
            }

            public Version version() {
                return Version.unknownVersion();
            }

            public void setupModule(Module.SetupContext context) {
                context.addSerializers((Serializers)new SimpleSerializers((List)ImmutableList.of(new StringEnumValueSerializer(StorageClass.class))));
                context.addDeserializers((Deserializers)new SimpleDeserializers((Map)ImmutableMap.of(StorageClass.class, new StringEnumValueDeserializer(StorageClass.class, StorageClass::valueOf))));
            }
        });
    }

    public <T> T parseAndClose(InputStream in, Charset charset, Class<T> dataClass) throws IOException {
        return this.parseAndClose((Reader)new InputStreamReader(in, charset), dataClass);
    }

    public Object parseAndClose(InputStream in, Charset charset, Type dataType) throws IOException {
        throw new UnsupportedOperationException("XmlObjectParse#" + CrossTransportUtils.fmtMethodName("parseAndClose", InputStream.class, Charset.class, Type.class));
    }

    public <T> T parseAndClose(Reader reader, Class<T> dataClass) throws IOException {
        try (Reader r = reader;){
            Object object = this.xmlMapper.readValue(r, dataClass);
            return (T)object;
        }
    }

    public Object parseAndClose(Reader reader, Type dataType) throws IOException {
        throw new UnsupportedOperationException("XmlObjectParse#" + CrossTransportUtils.fmtMethodName("parseAndClose", Reader.class, Type.class));
    }

    private static final class StringEnumValueSerializer<E extends StringEnumValue>
    extends StdSerializer<E> {
        private StringEnumValueSerializer(Class<E> cl) {
            super(cl);
        }

        public void serialize(E value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.name());
        }
    }

    private static final class StringEnumValueDeserializer<E extends StringEnumValue>
    extends StdDeserializer<E> {
        private final Function<String, E> constructor;

        private StringEnumValueDeserializer(Class<E> cl, Function<String, E> constructor) {
            super(cl);
            this.constructor = constructor;
        }

        public E deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
            String s = (String)p.readValueAs(String.class);
            if (s == null || s.trim().isEmpty()) {
                return null;
            }
            return (E)((StringEnumValue)this.constructor.apply(s));
        }
    }
}

