/*
 * Decompiled with CFR 0.152.
 */
package jcckit.data;

import jcckit.data.DataContainer;
import jcckit.data.DataElement;
import jcckit.data.DataEventType;

public class DataEvent {
    private final DataContainer _container;
    private final DataEventType _type;
    private final int _index;
    private final DataElement _deletedElement;

    private DataEvent(DataContainer container, DataEventType type, int index, DataElement deletedElement) {
        this._container = container;
        this._type = type;
        this._index = index;
        this._deletedElement = deletedElement;
    }

    public static final DataEvent createAddEvent(DataContainer container) {
        return new DataEvent(container, DataEventType.ELEMENT_ADDED, container.getNumberOfElements() - 1, null);
    }

    public static final DataEvent createInsertEvent(DataContainer container, int index) {
        return new DataEvent(container, DataEventType.ELEMENT_INSERTED, index, null);
    }

    public static final DataEvent createReplaceEvent(DataContainer container, int index, DataElement replacedElement) {
        return new DataEvent(container, DataEventType.ELEMENT_REPLACED, index, replacedElement);
    }

    public static final DataEvent createRemoveEvent(DataContainer container, int index, DataElement removedElement) {
        return new DataEvent(container, DataEventType.ELEMENT_REMOVED, index, removedElement);
    }

    public DataContainer getContainer() {
        return this._container;
    }

    public DataEventType getType() {
        return this._type;
    }

    public int getIndex() {
        return this._index;
    }

    public DataElement getDeletedElement() {
        return this._deletedElement;
    }
}

