# Copyright (C) 2024 The Qt Company Ltd.
# SPDX-License-Identifier: BSD-3-Clause


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was QtModuleConfigPrivate.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

# Use original install prefix when loaded through a "/usr move"
# cross-prefix symbolic link such as /lib -> /usr/lib.
get_filename_component(_realCurr "${CMAKE_CURRENT_LIST_DIR}" REALPATH)
get_filename_component(_realOrig "/usr/lib/cmake/Qt63DQuickPrivate" REALPATH)
if(_realCurr STREQUAL _realOrig)
  set(PACKAGE_PREFIX_DIR "/usr")
endif()
unset(_realOrig)
unset(_realCurr)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

cmake_minimum_required(VERSION 3.16...3.21)

include(CMakeFindDependencyMacro)

# Find required dependencies, if any.
if(EXISTS "${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateDependencies.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateDependencies.cmake")
    _qt_internal_suggest_dependency_debugging(3DQuickPrivate
        __qt_3DQuickPrivate_pkg ${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE)
endif()

# If *ConfigDependencies.cmake exists, the variable value will be defined there.
# Don't override it in that case.
if(NOT DEFINED "Qt63DQuickPrivate_FOUND")
    set("Qt63DQuickPrivate_FOUND" TRUE)
endif()

if(NOT __qt_3DQuick_always_load_private_module)
    _qt_internal_show_private_module_warning(3DQuickPrivate)
endif()

# Do the checks inside Targets.cmake even when the file is still being generated
include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateTargetsPrecheck.cmake")

if(NOT __qt_3DQuickPrivate_skip_include_targets_file AND Qt63DQuickPrivate_FOUND)
    include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateTargets.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateAdditionalTargetInfo.cmake")
    include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateExtraProperties.cmake"
        OPTIONAL)
    set(__qt_3DQuickPrivate_targets_file_included ON)
endif()

if(TARGET Qt6::3DQuickPrivate)
    if(NOT QT_NO_CREATE_VERSIONLESS_TARGETS)
        if(CMAKE_VERSION VERSION_LESS 3.18 OR QT_USE_OLD_VERSION_LESS_TARGETS)
            include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateVersionlessTargets.cmake")
        else()
            include("${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateVersionlessAliasTargets.cmake")
        endif()
    endif()
else()
    set(Qt63DQuickPrivate_FOUND FALSE)
    if(NOT DEFINED Qt63DQuickPrivate_NOT_FOUND_MESSAGE)
        set(Qt63DQuickPrivate_NOT_FOUND_MESSAGE
            "Target \"Qt6::3DQuickPrivate\" was not found.")

        if(__qt_3DQuickPrivate_skip_include_targets_file)
            string(APPEND Qt63DQuickPrivate_NOT_FOUND_MESSAGE
                "Possibly due to __qt_3DQuickPrivate_skip_include_targets_file being set to TRUE and thus "
                "${CMAKE_CURRENT_LIST_DIR}/Qt63DQuickPrivateTargets.cmake was not "
                "included to define the target.")
        endif()
    endif()
endif()
