/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.reduction.data;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.apache.solr.analytics.function.reduction.data.ReductionData;
import org.apache.solr.analytics.stream.reservation.ReductionDataReservation;

public abstract class ReductionDataCollector<T extends ReductionData> {
    protected ArrayList<T> lastingTargets = new ArrayList();
    protected ArrayList<T> collectionTargets = new ArrayList();
    protected T ioData;

    protected ReductionDataCollector() {
    }

    public abstract void submitReservations(Consumer<ReductionDataReservation<?, ?>> var1);

    public abstract T newData();

    public void addLastingCollectTarget(ReductionData data) {
        this.lastingTargets.add(data);
    }

    public void clearLastingCollectTargets() {
        this.lastingTargets.clear();
    }

    public T newDataTarget() {
        T data = this.newData();
        this.collectionTargets.add(data);
        return data;
    }

    public void addCollectTarget(ReductionData data) {
        this.collectionTargets.add(data);
    }

    public void collectAndApply() {
        this.collect();
        this.lastingTargets.forEach(target -> this.apply(target));
        this.collectionTargets.forEach(target -> this.apply(target));
        this.collectionTargets.clear();
    }

    protected void collect() {
    }

    protected abstract void apply(T var1);

    public T newDataIO() {
        this.ioData = this.newData();
        return this.ioData;
    }

    public void dataIO(ReductionData data) {
        this.ioData = data;
    }

    public abstract void setMergedData(ReductionData var1);

    public abstract void setData(ReductionData var1);

    public abstract String getName();

    public abstract String getExpressionStr();
}

