/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.solr.api.AnnotatedApi;
import org.apache.solr.api.Api;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.util.CommandOperation;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.solr.handler.admin.SecurityConfHandler;
import org.apache.solr.handler.admin.api.ModifyRuleBasedAuthConfigAPI;
import org.apache.solr.security.AuthorizationContext;
import org.apache.solr.security.AuthorizationPlugin;
import org.apache.solr.security.AuthorizationResponse;
import org.apache.solr.security.AutorizationEditOperation;
import org.apache.solr.security.ConfigEditablePlugin;
import org.apache.solr.security.Permission;
import org.apache.solr.security.PermissionNameProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RuleBasedAuthorizationPluginBase
implements AuthorizationPlugin,
ConfigEditablePlugin,
SpecProvider {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<String, WildCardSupportMap> mapping = new HashMap<String, WildCardSupportMap>();
    private final Map<String, Set<Permission>> roleToPermissionsMap = new HashMap<String, Set<Permission>>();
    private static final Map<String, AutorizationEditOperation> ops = Arrays.stream(AutorizationEditOperation.values()).collect(Collectors.toMap(AutorizationEditOperation::getOperationName, Function.identity()));

    @Override
    public AuthorizationResponse authorize(AuthorizationContext context) {
        List<AuthorizationContext.CollectionRequest> collectionRequests = context.getCollectionRequests();
        if (log.isDebugEnabled()) {
            log.debug("Attempting to authorize request to [{}] of type: [{}], associated with collections [{}]", new Object[]{context.getResource(), context.getRequestType(), collectionRequests});
        }
        if (context.getRequestType() == AuthorizationContext.RequestType.ADMIN) {
            log.debug("Authorizing an ADMIN request, checking admin permissions");
            MatchStatus flag = this.checkCollPerm(this.mapping.get(null), context);
            return flag.rsp;
        }
        for (AuthorizationContext.CollectionRequest collreq : collectionRequests) {
            log.debug("Authorizing collection-aware request, checking perms applicable to specific collection [{}]", (Object)collreq.collectionName);
            MatchStatus flag = this.checkCollPerm(this.mapping.get(collreq.collectionName), context);
            if (flag == MatchStatus.NO_PERMISSIONS_FOUND) continue;
            return flag.rsp;
        }
        log.debug("Authorizing collection-aware request, checking perms applicable to all (*) collections");
        Object flag = this.checkCollPerm(this.mapping.get("*"), context);
        return ((MatchStatus)((Object)flag)).rsp;
    }

    public Set<String> getPermissionNamesForRoles(Collection<String> roles) {
        if (roles == null) {
            return Set.of();
        }
        return roles.stream().filter(this.roleToPermissionsMap::containsKey).flatMap(r -> this.roleToPermissionsMap.get(r).stream()).map(p -> p.name).collect(Collectors.toSet());
    }

    private MatchStatus checkCollPerm(WildCardSupportMap pathVsPerms, AuthorizationContext context) {
        String path;
        MatchStatus flag;
        if (pathVsPerms == null) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        if (log.isTraceEnabled()) {
            log.trace("Following perms are associated with collection");
            for (String pathKey : pathVsPerms.keySet()) {
                List<Permission> permsAssociatedWithPath = pathVsPerms.get(pathKey);
                log.trace("Path: [{}], Perms: [{}]", (Object)pathKey, permsAssociatedWithPath);
            }
        }
        if ((flag = this.checkPathPerm(pathVsPerms.get(path = context.getResource()), context)) != MatchStatus.NO_PERMISSIONS_FOUND) {
            return flag;
        }
        return this.checkPathPerm(pathVsPerms.get(null), context);
    }

    private MatchStatus checkPathPerm(List<Permission> permissions, AuthorizationContext context) {
        if (permissions == null || permissions.isEmpty()) {
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        log.trace("Following perms are associated with this collection and path: [{}]", permissions);
        Permission governingPermission = this.findFirstGoverningPermission(permissions, context);
        if (governingPermission == null) {
            if (log.isDebugEnabled()) {
                log.debug("No perms configured for the resource {} . So allowed to access", (Object)context.getResource());
            }
            return MatchStatus.NO_PERMISSIONS_FOUND;
        }
        if (log.isDebugEnabled()) {
            log.debug("Found perm [{}] to govern resource [{}]", (Object)governingPermission, (Object)context.getResource());
        }
        return this.determineIfPermissionPermitsPrincipal(context, governingPermission);
    }

    private Permission findFirstGoverningPermission(List<Permission> permissions, AuthorizationContext context) {
        for (int i = 0; i < permissions.size(); ++i) {
            Permission permission = permissions.get(i);
            if (!this.permissionAppliesToRequest(permission, context)) continue;
            return permission;
        }
        return null;
    }

    private boolean permissionAppliesToRequest(Permission permission, AuthorizationContext context) {
        if (log.isTraceEnabled()) {
            log.trace("Testing whether permission [{}] applies to request [{}]", (Object)permission, (Object)context.getResource());
        }
        if (PermissionNameProvider.values.containsKey(permission.name)) {
            return this.predefinedPermissionAppliesToRequest(permission, context);
        }
        return this.customPermissionAppliesToRequest(permission, context);
    }

    private boolean predefinedPermissionAppliesToRequest(Permission predefinedPermission, AuthorizationContext context) {
        log.trace("Permission [{}] is a predefined perm", (Object)predefinedPermission);
        if (predefinedPermission.wellknownName == PermissionNameProvider.Name.ALL) {
            log.trace("'ALL' perm applies to all requests; perm applies.");
            return true;
        }
        if (!(context.getHandler() instanceof PermissionNameProvider)) {
            if (log.isTraceEnabled()) {
                log.trace("Request handler [{}] is not a PermissionNameProvider, perm doesnt apply", context.getHandler());
            }
            return false;
        }
        PermissionNameProvider handler = (PermissionNameProvider)context.getHandler();
        PermissionNameProvider.Name permissionName = handler.getPermissionName(context);
        if (permissionName == null) {
            String errorMessage = String.format(Locale.ROOT, "Unable to find 'predefined' associated with requestHandler [%s] and request [%s %s]", handler.getClass().getName(), context.getHttpMethod(), context.getResource());
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, errorMessage);
        }
        boolean applies = permissionName != null && predefinedPermission.name.equals(permissionName.name);
        log.trace("Request handler [{}] is associated with predefined perm [{}]? {}", new Object[]{handler, predefinedPermission.name, applies});
        return applies;
    }

    private boolean customPermissionAppliesToRequest(Permission customPermission, AuthorizationContext context) {
        log.trace("Permission [{}] is a custom permission", (Object)customPermission);
        if (customPermission.method != null && !customPermission.method.contains(context.getHttpMethod())) {
            if (log.isTraceEnabled()) {
                log.trace("Custom permission requires method [{}] but request had method [{}]; permission doesn't apply", customPermission.method, (Object)context.getHttpMethod());
            }
            return false;
        }
        if (customPermission.params != null) {
            for (Map.Entry<String, Function<String[], Boolean>> e : customPermission.params.entrySet()) {
                String[] paramVal = context.getParams().getParams(e.getKey());
                if (e.getValue().apply(paramVal).booleanValue()) continue;
                if (log.isTraceEnabled()) {
                    log.trace("Request has param [{}] which is incompatible with custom perm [{}]; perm doesnt apply", (Object)e.getKey(), (Object)customPermission);
                }
                return false;
            }
        }
        log.trace("Perm [{}] matches method and params for request; permission applies", (Object)customPermission);
        return true;
    }

    private MatchStatus determineIfPermissionPermitsPrincipal(AuthorizationContext context, Permission governingPermission) {
        if (governingPermission.role == null) {
            log.debug("Governing permission [{}] has no role; permitting access", (Object)governingPermission);
            return MatchStatus.PERMITTED;
        }
        Principal principal = context.getUserPrincipal();
        if (principal == null) {
            log.debug("Governing permission [{}] has role, but request principal cannot be identified; forbidding access", (Object)governingPermission);
            return MatchStatus.USER_REQUIRED;
        }
        if (governingPermission.role.contains("*")) {
            log.debug("Governing permission [{}] allows all roles; permitting access", (Object)governingPermission);
            return MatchStatus.PERMITTED;
        }
        Set<String> userRoles = this.getUserRoles(context);
        for (String role : governingPermission.role) {
            if (userRoles == null || !userRoles.contains(role)) continue;
            log.debug("Governing permission [{}] allows access to role [{}]; permitting access", (Object)governingPermission, (Object)role);
            return MatchStatus.PERMITTED;
        }
        log.info("This resource is configured to have a permission {}, The principal {} does not have the right role ", (Object)governingPermission, (Object)principal);
        return MatchStatus.FORBIDDEN;
    }

    public boolean doesUserHavePermission(Principal principal, PermissionNameProvider.Name permission) {
        Set<String> roles = this.getUserRoles(principal);
        if (roles != null) {
            for (String role : roles) {
                List<Permission> permissions;
                if (this.mapping.get(null) == null || (permissions = this.mapping.get(null).get(null)) == null) continue;
                for (Permission p : permissions) {
                    if (!permission.equals((Object)p.wellknownName) || !p.role.contains(role)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void init(Map<String, Object> initInfo) {
        this.mapping.put(null, new WildCardSupportMap());
        List perms = SecurityConfHandler.getListValue(initInfo, "permissions");
        for (Map o : perms) {
            Permission p;
            try {
                p = Permission.load(o);
            }
            catch (Exception exp) {
                log.error("Invalid permission ", (Throwable)exp);
                continue;
            }
            this.add2Mapping(p);
        }
    }

    private void add2Mapping(Permission permission) {
        for (String c : permission.collections) {
            WildCardSupportMap m = this.mapping.computeIfAbsent(c, k -> new WildCardSupportMap());
            for (String path : permission.path) {
                List<Permission> perms = m.get(path);
                if (perms == null) {
                    perms = new ArrayList<Permission>();
                    m.put(path, perms);
                }
                perms.add(permission);
            }
        }
        Collection<String> roles = permission.role != null ? permission.role : Collections.singletonList(null);
        for (String r : roles) {
            Set rm = this.roleToPermissionsMap.computeIfAbsent(r, k -> new HashSet());
            rm.add(permission);
        }
    }

    public Set<String> getUserRoles(AuthorizationContext context) {
        return this.getUserRoles(context.getUserPrincipal());
    }

    public abstract Set<String> getUserRoles(Principal var1);

    @Override
    public void close() throws IOException {
    }

    @Override
    public Map<String, Object> edit(Map<String, Object> latestConf, List<CommandOperation> commands) {
        for (CommandOperation op : commands) {
            AutorizationEditOperation operation = ops.get(op.name);
            if (operation == null) {
                op.unknownOperation();
                return null;
            }
            if ((latestConf = operation.edit(latestConf, op)) != null) continue;
            return null;
        }
        return latestConf;
    }

    public ValidatingJsonMap getSpec() {
        List<Api> apis = AnnotatedApi.getApis(new ModifyRuleBasedAuthConfigAPI());
        return apis.get(0).getSpec();
    }

    static enum MatchStatus {
        USER_REQUIRED(AuthorizationResponse.PROMPT),
        NO_PERMISSIONS_FOUND(AuthorizationResponse.OK),
        PERMITTED(AuthorizationResponse.OK),
        FORBIDDEN(AuthorizationResponse.FORBIDDEN);

        final AuthorizationResponse rsp;

        private MatchStatus(AuthorizationResponse rsp) {
            this.rsp = rsp;
        }
    }

    private static class WildCardSupportMap {
        final Set<String> wildcardPrefixes = new HashSet<String>();
        final Map<String, List<Permission>> delegate = new HashMap<String, List<Permission>>();

        private WildCardSupportMap() {
        }

        public List<Permission> put(String key, List<Permission> value) {
            if (key != null && key.endsWith("/*")) {
                key = key.substring(0, key.length() - 2);
                this.wildcardPrefixes.add(key);
            }
            return this.delegate.put(key, value);
        }

        public List<Permission> get(String key) {
            List<Permission> result = this.delegate.get(key);
            if (key == null || result != null) {
                return result;
            }
            for (String s : this.wildcardPrefixes) {
                List<Permission> wildcardPermissions;
                if (!key.startsWith(s) || (wildcardPermissions = this.delegate.get(s)) == null) continue;
                if (result == null) {
                    result = new ArrayList<Permission>();
                }
                result.addAll(wildcardPermissions);
            }
            return result;
        }

        public Set<String> keySet() {
            return this.delegate.keySet();
        }
    }
}

