/* $Id: ArkRay.h,v 1.4 2002/10/11 01:10:04 zongo Exp $
**
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2002 The Contributors of the Ark Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef ARK_RAY_H
#define ARK_RAY_H

#include <Ark/ArkMath.h>

namespace Ark
{

   class ARK_DLL_API Ray
   {
      public:
	 Vector3 m_From, m_To;
	 Vector3 m_Dir;
	 
	 Ray (const Vector3& from, const Vector3& to) : 
	    m_From (from),
	    m_To (to)
	 {
	    m_Dir = m_To - m_From;
	    m_Dir.Normalize();
	 }

	 bool HitBBox (const BBox &box, Vector3 *coord) const;
	 bool HitTriangle (const Vector3 &vect0,
			   const Vector3 &vect1,
			   const Vector3 &vect2,
			   Vector3 *coord) const;
   };

};

#endif
