/*
** Ark - Libraries, Tools & Programs for MMORPG developpements.
** Copyright (C) 1999-2000 The Contributors of the ArkRPG Project
** Please see the file "AUTHORS" for a list of contributors
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <Ark/ArkTexture.h>
#include <Client/UIRenderer.h>

namespace Client
{
   UIRenderer *g_UI = NULL;
   
   UIRenderer::UIRenderer (Ark::Renderer *renderer,
			   int vbuffersize, int width, int height) :
      m_Renderer (renderer),
      m_Material ("ui-material"),
      m_NumVertices (0)
   {
      m_VBuffer.SetFormat (Ark::VertexBuffer::VB_HAS_COORD|
			   Ark::VertexBuffer::VB_HAS_COLOR|
			   Ark::VertexBuffer::VB_HAS_UV0);
      m_VBuffer.Resize (3*vbuffersize);

      m_Material.m_Flags = Ark::MATERIAL_IS_DOUBLESIDED;
      m_Material.m_Passes[0].m_Flags = (Ark::PASS_HAS_TEXTURE|
					Ark::PASS_HAS_DEPTHFUNC);
      m_Material.m_Passes[0].m_Texture = Ark::TexturePtr();
      m_Material.m_Passes[0].m_DepthFunc = Ark::DEPTHFUNC_ALWAYS;
      m_Material.m_Passes[0].m_AlphaValue = 0.5;
      m_Material.m_Passes[0].m_AlphaFunc = Ark::DEPTHFUNC_GEQUAL;
      m_Material.m_Passes[0].m_BlendSrc = Ark::BLEND_SRC_ALPHA;
      m_Material.m_Passes[0].m_BlendDst = Ark::BLEND_ONE_MINUS_SRC_ALPHA;
      this->width = width;
      this->height = height;
      g_UI = this;
   }

   UIRenderer::~UIRenderer()
   {
   }

   ///////////////////////////////////////////////////////////////

   void
   UIRenderer::SetTexture (const Ark::TexturePtr& texture)
   {
      if (m_NumVertices)
	 Flush();

      if (!texture)
      {
	  m_Material.m_Passes[0].m_Texture = Ark::TexturePtr();
	  m_Material.m_Flags &= ~Ark::MATERIAL_HAS_PASS1;
	  return;
      }

      m_Material.m_Passes[0].m_Texture = texture;

      if (texture->m_Format == Ark::Image::RGBA_8888)
      {
	 m_Material.m_Passes[0].m_Flags |= Ark::PASS_HAS_BLENDING;
	 m_Material.m_Passes[0].m_Flags |= Ark::PASS_HAS_ALPHATEST;
      }
      else
      {
	 m_Material.m_Passes[0].m_Flags &= ~Ark::PASS_HAS_BLENDING;
	 m_Material.m_Passes[0].m_Flags &= ~Ark::PASS_HAS_ALPHATEST;
      }

      m_Material.m_Flags |= Ark::MATERIAL_HAS_PASS1;
   }

   void
   UIRenderer::BeginTriangles ()
   {
      if (m_NumVertices)
	 Flush();
   }

   void
   UIRenderer::Vertex (int x, int y,
		       scalar u, scalar v,
		       uchar r, uchar g, uchar b, uchar a)
   {
      if (m_NumVertices == int(m_VBuffer.Size()))
	 Flush();

      Ark::RGBA rgba = {r,g,b,a};
	  const scalar sx = static_cast<scalar>(x);
	  const scalar sy = static_cast<scalar>(y);
      m_VBuffer.Coord  (m_NumVertices) = Ark::Vector3 (sx, sy, 0.0);
      m_VBuffer.UV0    (m_NumVertices) = Ark::Vector2 (u, v);
      m_VBuffer.Color4 (m_NumVertices) = rgba;

      m_NumVertices++;
   }

   void
   UIRenderer::Flush ()
   {
      if (m_NumVertices == 0)
	 return;

      m_Renderer->RenderBlock (m_Material, Ark::PRIM_TRIANGLES,
			       m_VBuffer, m_NumVertices);

      m_NumVertices = 0;
   }

   void
   UIRenderer::DrawTexturedRectangle (int minx, int miny,
				      int w, int h)
   {
      BeginTriangles();
      Vertex (minx,   miny,   0.0, 0.0);
      Vertex (minx,   miny+h, 0.0, 1.0);
      Vertex (minx+w, miny+h, 1.0, 1.0);

      Vertex (minx+w, miny+h, 1.0, 1.0);
      Vertex (minx+w, miny,   1.0, 0.0);
      Vertex (minx,   miny,   0.0, 0.0);
   }


   ///////////////////////////////////////////////////////////////

   Ark::FontPtr
   UIRenderer::GetFont (const Ark::String &name)
   {
      Ark::FontPtr fp;

      m_Renderer->GetCache().Get (Ark::V_FONT, name, fp);

      return fp;
   }

   void
   UIRenderer::DrawString (Ark::Font *font,
			   const Ark::String &str, int x, int y)
   {
      font->DrawString (*Rdr(), str, x, y);
   }

   void
   UIRenderer::DrawString (const Ark::String &name,
			   const Ark::String &str, int x, int y)
   {
      GetFont(name)->DrawString (*Rdr(), str, x, y);
   }
   
   int
   UIRenderer::GetStringWidth (Ark::Font *font, const Ark::String &str)
   {
      int w;
      font->GetStringSize (str, &w, NULL);
      return w;
   }

   int 
   UIRenderer::GetStringHeight (Ark::Font *font, const Ark::String &str)
   {
      int h;
      font->GetStringSize (str, NULL, &h);
      return h;
   }

   ///////////////////////////////////////////////////////////////
   Ark::Renderer *
   UIRenderer::Rdr()
   {
      return m_Renderer;
   }
}

