# Copyright (C) 2002-2003 Hewlett Packard
# Licensed under the GNU General Public License

# This is to be pulled into the API to define tests
# currently these only work for HP-UX

$GLOBAL_TEST{'Sendmail'}{'sendmaildaemon'} = 
  sub { &B_is_service_off('sendmail'); };

$GLOBAL_TEST{'Sendmail'}{'sendmailcron'} = 
  sub { 
      if (&GetDistro =~ "^HP-UX") {

	  # This is checked differently on Linux.
	  # Possibly, it's checked different ways on different
	  # distributions.

	  my $sendmail = &getGlobal('BIN','sendmail');
	  my $crontab =  &getGlobal('BIN','crontab');
	  # get cronjobs for the root user
	  my @cronjobs = `$crontab -l 2>/dev/null`;
	  # look at each cronjob in the cron listing
	  foreach my $job (@cronjobs) {
	      # if a cronjob matches the sendmail -q command then
	      if($job =~ "$sendmail\\s+\-q") {
		  # found a cronjob for sendmail queue processing
		  # don't ask the question
		  return 1;
	      }
	  }
	  # unable to find a cronjob for sendmail queue processing
	  # ask the question
	  return 0;
      }
      else {

	  # Not yet implemented for Linux.
	  # When we do implement it, we'll have to check for:

	  # 1) /etc/crontab, 
	  # 2) Any files that /etc/crontab points to, including
	  #    the standard Red Hat files listed below:
	  #    /etc/cron.{daily,hourly,weekly,monthly}
	  # 3) /etc/anacrontab if Anacron is on the system

	  return undef;
      }

  };

$GLOBAL_TEST{'Sendmail'}{'vrfyexpn'} = 
  sub { 

      my $sendmail_cf = &getGlobal('FILE',"sendmail.cf");
      my @sendmail_directives = ("O PrivacyOptions=goaway");

      foreach my $directive ( @sendmail_directives ) {
	  if(! &B_match_line("$sendmail_cf","\^\\s*$directive")) {
	      # did not find one of the directives so ask the question.
	      return 0;
	  }
      }

      # found all directives so don't ask the question
      return 1;

  };

1;
