#!/usr/local/bin/python

import re,sys

static_const = re.compile('static (\w+) const')

def fix(text):

    """ SWIG doesn't like 'static int const' members... using 'const int'
        works instead.
    """
    return static_const.sub(r'const \1',text)

def main(infile,outfile):

    text = open(infile,'rb').read()
    text = fix(text)
    open(outfile,'wb').write(text)

if __name__ == '__main__':

    apply(main,tuple(sys.argv[1:]))
    
