#ifndef MXSWIG_I
#define MXSWIG_I
/*---------------------------------------------------------------------------
   mxSWIG.i - Some nice stuff to make SWIG really spin... 

   (c) 1998, Marc-Andre Lemburg; All Rights Reserved; mailto:mal@lemburg.com
   See the documentation for further copyright information or contact
   the author.

  ---------------------------------------------------------------------------*/

/* We catch all C++ exceptions, expecting correct settings in Python's
   thread state. */
%except(python) {
    try {
	$function
    }
    catch (...) {
	$cleanup
	if (!PyErr_Occurred())
	    PyErr_SetString(PyExc_SystemError,
			    "unhandled C++ exception occurred");
	return NULL;
    }
}

/* To pass Python strings we use the direct interface -- that way the
   string length is not lost due to embedded \0s. */
%typemap(python,arginit) PyStringObject * {
    $target = 0;
}
%typemap(python,in) PyStringObject * {
    if (!PyString_Check($source)) {
	PyObject *v;
	
	/* Try to auto-convert */
	v = PyObject_Str($source);
	if (!v) {
	    $cleanup
	    return NULL;
	}
	if (!PyString_Check(v)) {
	    PyErr_SetString(PyExc_TypeError,
			    "__str__ failed to return a string");
	    Py_DECREF(v);
	    $cleanup
	    return NULL;
	}
	$target = (PyStringObject *)v;
    }
    else {
	$target = (PyStringObject *)$source;
	Py_INCREF($target);
    }
}
%typemap(python,freearg) PyStringObject * {
    Py_XDECREF($source);
}

/* Pass PyObjects as-is, only assure that they are non-NULL */
%typemap(python,in) PyObject * {
    if (!$source) {
	PyErr_BadInternalCall();
	return NULL;
    }
    $target = (PyObject *)$source;
}
%typemap(python,out) PyObject * {
    $target = $source;
}

/* Call the module init function initModule() at import time. */
%init %{
	extern int initModule(PyObject *module, PyObject *moddict);

	if (initModule(m,d) != 0)
	     return;
%}

/* EOF */
#endif

