#include <qpixmap.h>
#include <qstyle.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qimage.h>
#include <qstylefactory.h>
#include <qtabbar.h>
#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qscrollbar.h>
#include <qmenubar.h>
#include <qmenudata.h>
#include <qcombobox.h>
#include <qprogressbar.h>
#include <qslider.h>
#include <qspinbox.h> 
#include <qtoolbutton.h>
#include <qapplication.h>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qtabwidget.h>
#include <qtooltip.h>
#include <qdatetime.h>
#include <qlistview.h>
#include <qtextstream.h>
#include <qdeepcopy.h>
/*#include <gconf/gconf-client.h>
#include <gconf/gconf-value.h>
#include <libgnome/libgnome.h>*/
#include <stdio.h>
#include <X11/Xlib.h>
#include <gdk/gdkx.h>

#include <queue>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <unistd.h>

#ifdef USE_SOLARIS
#include <procfs.h>
#endif

#include <gtk/gtknotebook.h>
#include <gtk/gtkgc.h>
#include <gtk/gtkstyle.h>

#include "qt_qt_wrapper.h"
#include "qt_style.h"


bool gtkQtEnable = false;
bool mozillaFix = false;
bool qAppOwner = false;

QStringList appDirList;
typedef QMap<QString, QString> IconMap;
IconMap iconMap[4];
extern int errno;

QScrollBar* meepSBar = 0; 
QWidget* meepWidget = 0;
QWidget* meepWidgetP = 0;
QSlider* meepSlider = 0;
QTabBar* meepTabBar = 0;
GdkGC* altBackGC = 0;
QWidget* smw = 0;

GtkRcStyle* gtkRcStyle = 0;

QStringList kdeSearchPaths;
QString iconTheme;
QString iconThemeDir;
QColor alternateBackgroundColour;

const QPixmap* backgroundTile;
QPixmap* menuBackgroundPixmap;

QPixmap* fillPixmap;

void setFillPixmap(GdkPixbuf* buf)
{
	if (!gtkQtEnable)
		return;
	
	// This code isn't very robust.  It doesn't handle depths other than 24 bits.
	// It sure is fast though!
	int depth = gdk_pixbuf_get_n_channels(buf) * gdk_pixbuf_get_bits_per_sample(buf);
	int width = gdk_pixbuf_get_width(buf);
	int height = gdk_pixbuf_get_height(buf);
	int excess = gdk_pixbuf_get_rowstride(buf) - (width*3);
	
	if (depth != 24)
		return;
	
	QImage fillImage(width, height, 32);
	
	uchar* source = gdk_pixbuf_get_pixels(buf);
	uchar* dest = fillImage.bits();
	
	for (int y=0 ; y<height ; y++)
	{
		for (int x=0 ; x<width ; x++)
		{
			// TODO: Make good on other endiannesses
			dest[0] = source[2];
			dest[1] = source[1];
			dest[2] = source[0];
			dest[3] = '\0';
		
			dest += 4;
			source += 3;
		}
		source += excess;
	}
	
	if (fillPixmap)
		delete fillPixmap;
	fillPixmap = 0;
	fillPixmap = new QPixmap();
	fillPixmap->convertFromImage(fillImage);
	return;
}

		
/* Now to get rid of a ton of un-needed new's across the board.  `new' and `delete' are 
 * non-trivial operations.  You normally just don't notice it; until you're painting a window
 * with 50 widgets, with each paint operation requiring 3-4 news and 3-4 delete's.  The cost
 * of indirection is `not insubstantial'. */

 
static int dummy_x_errhandler( Display *dpy, XErrorEvent *err )
{
	return 0;
}
static int dummy_xio_errhandler( Display * )
{
	return 0;
}


void createQApp()
{
	int argc = 1;
	char** argv;
	// Supply it with fake data to keep KApplication happy
	argv = (char**) malloc(sizeof(char*));
	argv[0] = (char*) malloc(sizeof(char) * 19);
	strncpy(argv[0], "gtk-qt-application", 19);
	
	QString cmdLine;
	
#ifdef USE_SOLARIS
	int pid=getpid();
	char filen[256];
	psinfo_t pfi;
	uintptr_t addr;
	uintptr_t addr2;
	int  i,count,readl, ret=0;
	const char *msg;
	
	sprintf(filen, "/proc/%d/psinfo",pid);
	int fd=open(filen, O_RDONLY);
	if (fd == -1)
	{
		msg = "Open of psinfo failed\n";
		ret = -1;
	}
	else
	{
		readl=read(fd, (void *)&pfi, sizeof(psinfo_t));
		if (readl < 0)
		{
			msg = "Read on as failed\n";
			close(fd);
			ret = -1;
		}
		else
		{
			addr=pfi.pr_argv;
			count=pfi.pr_argc;
		}
		close(fd);
	}
	/* if read of psinfo was success */
	if (!ret)
	{
		sprintf(filen, "/proc/%d/as",pid);
		fd=open(filen, O_RDONLY);
		if (fd == -1)
		{
			msg = "Open of as failed\n";
			ret = -1;
		}
		else
		{
			for (i=0;i<count;i++)
			{
				lseek(fd, addr, SEEK_SET);
				if (pfi.pr_dmodel == PR_MODEL_ILP32)
				{
					addr=addr+4;
					readl=read(fd, (void *)&addr2, 4);
				}
				else
				{
					addr=addr+8;
					readl=read(fd, (void *)&addr2,8);
				}
				if (readl < 0)
				{
					msg = "Read on as failed\n";
					close(fd);
					ret = -1;
					break;
				}
				if (addr2 != 0)
				{
					cmdLine += (char *)addr2;
					cmdLine += " ";
				}
				else
					break;
			}
			close(fd);
		}
	}
	
	if (ret == -1)
	{
		printf("Gtk-Qt theme engine warning:\n");
		printf(msg);
		printf("  This may cause problems for the GNOME window manager\n");
	}
#else // USE_SOLARIS
	QCString cmdlinePath;
	cmdlinePath.sprintf("/proc/%d/cmdline", getpid());
	int fd = open(cmdlinePath, O_RDONLY);
	if (fd == -1)
	{
		printf("Gtk-Qt theme engine warning:\n");
		printf("  Could not open %s\n", (const char*)cmdlinePath);
		printf("  This may cause problems for the GNOME window manager\n");
	}
	else
	{
		while (1)
		{
			char data[80];
			int len = read(fd, data, 80);
			if (len == 0)
				break;
			cmdLine += data;
		}
		close(fd);
	}
#endif // USE_SOLARIS

	if (cmdLine.contains("mozilla") || cmdLine.contains("firefox"))
		mozillaFix = true;
		
	gtkQtDebug = (getenv("GTK_QT_ENGINE_DEBUG") != NULL) ? 1 : 0;
	
	char* sessionEnv = getenv("SESSION_MANAGER");
	if (QString(sessionEnv).endsWith(QString::number(getpid())) || cmdLine.contains("gnome-wm") || cmdLine.contains("metacity") || cmdLine.contains("xfwm4") || (getenv("GTK_QT_ENGINE_DISABLE") != NULL))
	{
		printf("Not initializing the Gtk-Qt theme engine\n");
	}
	else
	{
		int (*original_x_errhandler)( Display *dpy, XErrorEvent * );
		int (*original_xio_errhandler)( Display *dpy );
		original_x_errhandler = XSetErrorHandler( dummy_x_errhandler );
		original_xio_errhandler = XSetIOErrorHandler( dummy_xio_errhandler );
		
#ifndef USE_SOLARIS
		unsetenv("SESSION_MANAGER");
#else
		putenv("SESSION_MANAGER=");
#endif
		
		initKdeSettings();
		
		if (!qApp)
		{
			new QApplication(gdk_x11_get_default_xdisplay());
			qAppOwner = true;
		}

#ifndef USE_SOLARIS
		setenv("SESSION_MANAGER", sessionEnv, 1);
#else
		char *tempEnv=(char *)malloc(strlen(sessionEnv)+strlen("SESSION_MANAGER")+2);
		sprintf(tempEnv, "SESSION_MANAGER=%s", sessionEnv);
		putenv(tempEnv);
#endif
		
		XSetErrorHandler( original_x_errhandler );
		XSetIOErrorHandler( original_xio_errhandler );
		
		gtkQtEnable = true;
	}
	
	free(argv[0]);
	free(argv);
	
	if (!gtkQtEnable)
		return;
	
	isBaghira = (QString(qApp->style().name()).lower() == "baghira");
	
	// Set Gtk fonts and icons
	/*setGnomeFonts();
	setGnomeIcons();*/
	
	// Get KDE related atoms from the X server
	kipcCommAtom = XInternAtom ( gdk_x11_get_default_xdisplay() , "KIPC_COMM_ATOM" , false );
	desktopWindowAtom = XInternAtom ( gdk_x11_get_default_xdisplay() , "KDE_DESKTOP_WINDOW" , false );
	
	// Create a new window, and set the KDE_DESKTOP_WINDOW property on it
	// This window will then receive events from KDE when the style changes
	smw = new QWidget(0,0);
	long data = 1;
	XChangeProperty(gdk_x11_get_default_xdisplay(), smw->winId(),
		desktopWindowAtom, desktopWindowAtom,
		32, PropModeReplace, (unsigned char *)&data, 1);
	
	// This filter will intercept those events
	gdk_window_add_filter( NULL, gdkEventFilter, 0);
	
	meepSBar    = new QScrollBar(0);
	meepWidgetP = new QWidget(0);
	meepWidget = new QWidget(meepWidgetP);
	meepSlider = new QSlider(meepWidget);
	meepWidget->polish();
	
	meepTabBar = new QTabBar(meepWidget);

	backgroundTile = meepWidget->paletteBackgroundPixmap();
}

void destroyQApp()
{
	if (!gtkQtEnable)
		return;
	delete meepSBar;
	delete meepWidget;
	delete meepWidgetP;
	delete menuBackgroundPixmap;
	delete smw;
	if (qAppOwner)
	{
		delete qApp;
		qApp = 0;
	}
	if (altBackGC != 0)
		gtk_gc_release(altBackGC);
}

GdkFilterReturn gdkEventFilter(GdkXEvent *xevent, GdkEvent *gevent, gpointer data)
{
	XEvent* event = (XEvent*) xevent;

	// Is the event a KIPC message?
	if ((event->type == ClientMessage) && (event->xclient.message_type == kipcCommAtom))
	{
		// Find out the new widget style
		QString styleName = kdeConfigValue("General", "widgetStyle", "");
		QStyle* style = QStyleFactory::create(styleName);
		if (!style)
			return GDK_FILTER_REMOVE;
		
		// Tell the QApplication about this new style
		qApp->setStyle(style);
		
		// Now we need to update GTK's properties
		setRcProperties(gtkRcStyle, 1); // Rewrite our cache file
		gtk_rc_reparse_all(); // Tell GTK to parse the cache file
		
		return GDK_FILTER_REMOVE;
	}
	return GDK_FILTER_CONTINUE;
}

QString kdeConfigValue(const QString& section, const QString& name, const QString& def)
{
	for ( QStringList::Iterator it = kdeSearchPaths.begin(); it != kdeSearchPaths.end(); ++it )
	{
		if (!QFile::exists((*it) + "/share/config/kdeglobals"))
			continue;
		
		QFile file((*it) + "/share/config/kdeglobals");
		if (!file.open( IO_ReadOnly ))
			continue;
		
		QTextStream stream( &file );
		QString line;
		QString sec;
		int i = 1;
		while ( !stream.atEnd() )
		{
			line = stream.readLine();
			if (line.startsWith("["))
			{
				sec = line.mid(1, line.length() - 2);
				continue;
			}
			if (sec != section)
				continue;
			QRegExp parser("([\\S]*)\\s*=\\s*([\\S]*)");
			if (parser.search(line) == -1)
				continue;
			if (parser.cap(1) == name)
				return parser.cap(2);
		}
		file.close();
	}
	return def;
}

QString kdeFindDir(const QString& suffix, const QString& file1, const QString& file2)
{
	for ( QStringList::Iterator it = kdeSearchPaths.begin(); it != kdeSearchPaths.end(); ++it )
	{
		if ((QFile::exists((*it) + suffix + file1)) || (QFile::exists((*it) + suffix + file2)))
			return (*it) + suffix;
	}
	return QString::null;
}

QString runCommand(const QString& command)
{
	FILE* p = popen(command.latin1(), "r");
	if ((p == NULL) || (p < 0))
		return QString::null;
	
	QString ret;
	while (!feof(p))
	{
		char buffer[256];
		int n = fread(buffer, 1, 255, p);
		buffer[n] = '\0';
		ret += buffer;
	}
	pclose(p);
	
	return ret.stripWhiteSpace();
}

void initKdeSettings()
{
	kdeSearchPaths.clear();
	
	QString kdeHome = getenv("KDEHOME");
	QString kdeDirs = getenv("KDEDIRS");
	QString kdeDir = getenv("KDEDIR");
	
	if (!kdeHome.isEmpty())
		kdeSearchPaths.append(kdeHome);
	kdeSearchPaths.append(runCommand("kde-config --localprefix"));
	
	if (!kdeDirs.isEmpty())
		kdeSearchPaths += QStringList::split(':', kdeDirs);
	if (!kdeDir.isEmpty())
		kdeSearchPaths.append(kdeDir);
	kdeSearchPaths.append(runCommand("kde-config --prefix"));
	
	iconTheme = kdeConfigValue("Icons", "Theme", "crystal");
	QStringList back = QStringList::split(',', kdeConfigValue("General", "alternateBackground", "238,246,255"));
	alternateBackgroundColour.setRgb(back[0].toInt(), back[1].toInt(), back[2].toInt());
}

QStyle::SFlags stateToSFlags(GtkStateType state)
{
	switch (state)
	{
		case GTK_STATE_ACTIVE:
			return QStyle::Style_Enabled | QStyle::Style_Down;
		case GTK_STATE_PRELIGHT:
			return QStyle::Style_Enabled | QStyle::Style_MouseOver;
		case GTK_STATE_SELECTED:
			return QStyle::Style_Enabled | QStyle::Style_HasFocus;
		case GTK_STATE_INSENSITIVE:
			return QStyle::Style_Default;
		default:
			return QStyle::Style_Enabled;
	}
}


// The drawing functions follow the same pattern:
//  * Set the appropriate flags
//  * Ask QT to paint the widget to a pixmap
//  * Create a GdkPixmap that points to our QPixmap
//  * Paint the pixmap on the window


void drawButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QPixmap     pixmap(w, h);
	QPainter    painter(&pixmap);
	QPushButton button(meepWidget);	
	button.setBackgroundOrigin(QWidget::ParentOrigin);
	button.setGeometry(x, y, w, h);
	QPoint p = button.backgroundOffset();
	QPoint pos = button.pos();

	QStyle::SFlags sflags = stateToSFlags(state);

	painter.fillRect(0, 0, w, h, qApp->palette().active().background());

	qApp->style().drawControl(QStyle::CE_PushButton, &painter, &button, 
	                          QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

// Thanks Peter Hartshorn <peter@dimtech.com.au>
void drawToolbar(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	int w1, h1;
	QStyle::SFlags sflags = stateToSFlags(state);


	// Keramik hack...
	// Keramik only draws the toolbar border, and not the gradient
	// so we also draw a separator, but make sure the line is off the
	// widget
	
	if (w > h)
	{
		sflags |= QStyle::Style_Horizontal;
		w1 = w * 3;
		h1 = h;
	}
	else
	{
		w1 = h;
		h1 = h * 3;
	}

	QPixmap     pixmap(w1, h1);
	QPixmap     p(w, h);
	QPainter    painter(&pixmap);

        if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w1, h1, QBrush(QColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, w1, h1, qApp->palette().active().brush(QColorGroup::Background));
	//painter.fillRect(0,0,w1,h1,qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_PanelDockWindow, &painter,
			QRect(0,0,w1,h1), qApp->palette().active(),sflags);

	qApp->style().drawPrimitive(QStyle::PE_DockWindowSeparator, &painter,
			QRect(0,0,w1,h1), qApp->palette().active(),sflags);

	bitBlt(&p, 0, 0, &pixmap, 0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenubar(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	int w1, h1;
	QStyle::SFlags sflags = stateToSFlags(state);


	// Keramik hack...
	// Keramik only draws the toolbar border, and not the gradient
	// so we also draw a separator, but make sure the line is off the
	// widget
	
	if (w > h)
	{
		sflags |= QStyle::Style_Horizontal;
		w1 = w * 3;
		h1 = h;
	}
	else
	{
		w1 = h;
		h1 = h * 3;
	}

	QPixmap     pixmap(w1, h1);
	QPixmap     p(w, h);
	QPainter    painter(&pixmap);

        if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w1, h1, QBrush(QColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, w1, h1, qApp->palette().active().brush(QColorGroup::Background));

	qApp->style().drawPrimitive(QStyle::PE_PanelMenuBar, &painter,
			QRect(0,0,w1,h1), qApp->palette().active(),sflags);

	bitBlt(&p, 0, 0, &pixmap, 0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawTab(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);
	
	// GTK doesn't tell us if our tab is on the left, right, or middle of the tabbar
	// So, let's always assume it's in the middle - it looks pretty
	QTab* tab = new QTab;
	meepTabBar->insertTab(tab,1);

	QStyle::SFlags sflags = stateToSFlags(state);

	if (state != GTK_STATE_ACTIVE)
		sflags = QStyle::Style_Selected;

	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawControl(QStyle::CE_TabBarTab, &painter, meepTabBar, QRect(0,0,w,h), qApp->palette().active(), sflags, QStyleOption(tab));
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
	
	meepTabBar->removeTab(tab);
}

void drawVLine(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int ySource, int yDest)
{
	if (!gtkQtEnable)
		return;
	
	int width = style->xthickness;
	int height = abs(ySource-yDest);
	
	if (width < 2) width = 2;

	QPixmap pixmap(width, height);
	QPainter painter(&pixmap);

	painter.fillRect(2, 0, width - 2, height, qApp->palette().active().brush(QColorGroup::Background));
	painter.setPen( qApp->palette().active().mid() );
	painter.drawLine( 0, 0, 0, height );
	painter.setPen( qApp->palette().active().light() );
	painter.drawLine( 1, 0, 1, height );

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, ySource, width, height);
	g_object_unref(pix);
}

void drawHLine(GdkWindow* window, GtkStyle* style, GtkStateType state, int y, int xSource, int xDest)
{
	if (!gtkQtEnable)
		return;
	
	int width = abs(xSource-xDest);
	int height = style->ythickness;

	QPixmap pixmap(width, height);
	QPainter painter(&pixmap);

	painter.fillRect(0, 2, width, height-2, qApp->palette().active().brush(QColorGroup::Background));
	painter.setPen(qApp->palette().active().mid() );
	painter.drawLine(0, 0, width, 0);
	painter.setPen(qApp->palette().active().light());
	painter.drawLine(0, 1, width, 1);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, xSource, y, width, height);
	g_object_unref(pix);
}

void drawLineEdit(GdkWindow* window, GtkStyle* style, GtkStateType state, int hasFocus, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	if (hasFocus)
		sflags |= QStyle::Style_HasFocus;
	
	painter.fillRect(0, 0, w, h, qApp->palette().active().base());
	qApp->style().drawPrimitive(QStyle::PE_PanelLineEdit, &painter, QRect(0, 0, w, h), qApp->palette().active(), sflags, QStyleOption(1,1));

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawFrame(GdkWindow* window, GtkStyle* style, GtkStateType state, GtkShadowType shadow_type, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	if ((shadow_type == GTK_SHADOW_IN) || (shadow_type == GTK_SHADOW_ETCHED_IN))
		sflags |= QStyle::Style_Sunken;

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));

	qApp->style().drawPrimitive(QStyle::PE_Panel, &painter, QRect(0, 0, w, h), qApp->palette().active(), sflags, QStyleOption(2,2) );
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawComboBox(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);
	QComboBox cb(false, 0);
	cb.resize(w,h);
	
	QStyle::SFlags sflags = stateToSFlags(state);
	QStyle::SCFlags scflags = QStyle::SC_ComboBoxArrow | QStyle::SC_ComboBoxFrame | QStyle::SC_ComboBoxListBoxPopup;
	QStyle::SCFlags activeflags = QStyle::SC_None;

	if (state == GTK_STATE_PRELIGHT)
		activeflags = QStyle::Style_MouseOver;

	painter.fillRect(0,0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawComplexControl(QStyle::CC_ComboBox, &painter, &cb, QRect(0, 0, w, h), qApp->palette().active(), sflags, scflags, activeflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawCheckBox(GdkWindow* window, GtkStyle* style, GtkStateType state, int checked, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	int realH = qApp->style().pixelMetric(QStyle::PM_IndicatorHeight);
	int realW = qApp->style().pixelMetric(QStyle::PM_IndicatorWidth);

	QPixmap pixmap(realW, realH);
	QPainter painter(&pixmap);
	QCheckBox checkbox(0);

	QStyle::SFlags sflags = stateToSFlags(state);
	sflags |= (checked ? QStyle::Style_On : QStyle::Style_Off);

	painter.fillRect(0, 0, realW, realH, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawControl(QStyle::CE_CheckBox, &painter, &checkbox, QRect(0, 0, realW, realH), qApp->palette().active(), sflags);

	// Qt checkboxes are usually bigger than GTK wants.
	// We cheat, and draw them over the expected area.
	int xOffset = (realW - w) / 2;
	int yOffset = (realH - h) / 2;
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x - xOffset, y - yOffset, realW, realH);
	g_object_unref(pix);
}

void drawMenuCheck(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QCheckBox checkbox(0);
	
	/* A previous version of the function followed the sizehints exclusively 
	   Now follow w and h provided by GTK, but if the checkmark is too big we might have to scale it */
	/*
	int w1 = checkbox.sizeHint().width();
	int h1 = checkbox.sizeHint().height(); */

	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	if (state == GTK_STATE_INSENSITIVE)
		sflags |= QStyle::Style_Off;
	else if (state == GTK_STATE_PRELIGHT)
		sflags |= QStyle::Style_On;
 	
	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
        else
	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_CheckMark, &painter, QRect(0, 0, w, h), qApp->palette().active(), sflags);
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawRadioButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int checked, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	int realH = qApp->style().pixelMetric(QStyle::PM_IndicatorHeight);
	int realW = qApp->style().pixelMetric(QStyle::PM_IndicatorWidth);

	QPixmap pixmap(realH, realW);
	QPainter painter(&pixmap);
	QRadioButton radio(0);

	QStyle::SFlags sflags = stateToSFlags(state);
	sflags |= checked ? QStyle::Style_On : QStyle::Style_Off;

	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, realW, realH, QBrush(QColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
                painter.fillRect(0, 0, realW, realH, QBrush(QColor(255,255,255), *backgroundTile));
        else
                painter.fillRect(0, 0, realW, realH, qApp->palette().active().brush(QColorGroup::Background));

	qApp->style().drawControl(QStyle::CE_RadioButton, &painter, &radio, QRect(0,0,realH,realW), qApp->palette().active(), sflags);

	// Qt checkboxes are usually bigger than GTK wants.
	// We cheat, and draw them over the expected area.
	int xOffset = (realW - w) / 2;
	int yOffset = (realH - h) / 2;
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x - xOffset, y - yOffset, realW, realH);
	g_object_unref(pix);
}


void drawScrollBarSlider(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, GtkAdjustment* adj, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);
	
	QStyle::SFlags sflags = stateToSFlags(state);
	if (orientation == GTK_ORIENTATION_HORIZONTAL)
		sflags |= QStyle::Style_Horizontal;
	
	qApp->style().drawPrimitive(QStyle::PE_ScrollBarSlider, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawScrollBar(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, GtkAdjustment* adj, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	meepSBar->resize(w,h);
	
	meepSBar->setMinValue((int)adj->lower);

	// Patch from Chad Kitching <chadk@cmanitoba.com>
	// Patch from Peter Hartshorn <peter@dimtech.com.au>

	// another check for mozilla is step_increment and page_increment
	// are set to zero for mozilla, and have values set by all other
	// gtk applications I've tested this with.
	
	// Why oh why couldn't mozilla use native widgets instead of
	// handling everything in cross platform.
	
	meepSBar->setOrientation(orientation ? Qt::Vertical : Qt::Horizontal);
	
	
	QStyle::SFlags sflags = stateToSFlags(state);
	if (sflags |= QStyle::Style_Down) sflags = QStyle::Style_Enabled;
	if (orientation == GTK_ORIENTATION_HORIZONTAL) sflags |= QStyle::Style_Horizontal;
	
	QPixmap pixmap(w,h);
	
	meepSBar->setMinValue(0);
	meepSBar->setMaxValue(65535);
	meepSBar->setValue(32767);
	meepSBar->setPageStep(1);

	int offset = 0;
	int thumbSize = 0;


	if (orientation == GTK_ORIENTATION_VERTICAL) {
		QRect r;
		r = qApp->style().querySubControlMetrics(QStyle::CC_ScrollBar,
				meepSBar, QStyle::SC_ScrollBarSlider);
		offset = r.y();
		thumbSize = r.height();
		
		if (!r.isValid()) // Fix a crash bug in Eclipse where it was trying to draw tiny scrollbars.
			return;

		QPixmap tmpPixmap(w, h + thumbSize);
		QPainter painter2(&tmpPixmap);
		meepSBar->resize(w, h + thumbSize);

		painter2.fillRect(0, 0, w, h + thumbSize,
				qApp->palette().active().brush(QColorGroup::Background));
		qApp->style().drawComplexControl(QStyle::CC_ScrollBar,
				&painter2, meepSBar, QRect(0, 0, w, h+thumbSize),
				qApp->palette().active(), sflags);

		bitBlt(&pixmap, 0, 0, &tmpPixmap, 0, 0, w, offset, Qt::CopyROP);
		bitBlt(&pixmap, 0, offset, &tmpPixmap, 0, offset + thumbSize,
				w, h - offset, Qt::CopyROP);
	} else {
		QRect r;
		r = qApp->style().querySubControlMetrics(QStyle::CC_ScrollBar,
				meepSBar, QStyle::SC_ScrollBarSlider);
		offset = r.x();
		thumbSize = r.width();

		if (!r.isValid()) // Fix a crash bug in Eclipse when it was trying to draw tiny scrollbars.
			return;
		
		QPixmap tmpPixmap(w + thumbSize, h);
		QPainter painter2(&tmpPixmap);
		meepSBar->resize(w + thumbSize, h);

		painter2.fillRect(0, 0, w + thumbSize, h,
				qApp->palette().active().brush(QColorGroup::Background));
		qApp->style().drawComplexControl(QStyle::CC_ScrollBar,
				&painter2, meepSBar, QRect(0, 0, w+thumbSize, h),
				qApp->palette().active(), sflags);

		bitBlt(&pixmap, 0, 0, &tmpPixmap, 0, 0, offset, h, Qt::CopyROP);
		bitBlt(&pixmap, offset, 0, &tmpPixmap, offset + thumbSize, 0,
				w - offset, h, Qt::CopyROP);
	}
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawToolButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QToolButton button(NULL);
	button.resize(w, h);
	
	/* 
	int realW = button.sizeHint().width();
	int realH = button.sizeHint().height();	 */
	
	QStyle::SFlags sflags = stateToSFlags(state);
	QStyle::SCFlags activeflags = QStyle::SC_None;
	if (state == GTK_STATE_ACTIVE)
	{
		sflags |= QStyle::Style_AutoRaise;
		activeflags = QStyle::SC_ToolButton;
	}
	else
		sflags |= QStyle::Style_AutoRaise | QStyle::Style_Raised;
	
	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);
	
	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawComplexControl(QStyle::CC_ToolButton, &painter, &button, QRect(0, 0, w, h), qApp->palette().active(), sflags, QStyle::SC_ToolButton, activeflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenuBarItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);
	QMenuItem mi;
	QMenuBar mb(0);
	
	QStyle::SFlags sflags = QStyle::Style_Down | QStyle::Style_Enabled | QStyle::Style_Active | QStyle::Style_HasFocus;

	qApp->style().drawControl(QStyle::CE_MenuBarItem, &painter, &mb, QRect(0, 0, w, h), qApp->palette().active(), sflags, QStyleOption(&mi));
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawMenuItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);
	QPopupMenu pm;
	QMenuData md;
	QMenuItem* mi = md.findItem(md.insertItem(""));
	
	QStyleOption opt(mi, 16, 16);
	QStyle::SFlags sflags = QStyle::Style_Active | QStyle::Style_Enabled;

	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawControl(QStyle::CE_PopupMenuItem, &painter, &pm, QRect(0,0,w,h), qApp->palette().active(), sflags, opt);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSplitter(GdkWindow* window, GtkStyle* style, GtkStateType state, int orientation, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	// No idea why this works...
	if (orientation != GTK_ORIENTATION_HORIZONTAL) sflags |= QStyle::Style_Horizontal;

	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_Splitter, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawTabFrame(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h, GtkPositionType pos)
{
	if (!gtkQtEnable)
		return;
	
	QStyle::SFlags sflags = stateToSFlags(state);
		
	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);
	QStyleOption opt(2, 2); // line width

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_PanelTabWidget, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags, opt);
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
	
	// Drawing tab base
        int th = qApp->style().pixelMetric(QStyle::PM_TabBarBaseHeight, meepTabBar);
	int tw = w;
        if (!th || !tw)
                return;
	
        QPixmap pixmap1(tw,th);
        QPainter painter1(&pixmap1);
	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter1.fillRect(0, 0, tw, th, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter1.fillRect(0, 0, tw, th, qApp->palette().active().brush(QColorGroup::Background));
        

        qApp->style().drawPrimitive(QStyle::PE_TabBarBase, &painter1, QRect(0, 0, tw, th), qApp->palette().active(), sflags, QStyleOption(1,1));
	if (pos == GTK_POS_BOTTOM)
	{
		QWMatrix m;
		m.scale(1, -1);
		pixmap1 = pixmap1.xForm(m);
		
		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap1.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y+h+qApp->style().pixelMetric(QStyle::PM_TabBarBaseOverlap, meepTabBar), tw, th);
		g_object_unref(pix);
	}
	else
	{
		GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap1.handle());
		gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y-qApp->style().pixelMetric(QStyle::PM_TabBarBaseOverlap, meepTabBar), tw, th);
		g_object_unref(pix);
	}
}

void drawMenu(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);
	QStyle::SFlags sflags = stateToSFlags(state);

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_PanelPopup, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

// Note: In GTK, the drawing of a progress bar is in two parts:
// First the progress "container" is drawn
// Second the actually percent bar is drawn
// Mozilla requires this to be done in two steps as it first
// asks gtk to draw an EMPTY progress bar, then it asks to draw
// the contents, or percent bar, over the empty progress bar.
// So, although this function is not required for any gtk application
// except mozilla based apps, doing it this way is following the gtk
// theme structure more.
//
// See also drawScrollbar/drawScrollbarSlider pair.
//
// Peter Hartshorn (peter@dimtech.com.au)

void drawProgressChunk(GdkWindow * window, GtkStyle * style, GtkStateType state, int x, int y, int w, int h)
{
	// This is only for Mozilla/Firefox
	if (!mozillaFix || !gtkQtEnable)
		return;
	
	if ((w<=1) || (h<=1))
		return; // Trying to draw something that small caused a segdault

	QProgressBar bar(100, NULL);
	bar.resize(w,h);
	bar.setProgress(100);
	bar.setCenterIndicator(false);
	bar.setPercentageVisible(false);
	bar.setFrameStyle(QFrame::NoFrame);
	
	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	
	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));

	qApp->style().drawControl(QStyle::CE_ProgressBarContents, &painter, &bar, QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawProgressBar(GdkWindow * window, GtkStyle * style, GtkStateType state, GtkProgressBarOrientation orientation, gfloat percentage, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	if ((w<=1) || (h<=1))
		return; // Trying to draw something that small caused a segdault
	
	QProgressBar bar(100, NULL);
	if ((orientation == GTK_PROGRESS_BOTTOM_TO_TOP) || (orientation == GTK_PROGRESS_TOP_TO_BOTTOM))
		bar.resize(h, w);
	else
		bar.resize(w, h);
	bar.setProgress((int)(percentage*100.0));
	bar.setCenterIndicator(false);
	bar.setPercentageVisible(false);

	QPixmap pixmap = QPixmap::grabWidget(&bar);
	
	QWMatrix matrix;
	switch (orientation)
	{
		case GTK_PROGRESS_RIGHT_TO_LEFT: matrix.rotate(180); break;
		case GTK_PROGRESS_BOTTOM_TO_TOP: matrix.rotate(270);  break;
		case GTK_PROGRESS_TOP_TO_BOTTOM: matrix.rotate(90); break;
		default: break;
	}
	
	if (orientation != GTK_PROGRESS_LEFT_TO_RIGHT)
		pixmap = pixmap.xForm(matrix);
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSlider(GdkWindow * window, GtkStyle * style, GtkStateType state, GtkAdjustment *adj, int x, int y, int w, int h, GtkOrientation orientation)
{
	if (!gtkQtEnable)
		return;

	int w1, h1;
	meepSlider->setBackgroundOrigin(QWidget::ParentOrigin);
	
	meepSlider->setOrientation((orientation == GTK_ORIENTATION_HORIZONTAL) ? Qt::Horizontal : Qt::Vertical);
	meepSlider->setEnabled(state != GTK_STATE_INSENSITIVE);

	/* This can be draw in two ways -- 
		If the slider is horizontal -- we can resize the slider to height using the sizeHint() (equivalent to using Qt's guidelines regarding height ) and (1)scale it later to GTK's sizes which will work for all slider sizes but will look in GTK as if the slider has been crushed or (2)else we can draw the slider using the height hint provided by Qt 
		.. and vice versa for vertical slider */
	if (w > h)
	{
		h1 = meepSlider->sizeHint().height();
		w1 = w;
	}
	else
	{
		h1 = h;
		w1 = meepSlider->sizeHint().width();
	}
	meepSlider->setGeometry(x, y, w1, h1);
	meepSlider->setMinValue(0);
	meepSlider->setMaxValue(100);
	meepSlider->setValue((int)((adj->value-adj->lower)/(adj->upper-adj->lower)*100));

	QPixmap pixmap = QPixmap::grabWidget(meepSlider);
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSpinButton(GdkWindow * window, GtkStyle * style, GtkStateType state, int direction, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QPixmap pixmap(w, h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state);
	
	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive((direction ? QStyle::PE_SpinWidgetDown : QStyle::PE_SpinWidgetUp), &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawListHeader(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);

	QStyle::SFlags sflags = stateToSFlags(state) | QStyle::Style_Horizontal;

	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawPrimitive(QStyle::PE_HeaderSection, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}


void drawListViewItem(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
        if (!gtkQtEnable)
                return;

        QPixmap     pixmap(w, h);
        QPainter    painter(&pixmap);

	/* Get the brush corresponding to highlight color */
	QBrush brush = qApp->palette().brush(QPalette::Active, QColorGroup::Highlight);
	painter.setBrush(brush);
	painter.setPen(Qt::NoPen);
	painter.drawRect(0, 0, w, h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawSquareButton(GdkWindow* window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;

	QPixmap     pixmap(20, 20);
	QPainter    painter(&pixmap);
	QPushButton button(0);
		
	QStyle::SFlags sflags = stateToSFlags(state);
	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, 20, 20, QBrush(QColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, 20, 20, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, 20, 20, qApp->palette().active().brush(QColorGroup::Background));
	
	qApp->style().drawControl(QStyle::CE_PushButton, &painter, &button,
					QRect(0,0,20,20), qApp->palette().active(), sflags);
	
	QImage image = pixmap.convertToImage().smoothScale(w,h);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void initDrawTabNG(int count)
{
	if (!gtkQtEnable)
		return;
	
	delete meepTabBar;
	meepTabBar = 0;
	meepTabBar = new QTabBar(meepWidget);
	
	for ( int i = 0; i < count; i++ )
		meepTabBar->addTab(new QTab);
	
	return;
}

void drawTabNG(GdkWindow *window, GtkStyle* style, GtkStateType state, int x, int y, int w, int h, GtkNotebook *notebook)
{
	if (!gtkQtEnable)
		return;
	
	GtkPositionType tpos = gtk_notebook_get_tab_pos(notebook);
	
	// Find tab position
	int sdiff = 10000, pos = -1, diff = 1;
	for ( int i = 0; i < g_list_length(notebook->children); i++ )
	{
		diff = gtk_notebook_get_tab_label(notebook,gtk_notebook_get_nth_page(notebook,i))->allocation.x - x;
		if ((diff > 0) && (diff < sdiff))
		{
			sdiff = diff; pos = i;
		}
	}
	
	QTab *tab = meepTabBar->tabAt(pos);
	
	if (!tab)
	{
		// This happens in Firefox.  Just draw a normal tab instead
		if (state == GTK_STATE_ACTIVE)
			drawTab(window, style, state, x, y - 2, w, h + 2);
		else
			drawTab(window, style, state, x, y, w, h);
		return;
	}
	
	QStyle::SFlags sflags = stateToSFlags(state);
	
	if (state != GTK_STATE_ACTIVE)
	{
		sflags = QStyle::Style_Selected;
		if (tpos == GTK_POS_TOP)
			y += 3;
		h -= 3;
	}
	
	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);
	
	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
	
	painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawControl(QStyle::CE_TabBarTab, &painter, (QTabBar *)meepTabBar, QRect(0,0,w,h), qApp->palette().active(), sflags, QStyleOption(tab));
	
	// Account for tab position -- if its in the bottom flip the image
	if (tpos == GTK_POS_BOTTOM)
	{
		QWMatrix m;
		m.scale(1, -1);
		pixmap = pixmap.xForm(m);
	}
	
	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

void drawArrow(GdkWindow* window, GtkStyle* style, GtkStateType state, GtkArrowType direction, int x, int y, int w, int h)
{
	if (!gtkQtEnable)
		return;
	
	QStyle::SFlags sflags = stateToSFlags(state);
	if (state == GTK_STATE_INSENSITIVE)
		sflags |= QStyle::Style_Off;
	else if (state == GTK_STATE_PRELIGHT)
		sflags |= QStyle::Style_On;

	QStyle::PrimitiveElement element;
	switch(direction)
	{
		case GTK_ARROW_UP:    element = QStyle::PE_ArrowUp;    break;
		case GTK_ARROW_DOWN:  element = QStyle::PE_ArrowDown;  break;
		case GTK_ARROW_LEFT:  element = QStyle::PE_ArrowLeft;  break;
		case GTK_ARROW_RIGHT: element = QStyle::PE_ArrowRight; break;
	}

	 
	QPixmap pixmap(w,h);
	QPainter painter(&pixmap);

	if (fillPixmap && (!fillPixmap->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *fillPixmap));
	else if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, w, h, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, w, h, qApp->palette().active().brush(QColorGroup::Background));

	qApp->style().drawPrimitive(element, &painter, QRect(0,0,w,h), qApp->palette().active(), sflags);

	GdkPixmap* pix = gdk_pixmap_foreign_new(pixmap.handle());
	gdk_draw_drawable(window, style->bg_gc[state], pix, 0, 0, x, y, w, h);
	g_object_unref(pix);
}

GdkGC* alternateBackgroundGc(GtkStyle* style)
{
	// Alternate background color for listviews
	if (altBackGC != 0)
		return altBackGC;
	
	GdkColor altBackColor;
	mapColour(&altBackColor, alternateBackgroundColour);
	
	gdk_colormap_alloc_color(style->colormap, &altBackColor, FALSE, TRUE);
	
	GdkGCValues gc_values;
	GdkGCValuesMask gc_values_mask;
	gc_values_mask = GDK_GC_FOREGROUND;
	gc_values.foreground = altBackColor;
	
	altBackGC = (GdkGC*) gtk_gc_get (style->depth, style->colormap, &gc_values, gc_values_mask);
	
	return altBackGC;
}


// Thanks Martin Dvorak of metatheme
QString parse_rc_string(const QString& defs, const QString& pattern)
{
	static int dynamic_counter = 0;
	++dynamic_counter;
	
	return "style \"gtk-qt-dynamic-" + QString::number(dynamic_counter) + "\" { " + defs + " } widget_class \"" + pattern + "\" style \"gtk-qt-dynamic-" + QString::number(dynamic_counter) + "\"\n";
}

QString doIconMapping(const QString& stockName, const QString& path, int sizes)
{
	QString fullPath;

	fullPath = iconThemeDir + "16x16/" + path;
	if (access(fullPath.latin1(), R_OK))
		sizes &= ~1;
	fullPath = iconThemeDir + "22x22/" + path;
	if (access(fullPath.latin1(), R_OK))
		sizes &= ~2;
	fullPath = iconThemeDir + "32x32/" + path;
	if (access(fullPath.latin1(), R_OK))
		sizes &= ~4;

	if (!sizes) return "";
	
	// sizes is an addition of 1=16, 2=22 and 4=32
	QString ret = "stock[\"" + stockName + "\"]={\n";
	
	if (sizes & 2)
	{
		ret += "\t{ \"22x22/" + path +"\", *, *, \"gtk-large-toolbar\" }";
		if (sizes != 2) ret += ",\n";
		else ret += "\n";
	}

	if (sizes & 4)
	{
		ret += "\t{ \"32x32/" + path +"\", *, *, \"gtk-dnd\" },\n";
		ret += "\t{ \"32x32/" + path +"\", *, *, \"gtk-dialog\" }";
		if (sizes != 4) ret += ",\n";
		else ret += "\n";
	}

	if (sizes & 1)
	{
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-button\" },\n";
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-menu\" },\n";
		ret += "\t{ \"16x16/" + path +"\", *, *, \"gtk-small-toolbar\" }";
		if (sizes & 2) ret += ",\n";
		else ret += "\n";
	}

	if (sizes & 2) ret += "\t{ \"22x22/" + path +"\" }\n";
	ret += "}\n";
	return ret;
}

void setRcProperties(GtkRcStyle* rc_style, int forceRecreate)
{
	if (!gtkQtEnable)
		return;
	
	gtkRcStyle = rc_style;
	
	// This function takes quite a long time to execute, and is run at the start of every app.
	// In order to speed it up, we can store the results in a file, along with the name of icon
	// theme and style.  This file can then be regenerated when the icon theme or style change.
	
	QString cacheFilePath = QDir::homeDirPath() + "/.gtk_qt_engine_rc";
	QFile cacheFile(cacheFilePath);
	QTextStream stream;
	
	if (!forceRecreate && cacheFile.exists())
	{
		cacheFile.open(IO_ReadOnly);
		stream.setDevice(&cacheFile);
		
		if (stream.readLine() == "# " + iconTheme + ", " + qApp->style().name())
		{
			// This cache matches the current icon theme and style
			// Let's load it and return
			gtk_rc_add_default_file(cacheFilePath.latin1());
			return;
		}
		
		stream.unsetDevice();
		cacheFile.close();
	}
	
	cacheFile.open(IO_WriteOnly | IO_Truncate);
	stream.setDevice(&cacheFile);
	
	stream << "# " << iconTheme << ", " << qApp->style().name() << "\n\n";
	stream << "# This file was generated by the Gtk Qt Theme Engine\n";
	stream << "# It will be recreated when you change your KDE icon theme or widget style\n\n";
	
	QScrollBar sbar(NULL);
	sbar.setOrientation(Qt::Horizontal);
	sbar.setValue(1);
	sbar.resize(200,25);
	
	// The following code determines how many buttons are on a scrollbar
	// It works by looking at each pixel of the scrollbar's area not taken up by the groove,
	// and asking the style which subcontrol is at that location.
	QRect rect = qApp->style().querySubControlMetrics(QStyle::CC_ScrollBar, &sbar, QStyle::SC_ScrollBarGroove);
	
	bool back1 = false;
	bool forward1 = false;
	bool back2 = false;
	bool forward2 = false;
	
	QStyle::SubControl sc = QStyle::SC_None;
	for (QPoint pos(0,7) ; pos.x()<rect.x() ; pos.setX(pos.x()+1))
	{
		QStyle::SubControl sc2 = qApp->style().querySubControl(QStyle::CC_ScrollBar, &sbar, pos);
		if (sc != sc2)
		{
			if (sc2 == QStyle::SC_ScrollBarAddLine) forward1 = true;
			if (sc2 == QStyle::SC_ScrollBarSubLine) back1 = true;
			sc = sc2;
		}
	}
	sc = QStyle::SC_None;
	for (QPoint pos(rect.x()+rect.width(),7) ; pos.x()<200 ; pos.setX(pos.x()+1))
	{
		QStyle::SubControl sc2 = qApp->style().querySubControl(QStyle::CC_ScrollBar, &sbar, pos);
		if (sc != sc2)
		{
			if (sc2 == QStyle::SC_ScrollBarAddLine) forward2 = true;
			if (sc2 == QStyle::SC_ScrollBarSubLine) back2 = true;
			sc = sc2;
		}
	}
	
	stream << parse_rc_string(QString("GtkScrollbar::has-backward-stepper = ") + (back1 ? "1" : "0"), "*");
	stream << parse_rc_string(QString("GtkScrollbar::has-forward-stepper = ") + (forward2 ? "1" : "0"), "*");
	stream << parse_rc_string(QString("GtkScrollbar::has-secondary-forward-stepper = ") + (forward1 ? "1" : "0"), "*");
	stream << parse_rc_string(QString("GtkScrollbar::has-secondary-backward-stepper = ") + (back2 ? "1" : "0"), "*");
	
	stream << parse_rc_string("GtkScrollbar::stepper-size = " + QString::number(qApp->style().querySubControlMetrics(QStyle::CC_ScrollBar, &sbar, QStyle::SC_ScrollBarSubLine).width() - 1), "*");
	
	stream << parse_rc_string("GtkScrollbar::min-slider-length = " + QString::number(qApp->style().pixelMetric(QStyle::PM_ScrollBarSliderMin)), "*");
	stream << parse_rc_string("GtkScrollbar::slider-width = " + QString::number(qApp->style().pixelMetric(QStyle::PM_ScrollBarExtent)-2), "*");
	stream << parse_rc_string("GtkButton::child-displacement-x = " + QString::number(qApp->style().pixelMetric(QStyle::PM_ButtonShiftHorizontal)), "*");
	stream << parse_rc_string("GtkButton::child-displacement-y = " + QString::number(qApp->style().pixelMetric(QStyle::PM_ButtonShiftVertical)), "*");
	QSlider slider(NULL); // To keep BlueCurve happy
	stream << parse_rc_string("GtkScale::slider-length = " + QString::number(qApp->style().pixelMetric(QStyle::PM_SliderLength, &slider)), "*");
	stream << parse_rc_string("GtkButton::default-border = { 0, 0, 0, 0 }", "*");
	
	stream << parse_rc_string("xthickness = " + QString::number(qApp->style().pixelMetric(QStyle::PM_DefaultFrameWidth)), "*.GtkMenu");
	stream << parse_rc_string("ythickness = " + QString::number(qApp->style().pixelMetric(QStyle::PM_DefaultFrameWidth)), "*.GtkMenu");
	stream << parse_rc_string("xthickness = 5", "*.GtkMenu.Gtk*MenuItem");
	stream << parse_rc_string("xthickness = 3", "*.GtkNotebook");
	stream << parse_rc_string("ythickness = 3", "*.GtkNotebook");
	stream << parse_rc_string("ythickness = 1", "*.GtkButton");
	
	// This one may not work...
	//insertIntProperty(rc_style, "GtkCheckButton", "indicator-size", qApp->style().pixelMetric(QStyle::PM_IndicatorHeight) );
	
	// For icons
	
	iconThemeDir = kdeFindDir("/share/icons/" + iconTheme + "/", "index.theme", "index.desktop");
	if (iconThemeDir.isEmpty())
	{
		gtk_rc_add_default_file(cacheFilePath.latin1());
		return;
	}
	
	stream << "\npixmap_path \"" + iconThemeDir + "\"\n\n";
	
	stream << "style \"KDE-icons\" {\n";
	stream << doIconMapping("gtk-bold", "actions/text_bold.png");
	stream << doIconMapping("gtk-cancel", "actions/button_cancel.png");
	stream << doIconMapping("gtk-cdrom", "devices/cdrom_unmount.png");
	stream << doIconMapping("gtk-clear", "actions/editclear.png");
	stream << doIconMapping("gtk-close", "actions/fileclose.png");
	stream << doIconMapping("gtk-color-picker", "actions/colorpicker.png", 3);
	stream << doIconMapping("gtk-copy", "actions/editcopy.png");
	stream << doIconMapping("gtk-cut", "actions/editcut.png");
	stream << doIconMapping("gtk-delete", "actions/editdelete.png");
	stream << doIconMapping("gtk-dialog-error", "actions/messagebox_critical.png", 4);
	stream << doIconMapping("gtk-dialog-info", "actions/messagebox_info.png", 4);
	stream << doIconMapping("gtk-dialog-question", "actions/help.png");
	stream << doIconMapping("gtk-dialog-warning", "actions/messagebox_warning.png", 4);
	stream << doIconMapping("gtk-dnd", "mimetypes/empty.png");
	stream << doIconMapping("gtk-dnd-multiple", "mimetypes/kmultiple.png");
	stream << doIconMapping("gtk-execute", "actions/exec.png");
	stream << doIconMapping("gtk-find", "actions/find.png");
	stream << doIconMapping("gtk-floppy", "devices/3floppy_unmount.png");
	stream << doIconMapping("gtk-goto-bottom", "actions/bottom.png");
	stream << doIconMapping("gtk-goto-first", "actions/start.png");
	stream << doIconMapping("gtk-goto-last", "actions/finish.png");
	stream << doIconMapping("gtk-goto-top", "actions/top.png");
	stream << doIconMapping("gtk-go-back", "actions/back.png");
	stream << doIconMapping("gtk-go-down", "actions/down.png");
	stream << doIconMapping("gtk-go-forward", "actions/forward.png");
	stream << doIconMapping("gtk-go-up", "actions/up.png");
	stream << doIconMapping("gtk-help", "apps/khelpcenter.png");
	stream << doIconMapping("gtk-home", "filesystems/folder_home.png");
	stream << doIconMapping("gtk-index", "actions/contents.png");
	stream << doIconMapping("gtk-italic", "actions/text_italic.png");
	stream << doIconMapping("gtk-jump-to", "actions/goto.png");
	stream << doIconMapping("gtk-justify-center", "actions/text_center.png");
	stream << doIconMapping("gtk-justify-fill", "actions/text_block.png");
	stream << doIconMapping("gtk-justify-left", "actions/text_left.png");
	stream << doIconMapping("gtk-justify-right", "actions/text_right.png");
	stream << doIconMapping("gtk-missing-image", "mimetypes/unknown.png");
	stream << doIconMapping("gtk-new", "actions/filenew.png");
	stream << doIconMapping("gtk-ok", "actions/button_ok.png");
	stream << doIconMapping("gtk-open", "actions/fileopen.png");
	stream << doIconMapping("gtk-paste", "actions/editpaste.png");
	stream << doIconMapping("gtk-preferences", "actions/configure.png");
	stream << doIconMapping("gtk-print", "actions/fileprint.png");
	stream << doIconMapping("gtk-print-preview", "actions/filequickprint.png");
	stream << doIconMapping("gtk-properties", "actions/configure.png");
	stream << doIconMapping("gtk-quit", "actions/exit.png");
	stream << doIconMapping("gtk-redo", "actions/redo.png");
	stream << doIconMapping("gtk-refresh", "actions/reload.png");
	stream << doIconMapping("gtk-revert-to-saved", "actions/revert.png");
	stream << doIconMapping("gtk-save", "actions/filesave.png");
	stream << doIconMapping("gtk-save-as", "actions/filesaveas.png");
	stream << doIconMapping("gtk-select-color", "actions/colorize.png");
	stream << doIconMapping("gtk-select-font", "mimetypes/font.png");
	stream << doIconMapping("gtk-spell-check", "actions/spellcheck.png");
	stream << doIconMapping("gtk-stop", "actions/stop.png");
	stream << doIconMapping("gtk-strikethrough", "actions/text_strike.png", 3);
	stream << doIconMapping("gtk-underline", "actions/text_under.png");
	stream << doIconMapping("gtk-undo", "actions/undo.png");
	stream << doIconMapping("gtk-zoom-100", "actions/viewmag1.png");
	stream << doIconMapping("gtk-zoom-fit", "actions/viewmagfit.png");
	stream << doIconMapping("gtk-zoom-in", "actions/viewmag+.png");
	stream << doIconMapping("gtk-zoom-out", "actions/viewmag-.png");
	stream << "} class \"*\" style \"KDE-icons\"";
	
	cacheFile.close();
	
	gtk_rc_add_default_file(cacheFilePath.latin1());
}

void setMenuBackground(GtkStyle* style)
{
	if (!gtkQtEnable)
		return;
	
	// Get the menu background image
	menuBackgroundPixmap = new QPixmap(1024, 25); // Meh
	QPainter painter(menuBackgroundPixmap);
	QPopupMenu pm;
	QMenuData md;
	QMenuItem* mi = md.findItem(md.insertItem(""));
	
	QStyleOption opt(mi, 16, 16);
	QStyle::SFlags sflags = QStyle::Style_Default;

	if ((backgroundTile) && (!backgroundTile->isNull()))
		painter.fillRect(0, 0, 1024, 25, QBrush(QColor(255,255,255), *backgroundTile));
	else
		painter.fillRect(0, 0, 1024, 25, qApp->palette().active().brush(QColorGroup::Background));
	qApp->style().drawControl(QStyle::CE_PopupMenuItem, &painter, &pm, QRect(0,0,1024,25), qApp->palette().active(), sflags, opt);

	QTENGINE_STYLE(style)->menuBackground = gdk_pixmap_foreign_new(menuBackgroundPixmap->handle());
}

// It has a 'u' damnit
void mapColour(GdkColor* g, QColor q)
{
	g->red = q.red() * 257;
	g->green = q.green() * 257;
	g->blue = q.blue() * 257;
}

void setColors(GtkStyle* style)
{
	if (!gtkQtEnable)
		return;
	
	/*gtkStyle = style;*/
	
	bool useBg = ((backgroundTile) && (!backgroundTile->isNull()));
	
	// Normal
	mapColour(&style->fg[0],    qApp->palette().active().text());
	mapColour(&style->bg[0],    qApp->palette().active().background());
	mapColour(&style->light[0], qApp->palette().active().light());
	mapColour(&style->dark[0],  qApp->palette().active().dark());
	mapColour(&style->mid[0],   qApp->palette().active().mid());
	mapColour(&style->text[0],  qApp->palette().active().text());
	mapColour(&style->base[0],  qApp->palette().active().base());
	
	// Active (on)
	mapColour(&style->fg[1],    qApp->palette().active().text());
	mapColour(&style->bg[1],    qApp->palette().active().background());
	mapColour(&style->light[1], qApp->palette().active().light());
	mapColour(&style->dark[1],  qApp->palette().active().dark());
	mapColour(&style->mid[1],   qApp->palette().active().mid());
	mapColour(&style->text[1],  qApp->palette().active().text());
	mapColour(&style->base[1],  qApp->palette().active().base());
	
	// Mouseover
	mapColour(&style->fg[2],    qApp->palette().active().text()); // menu items - change?
	mapColour(&style->bg[2],    qApp->palette().active().highlight());
	mapColour(&style->light[2], qApp->palette().active().light());
	mapColour(&style->dark[2],  qApp->palette().active().dark());
	mapColour(&style->mid[2],   qApp->palette().active().mid());
	mapColour(&style->text[2],  qApp->palette().active().text());
	mapColour(&style->base[2],  qApp->palette().active().base());
	
	// Selected
	mapColour(&style->fg[3],    qApp->palette().active().highlightedText());
	mapColour(&style->bg[3],    qApp->palette().active().highlight());
	mapColour(&style->light[3], qApp->palette().active().light());
	mapColour(&style->dark[3],  qApp->palette().active().dark());
	mapColour(&style->mid[3],   qApp->palette().active().mid());
	mapColour(&style->text[3],  qApp->palette().active().highlightedText());
	mapColour(&style->base[3],  qApp->palette().active().highlight());
	
	// Disabled
	mapColour(&style->fg[4],    qApp->palette().disabled().text());
	mapColour(&style->bg[4],    qApp->palette().disabled().background());
	mapColour(&style->light[4], qApp->palette().disabled().light());
	mapColour(&style->dark[4],  qApp->palette().disabled().dark());
	mapColour(&style->mid[4],   qApp->palette().disabled().mid());
	mapColour(&style->text[4],  qApp->palette().disabled().text());
	mapColour(&style->base[4],  qApp->palette().disabled().background());

	if (useBg)
		style->bg_pixmap[GTK_STATE_NORMAL] = gdk_pixmap_foreign_new(backgroundTile->handle());
	
	setMenuBackground(style);
}

void getTextColor(GdkColor *color, GtkStateType state_type)
{
	if (!gtkQtEnable)
		return;
	
	if ((state_type == GTK_STATE_PRELIGHT) || (state_type == GTK_STATE_ACTIVE) || (state_type == GTK_STATE_SELECTED))
		mapColour(color, qApp->palette().active().highlightedText());
	else if (state_type == GTK_STATE_NORMAL)
		mapColour(color, qApp->palette().active().text());
	else if (state_type == GTK_STATE_INSENSITIVE)
		mapColour(color, qApp->palette().disabled().text());
}

#if 0
void setGnomeFonts()
{
	QFont kdeFonts[3];
	QString gconfKeys[3] = { "/desktop/gnome/interface/font_name",
				 "/desktop/gnome/interface/monospace_font_name",
				 "/apps/metacity/general/titlebar_font" };
	
	kdeFonts[0] = KGlobalSettings::generalFont();
	kdeFonts[1] = KGlobalSettings::fixedFont();
	kdeFonts[2] = KGlobalSettings::windowTitleFont();
	
	GConfClient *client = gconf_client_get_default ();

	// construct pango font description
	for (int i=0; i<3; i++)
	{
		PangoFontDescription *fontDesc = pango_font_description_new();
		pango_font_description_set_family(fontDesc, kdeFonts[i].family().latin1());
	
		if (kdeFonts[i].italic())
			 pango_font_description_set_style(fontDesc, PANGO_STYLE_ITALIC);
		else
			 pango_font_description_set_style(fontDesc, PANGO_STYLE_NORMAL);
		
		pango_font_description_set_size(fontDesc, kdeFonts[i].pointSize()*PANGO_SCALE);
	
		PangoWeight fontW;
	
		switch(kdeFonts[i].weight())
		{
			case QFont::Light:
				fontW = PANGO_WEIGHT_LIGHT; break;
			case QFont::Normal:
				fontW = PANGO_WEIGHT_NORMAL; break;
			case QFont::DemiBold:
				fontW = PANGO_WEIGHT_BOLD; break;
			case QFont::Bold:
				fontW = PANGO_WEIGHT_ULTRABOLD; break;
			case QFont::Black:
				fontW = PANGO_WEIGHT_HEAVY; break;
			default:
				fontW = PANGO_WEIGHT_NORMAL; break;
		}
		
		pango_font_description_set_weight(fontDesc, fontW);
	
		//qDebug("Pango font string is %s",  pango_font_description_to_string(fontDesc));
	
		gchar *fontString = pango_font_description_to_string(fontDesc);
		if (!gconf_client_set_string(client, gconfKeys[i].latin1(), fontString, NULL))
			qDebug("Unable to set application font");
		
		pango_font_description_free(fontDesc);	
		g_free(fontString);
	}
}


void setupIconMap()
{
	IconMap iconMap16, iconMap22, iconMap32, iconMap48;
	
	appDirList += "kopete";
	
	// 16x16
	iconMap16["apps/kcontrol"] = "apps/gnome-settings";
	iconMap16["apps/window_list"] = "apps/panel-window-list";
	iconMap16["apps/kwin"]	= "apps/panel-window-menu";
	iconMap16["apps/package_development"] = "apps/gnome-devel";
	iconMap16["apps/konqueror"] = "apps/gnome-globe";
	iconMap16["apps/locale"] = "apps/config-language";
	iconMap16["apps/aim_protocol"] = "apps/im-aim";
	iconMap16["apps/icq_protocol"] = "apps/im-icq";
	iconMap16["apps/jabber_protocol"] = "apps/im-jabber";
	iconMap16["apps/msn_protocol"] = "apps/im-msn";
	iconMap16["apps/yahoo_protocol"] = "apps/im-yahoo";
	iconMap16["apps/kopete"] = "im";
	
	
	iconMap16["devices/ipod_mount"] = "devices/gnome-dev-ipod";
	iconMap16["devices/cdrom_mount"] = "devices/gnome-dev-cdrom";
	iconMap16["devices/print_printer"] = "devices/gnome-dev-printer";
	iconMap16["devices/memory"] = "devices/gnome-dev-memory";
	iconMap16["devices/hdd_mount"] = "devices/gnome-dev-harddisk";
	iconMap16["devices/mouse"] = "devices/gnome-dev-mouse-ball";
	iconMap16["devices/cdaudio_mount"] = "devices/gnome-dev-cdrom-audio";
	iconMap16["devices/nfs_mount"] = "devices/gnome-dev-removable";
	iconMap16["devices/3floppy_mount"] = "devices/gnome-dev-floppy";
	iconMap16["devices/dvd_mount"] = "devices/gnome-dev-dvd";
	iconMap16["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-vnd.ms-excel";
	iconMap16["mimetypes/"] = "mimetypes/gnome-mime-x-directory-nfs-server"; //
	iconMap16["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-vnd.ms-powerpoint";
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-bmp"; //
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-png"; //
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-wmf"; //
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-jpeg"; //
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-tiff"; //
	iconMap16["mimetypes/"] = "mimetypes/gnome-mime-x-directory-smb-workgroup"; //
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-svg"; //
	iconMap16["mimetypes/kword_kwd"] = "mimetypes/gnome-mime-application-msword";
	iconMap16["mimetypes/image"] = "mimetypes/gnome-mime-image-gif"; //
	iconMap16["filesystems/server"] = "filesystems/gnome-fs-server";
	iconMap16["filesystems/network_local"] = "filesystems/gnome-fs-client"; // 
	iconMap16["filesystems/folder_favorite"] = "filesystems/gnome-fs-bookmark";
	iconMap16["filesystems/network"] = "filesystems/gnome-fs-network";
	iconMap16["filesystems/"] = "filesystems/gnome-fs-bookmark-missing"; //
	
	
	
	
	// 22x22
	iconMap22["devices/ipod_mount"] = "devices/gnome-dev-ipod"; //
	iconMap22["devices/"] = "devices/gnome-dev-cdrom"; //
	iconMap22["devices/"] = "devices/gnome-dev-printer"; //
	iconMap22["devices/"] = "devices/gnome-dev-memory"; //
	iconMap22["devices/"] = "devices/gnome-dev-harddisk"; //
	iconMap22["devices/"] = "devices/gnome-dev-mouse-ball"; //
	iconMap22["devices/"] = "devices/gnome-dev-cdrom-audio"; //
	iconMap22["devices/"] = "devices/gnome-dev-removable"; //
	iconMap22["devices/"] = "devices/gnome-dev-battery"; //
	iconMap22["devices/"] = "devices/gnome-dev-floppy"; //
	iconMap22["devices/"] = "devices/gnome-dev-dvd"; //
	iconMap22["mimetypes/"] = "mimetypes/gnome-mime-x-directory-nfs-server"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-directory"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-server"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-directory-visiting"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-client"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-bookmark"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-network"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-bookmark-missing"; //
	iconMap22["filesystems/"] = "filesystems/gnome-fs-directory-accept"; //
	
	
	
	// 32x32
	iconMap32["apps/kwin"] = "apps/panel-window-menu";
	iconMap32["apps/kcmpartitions"] = "apps/disks"; //
	iconMap32["apps/keyboard"] = "apps/keyboard";
	iconMap32["apps/kscd"] = "apps/gnome-cdplayer-icon";
	iconMap32["apps/window_list"] = "apps/panel-window-list";
	iconMap32["apps/date"] = "apps/config-date";
	iconMap32["apps/blender"] = "apps/blender";
	iconMap32["actions/lock"] = "apps/gnome-lockscreen";
	iconMap32["apps/package_utilities"] = "apps/gnome-util";
	iconMap32["apps/"] = "apps/panel-notification-area"; //
	iconMap32["apps/xchat"] = "apps/xchat";
	iconMap32["apps/kdict"] = "apps/gdict";
	iconMap32["apps/package_system"] = "apps/administration";
	iconMap32["apps/kfm"] = "apps/file-manager";
	iconMap32["apps/network"] = "apps/network-config";
	iconMap32["apps/package_network"] = "apps/gnome-globe"; //
	iconMap32["apps/package_graphics"] = "apps/gnome-graphics";
	iconMap32["apps/kuser"] = "apps/config-users";
	iconMap32["apps/package_applications"] = "apps/gnome-finance"; //
	iconMap32["apps/"] = "apps/iagno"; //
	iconMap32["apps/"] = "apps/gnome-ftp"; //
	iconMap32["apps/locale"] = "apps/config-language";
	iconMap32["apps/kaboodle"] = "apps/gnome-media-player";
	iconMap32["apps/k3b"] = "apps/xcdroast";
	iconMap32["apps/package_development"] = "apps/gnome-devel";
	iconMap32["apps/evolution"] = "apps/evolution";
	iconMap32["apps/"] = "apps/gdm"; //
	iconMap32["apps/"] = "apps/gnome-gnomine"; //
	iconMap32["apps/"] = "apps/apacheconf"; //
	iconMap32["apps/"] = "apps/logviewer"; //
	iconMap32["apps/konsole"] = "apps/gnome-terminal";
	iconMap32["apps/"] = "apps/gnome-networktool"; //
	iconMap32["apps/"] = "apps/gnome-character-map"; //
	iconMap32["apps/dia"] = "apps/dia_gnome_icon";
	iconMap32["apps/"] = "apps/gnome-gsame";
	iconMap32["apps/kpdf"] = "apps/gnome-pdf";
	iconMap32["apps/kfloppy"] = "apps/system-floppy";
	iconMap32["apps/kdf"] = "apps/serviceconf"; //
	iconMap32["apps/kghostview"] = "apps/postscript-viewer";
	iconMap32["actions/exit"] = "apps/gnome-logout";
	iconMap32["apps/package_applications"] = "apps/gnome-applications";
	iconMap32["apps/kcalc"] = "apps/gnome-calculator";
	iconMap32["apps/konqueror"] = "apps/web-browser";
	iconMap32["apps/krdc"] = "apps/tsclient";
	iconMap32["apps/"] = "apps/gnome-nibbles";
	iconMap32["apps/"] = "apps/gnome-grecord";
	iconMap32["apps/kcmx"] = "apps/config-xfree";
	iconMap32["apps/ksnapshot"] = "apps/applets-screenshooter";
	iconMap32["apps/hwinfo"] = "apps/hwbrowser";
	iconMap32["apps/package_multimedia"] = "apps/gnome-multimedia";
	iconMap32["devices/ipod_mount"] = "devices/gnome-dev-ipod"; //
	iconMap32["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-vnd.ms-excel";
	iconMap32["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-vnd.ms-powerpoint";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-bmp";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-png";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-wmf";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-jpeg";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-tiff";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-svg";
	iconMap32["mimetypes/kword_kwd"] = "mimetypes/gnome-mime-application-msword";
	iconMap32["mimetypes/image"] = "mimetypes/gnome-mime-image-gif";
	iconMap32["filesystems/"] = "filesystems/gnome-fs-server"; //
	iconMap32["filesystems/"] = "filesystems/gnome-fs-client"; //
	iconMap32["filesystems/"] = "filesystems/gnome-fs-bookmark"; //
	iconMap32["filesystems/"] = "filesystems/gnome-fs-network"; //
	iconMap32["filesystems/"] = "filesystems/gnome-fs-bookmark-missing"; //
	
	iconMap32[""] = "stock/io/stock_print-driver";
	iconMap32[""] = "stock/io/stock_print";
	iconMap32[""] = "stock/io/stock_opensave";
	iconMap32[""] = "stock/io/stock_print-setup";
	iconMap32[""] = "stock/io/stock_printers";
	iconMap32[""] = "stock/io/stock_print-preview";
	iconMap32[""] = "stock/io/stock_print-preview-print";
	iconMap32[""] = "stock/io/stock_network-printer";
	iconMap32[""] = "stock/io/stock_bluetooth";
	iconMap32[""] = "stock/net/stock_mail-send-receive";
	iconMap32[""] = "stock/net/stock_directory-server";
	iconMap32[""] = "stock/net/stock_not-spam";
	iconMap32[""] = "stock/net/stock_addressbook";
	iconMap32[""] = "stock/net/stock_spam";
	iconMap32[""] = "stock/net/stock_internet";
	iconMap32[""] = "stock/net/stock_mail";
	iconMap32[""] = "stock/net/stock_appointment-reminder-excl";
	iconMap32[""] = "stock/net/stock_post-message";
	iconMap32[""] = "stock/net/stock_mail-send";
	iconMap32[""] = "stock/net/stock_mail-import";
	iconMap32[""] = "stock/net/stock_mail-open";
	iconMap32[""] = "stock/net/stock_outbox";
	iconMap32[""] = "stock/net/stock_groupwise-connector";
	iconMap32[""] = "stock/net/stock_inbox";
	iconMap32[""] = "stock/net/stock_appointment-reminder";
	iconMap32[""] = "stock/net/stock_exchange-connector";
	iconMap32[""] = "stock/net/stock_contact";
	iconMap32[""] = "stock/net/stock_sent-mail";
	iconMap32[""] = "stock/net/stock_mail-receive";
	iconMap32[""] = "stock/net/stock_channel";
	iconMap32[""] = "stock/data/stock_lock-broken";
	iconMap32[""] = "stock/data/stock_signature-ok";
	iconMap32[""] = "stock/data/stock_lock-open";
	iconMap32[""] = "stock/data/stock_lock-ok";
	iconMap32[""] = "stock/data/stock_signature-bad";
	iconMap32[""] = "stock/data/stock_data-sources-hand";
	iconMap32[""] = "stock/data/stock_data-sources";
	iconMap32[""] = "stock/data/stock_lock";
	iconMap32[""] = "stock/data/stock_signature";
	iconMap32[""] = "stock/code/stock_script";
	iconMap32[""] = "stock/chart/stock_chart";
	iconMap32[""] = "stock/media/stock_sound";
	iconMap32[""] = "stock/generic/stock_edit";
	iconMap32[""] = "stock/generic/stock_person";
	iconMap32[""] = "stock/generic/stock_dialog-warning";
	iconMap32[""] = "stock/generic/stock_notebook";
	iconMap32[""] = "stock/generic/stock_briefcase";
	iconMap32[""] = "stock/generic/stock_folder";
	iconMap32[""] = "stock/generic/stock_example";
	iconMap32[""] = "stock/generic/stock_openoffice";
	iconMap32[""] = "stock/generic/stock_cell-phone";
	iconMap32[""] = "stock/generic/stock_dialog-info";
	iconMap32[""] = "stock/generic/stock_summary";
	iconMap32[""] = "stock/generic/stock_new-24h-appointment";
	iconMap32[""] = "stock/generic/stock_new-appointment";
	iconMap32[""] = "stock/generic/stock_id";
	iconMap32[""] = "stock/generic/stock_landline-phone";
	iconMap32[""] = "stock/generic/stock_autopilot";
	iconMap32[""] = "stock/generic/stock_notes";
	iconMap32[""] = "stock/generic/stock_people";
	iconMap32[""] = "stock/generic/stock_keyring";
	iconMap32[""] = "stock/generic/stock_dialog-question";
	iconMap32[""] = "stock/generic/stock_news";
	iconMap32[""] = "stock/generic/stock_new-meeting";
	iconMap32[""] = "stock/generic/stock_web-calendar";
	iconMap32[""] = "stock/generic/stock_calendar";
	iconMap32[""] = "stock/generic/stock_alarm";
	iconMap32[""] = "stock/object/stock_delete-bookmark";
	iconMap32[""] = "stock/object/stock_bookmark";
	iconMap32[""] = "stock/object/stock_add-bookmark";
	iconMap32[""] = "stock/object/stock_edit-bookmark";
	iconMap32[""] = "stock/document/stock_new-formula";
	iconMap32[""] = "stock/document/stock_new-presentation";
	iconMap32[""] = "stock/document/stock_new-spreadsheet";
	iconMap32[""] = "stock/document/stock_new";
	iconMap32[""] = "stock/document/stock_new-template";
	iconMap32[""] = "stock/document/stock_new-html";
	iconMap32[""] = "stock/document/stock_new-labels";
	iconMap32[""] = "stock/document/stock_todo";
	iconMap32[""] = "stock/document/stock_new-text";
	iconMap32[""] = "stock/document/stock_new-drawing";
	iconMap32[""] = "stock/document/stock_new-master-document";
	
	
	
	iconMap48["apps/"] = "apps/gnome-unknown"; //
	iconMap48["apps/winprops"] = "apps/panel-window-menu";
	iconMap48["apps/kcmpartitions"] = "apps/disks"; //
	iconMap48["apps/window_list"] = "apps/gnome-session";
	iconMap48["apps/keyboard"] = "apps/keyboard";
	iconMap48["apps/kscd"] = "apps/gnome-cdplayer-icon";
	iconMap48["apps/window_list"] = "apps/panel-window-list";
	iconMap48["apps/fonts"] = "apps/gnome-settings-font";
	iconMap48["apps/date"] = "apps/config-date";
	iconMap48["apps/blender"] = "apps/blender";
	iconMap48["apps/kcontrol"] = "apps/gnome-settings";
	iconMap48["filesystems/mycomp"] = "apps/gnome-system"; //
	iconMap48["apps/access"] = "apps/gnome-settings-accessibility-keyboard";
	iconMap48["actions/lock"] = "apps/gnome-lockscreen";
	iconMap48["apps/arts"] = "apps/gnome-settings-sound";
	iconMap48["apps/khelpcenter"] = "apps/gnome-help";
	iconMap48["apps/package_network"] = "apps/gnome-server-config"; //
	iconMap48["apps/package_utilities"] = "apps/gnome-util";
	iconMap48["apps/"] = "apps/panel-notification-area"; //
	iconMap48["apps/"] = "apps/realplayer"; //
	iconMap48["apps/xchat"] = "apps/xchat";
	iconMap48["apps/background"] = "apps/gnome-settings-background";
	iconMap48["apps/style"] = "apps/gnome-settings-theme";
	iconMap48["apps/kdict"] = "apps/gdict";
	iconMap48["apps/kcmsystem"] = "apps/administration";
	iconMap48["apps/kfm"] = "apps/file-manager";
	iconMap48["apps/package_network"] = "apps/network-config"; //
	iconMap48["apps/yahoo_protocol"] = "apps/im-yahoo";
	iconMap48["apps/package_network"] = "apps/gnome-globe"; //
	iconMap48["apps/kcmsystem"] = "apps/gnome-system-config";
	iconMap48["apps/package_graphics"] = "apps/gnome-graphics";
	iconMap48["apps/go"] = "apps/gnome-starthere";
	iconMap48["apps/access"] = "apps/accessibility-directory";
	iconMap48["apps/"] = "apps/advanced-directory"; //
	iconMap48["apps/kuser"] = "apps/config-users";
	iconMap48["apps/kfind"] = "apps/gnome-searchtool-animation-rest"; //
	iconMap48["apps/package_applications"] = "apps/gnome-finance";
	iconMap48["apps/"] = "apps/iagno"; //
	iconMap48["apps/"] = "apps/gnome-ftp"; //
	iconMap48["apps/background"] = "apps/wallpaper";
	iconMap48["apps/kscreensaver"] = "apps/screensaver";
	iconMap48["apps/"] = "apps/visor"; //
	iconMap48["apps/locale"] = "apps/config-language";
	iconMap48["apps/kaboodle"] = "apps/gnome-media-player";
	iconMap48["apps/k3b"] = "apps/xcdroast";
	iconMap48["apps/"] = "apps/gnome-devel"; //
	iconMap48["apps/evolution"] = "apps/evolution";
	iconMap48["apps/package_toys"] = "apps/gnome-amusements";
	iconMap48["apps/"] = "apps/gdm";
	iconMap48["apps/"] = "apps/gnome-gnomine";
	iconMap48["apps/access"] = "apps/gnome-settings-accessibility-technologies"; //
	iconMap48["apps/key_bindings"] = "apps/gnome-settings-keybindings";
	iconMap48["apps/style"] = "apps/gnome-settings-ui-behavior";
	iconMap48["apps/kwin"] = "apps/gnome-window-manager";
	iconMap48["apps/"] = "apps/apacheconf";
	iconMap48["apps/kopete"] = "apps/im";
	iconMap48["apps/"] = "apps/gnome-reboot"; //
	iconMap48["apps/"] = "apps/logviewer"; //
	iconMap48["apps/konsole"] = "apps/gnome-terminal"; //
	iconMap48["devices/joystick"] = "apps/gnome-joystick";
	iconMap48["apps/keditbookmarks"] = "apps/gnome-favorites"; //
	iconMap48["apps/package_network"] = "apps/gnome-networktool"; //
	iconMap48["apps/dia"] = "apps/dia_gnome_icon";
	iconMap48["apps/"] = "apps/hint"; //
	iconMap48["apps/"] = "apps/gnome-gsame"; //
	iconMap48["apps/kpdf"] = "apps/gnome-pdf"; 
	iconMap48["apps/wine"] = "apps/wine"; 
	iconMap48["apps/kdf"] = "apps/serviceconf"; //
	iconMap48["apps/kghostview"] = "apps/postscript-viewer";
	iconMap48["apps/"] = "apps/gnome-other";
	iconMap48["apps/ark"] = "apps/file-roller";
	iconMap48["apps/"] = "apps/gnome-searchtool-animation"; //
	iconMap48["apps/kdmconfig"] = "apps/user-info";
	iconMap48["actions/exit"] = "apps/gnome-logout";
	iconMap48["apps/msn_protocol"] = "apps/im-msn";
	iconMap48["apps/package_applications"] = "apps/gnome-applications";
	iconMap48["apps/kcalc"] = "apps/gnome-calculator";
	iconMap48["apps/kcmkicker"] = "apps/gnome-panel"; //
	iconMap48["apps/konqueror"] = "apps/web-browser";
	iconMap48["apps/krdc"] = "apps/tsclient";
	iconMap48["apps/package_multimedia"] = "apps/gnome-audio";
	iconMap48["apps/"] = "apps/gnome-nibbles"; //
	iconMap48["apps/"] = "apps/im-nov"; //
	iconMap48["filesystems/desktop"] = "apps/gnome-desktop-config"; //
	iconMap48["apps/"] = "apps/gnome-grecord"; //
	iconMap48["apps/aim_protocol"] = "apps/im-aim";
	iconMap48["apps/ksysguard"] = "apps/gnome-monitor";
	iconMap48["apps/kcmx"] = "apps/config-xfree";
	iconMap48["apps/"] = "apps/applets-screenshooter"; //
	iconMap48["apps/hwinfo"] = "apps/hwbrowser";
	iconMap48["apps/jabber_protocol"] = "apps/im-jabber";
	iconMap48["apps/package_multimedia"] = "apps/gnome-multimedia";
	iconMap48["apps/"] = "apps/gnome-shutdown"; //
	iconMap48["apps/icq_protocol"] = "apps/im-icq";
	iconMap48["apps/kooka"] = "apps/xsane";
	iconMap48["apps/filetypes"] = "apps/gnome-settings-default-applications";
	iconMap48["apps/kfind"] = "apps/gnome-searchtool";
	iconMap48["apps/kpalmdoc"] = "apps/palm-pilot";
	iconMap48["apps/"] = "apps/beast";
	iconMap48["apps/sodipodi"] = "apps/sodipodi";
	iconMap48["devices/ipod_mount"] = "devices/gnome-dev-ipod";
	iconMap48["devices/cdrom_mount"] = "devices/gnome-dev-cdrom";
	iconMap48["devices/blockdevice"] = "devices/gnome-dev-pcmcia";
	iconMap48["devices/printer"] = "devices/gnome-dev-printer";
	iconMap48["devices/memory"] = "devices/gnome-dev-memory";
	iconMap48["devices/hdd_mount"] = "devices/gnome-dev-harddisk";
	iconMap48["devices/mouse"] = "devices/gnome-dev-mouse-ball";
	iconMap48["devices/cdaudio_mount"] = "devices/gnome-dev-cdrom-audio";
	iconMap48["devices/"] = "devices/gnome-dev-removable"; //
	iconMap48["devices/keyboard"] = "devices/gnome-dev-keyboard";
	iconMap48["devices/battery_plugged"] = "devices/gnome-dev-battery";
	iconMap48["devices/"] = "devices/gnome-dev-symlink"; //
	iconMap48["devices/3floppy_mount"] = "devices/gnome-dev-floppy";
	iconMap48["devices/mouse"] = "devices/gnome-dev-mouse-optical";
	iconMap48["devices/dvd_mount"] = "devices/gnome-dev-dvd";
	iconMap48["devices/zip_mount"] = "devices/gnome-dev-zipdisk";
	iconMap48["devices/"] = "devices/gnome-dev-jazdisk"; //
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-compressed-tar";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-genesis-rom"; //
	iconMap48["mimetypes/man"] = "mimetypes/gnome-mime-text-x-troff-man";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-patch"; //
	iconMap48["mimetypes/source_o"] = "mimetypes/gnome-mime-application-x-object-file";
	iconMap48["mimetypes/kword_kwd"] = "mimetypes/gnome-mime-application-x-kword";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-reject"; //
	iconMap48["mimetypes/vcard"] = "mimetypes/gnome-mime-text-x-vcard";
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-tar";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-bittorrent"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-audio-x-s3m"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-csrc"; //
	iconMap48["mimetypes/midi"] = "mimetypes/gnome-mime-audio-x-midi";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-image-x-tga"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-shockwave-flash"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-blender"; //
	iconMap48["mimetypes/sound"] = "mimetypes/gnome-mime-application-ogg"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-n64-rom"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-sql"; //
	iconMap48["mimetypes/tex"] = "mimetypes/gnome-mime-application-x-tex"; 
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-image-x-cmu-raster"; //
	iconMap48["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-x-gnumeric"; 
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-bzip-compressed-tar";
	iconMap48["mimetypes/zip"] = "mimetypes/gnome-mime-application-x-archive";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-lwo"; //
	iconMap48["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-vnd.ms-excel";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-lws"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-x-directory-smb-server"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-xwindowdump"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-ief"; //
	iconMap48["mimetypes/shellscript"] = "mimetypes/gnome-mime-application-x-shellscript"; 
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-nes-rom"; //
	iconMap48["mimetypes/html"] = "mimetypes/gnome-mime-text-html";
	iconMap48["mimetypes/pdf"] = "mimetypes/gnome-mime-application-pdf";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-install"; //
	iconMap48["mimetypes/font"] = "mimetypes/gnome-mime-application-x-font-linux-psf";
	iconMap48["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-vnd.sun.xml.impress";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-trash"; //
	iconMap48["mimetypes/video"] = "mimetypes/gnome-mime-video-mpeg"; //
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-compress";
	iconMap48["mimetypes/make"] = "mimetypes/gnome-mime-text-x-makefile";
	iconMap48["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-vnd.sun.xml.calc";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-scheme"; //
	iconMap48["mimetypes/kword_kwd"] = "mimetypes/gnome-mime-application-vnd.stardivision.writer"; //
	iconMap48["mimetypes/encrypted"] = "mimetypes/gnome-mime-application-pgp";
	iconMap48["mimetypes/txt"] = "mimetypes/gnome-mime-text";
	iconMap48["mimetypes/source_cpp"] = "mimetypes/gnome-mime-text-x-c++src";
	iconMap48["mimetypes/sound"] = "mimetypes/gnome-mime-audio-x-wav";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-x-directory-nfs-server"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-gameboy-rom"; //
	iconMap48["mimetypes/sound"] = "mimetypes/gnome-mime-audio-x-voc"; //
	iconMap48["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-vnd.ms-powerpoint"; 
	iconMap48["mimetypes/source_java"] = "mimetypes/gnome-mime-application-x-java-byte-code"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-chdr"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-bmp";
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-gzip";
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-stuffit";
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-bzip";
	iconMap48["mimetypes/source"] = "mimetypes/gnome-mime-text-x-haskell";
	iconMap48["mimetypes/applix"] = "mimetypes/gnome-mime-application-x-applix-spreadsheet";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-png";
	iconMap48["mimetypes/binary"] = "mimetypes/gnome-mime-application-x-executable";
	iconMap48["mimetypes/document"] = "mimetypes/gnome-mime-application-x-abiword";
	iconMap48["mimetypes/sound"] = "mimetypes/gnome-mime-audio-x-ulaw";
	iconMap48["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-vnd.stardivision.impress";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-sharedlib"; //
	iconMap48["mimetypes/colorscm"] = "mimetypes/gnome-mime-image-x-portable-graymap"; //
	iconMap48["mimetypes/kpresenter_kpr"] = "mimetypes/gnome-mime-application-x-kpresenter";
	iconMap48["mimetypes/source_cpp"] = "mimetypes/gnome-mime-text-x-c++";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-portable-anymap"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-qif"; //
	iconMap48["mimetypes/core"] = "mimetypes/gnome-mime-application-x-core";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-qw"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-credits"; //
	iconMap48["mimetypes/shellscript"] = "mimetypes/gnome-mime-text-x-csh"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-x-directory-smb-share"; //
	iconMap48["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-x-kspread";
	iconMap48["mimetypes/quicktime"] = "mimetypes/gnome-mime-video-quicktime";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-ipod-firmware"; //
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-cpio"; 
	iconMap48["apps/package"] = "mimetypes/gnome-package"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-arj"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-copying"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-xpixmap"; //
	iconMap48["mimetypes/source_o"] = "mimetypes/gnome-mime-application-x-object"; 
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-gnome-app-info"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-xml"; //
	iconMap48["mimetypes/video"] = "mimetypes/gnome-mime-video";
	iconMap48["mimetypes/encrypted"] = "mimetypes/gnome-mime-application-pgp-keys";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-xfig"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-library"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-css"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-desktop"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-xbitmap"; //
	iconMap48["mimetypes/source_php"] = "mimetypes/gnome-mime-application-x-php"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-dc-rom"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-authors"; //
	iconMap48["mimetypes/applix"] = "mimetypes/gnome-mime-image-x-applix-graphic";
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-jar"; //
	iconMap48["mimetypes/shellscript"] = "mimetypes/gnome-mime-text-x-sh";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-e-theme"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-vnd.lotus-1-2-3"; //
	iconMap48["mimetypes/font_truetype"] = "mimetypes/gnome-mime-application-x-font-ttf";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-3ds"; //
	iconMap48["mimetypes/font_type1"] = "mimetypes/gnome-mime-x-font-afm"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-backup"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-xcf"; //
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-basic"; 
	iconMap48["mimetypes/video"] = "mimetypes/gnome-mime-video-x-ms-asf";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-gnucash"; //
	iconMap48["mimetypes/font_type1"] = "mimetypes/gnome-mime-application-x-font-afm"; //
	iconMap48["mimetypes/source_py"] = "mimetypes/gnome-mime-application-x-python";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-application-smil";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-jpeg";
	iconMap48["mimetypes/source_c"] = "mimetypes/gnome-mime-text-x-c";
	iconMap48["mimetypes/spreadsheet"] = "mimetypes/gnome-mime-application-vnd.stardivision.calc";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-it";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-midi";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-rhythmbox-effect"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-psd"; 
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-application-x-smil";
	iconMap48["mimetypes/video"] = "mimetypes/gnome-mime-video-x-msvideo";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-mrproject"; //
	iconMap48["mimetypes/source_java"] = "mimetypes/gnome-mime-text-x-java";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-pn-realaudio";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-dia-diagram"; //
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-ac3";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-tiff"; 
	iconMap48["mimetypes/document"] = "mimetypes/gnome-mime-application-rtf";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-gtktalog"; //
	iconMap48["mimetypes/encrypted"] = "mimetypes/gnome-mime-application-pgp-encrypted";
	iconMap48["mimetypes/vectorgfx"] = "mimetypes/gnome-mime-image-svg+xml";
	iconMap48["mimetypes/zip"] = "mimetypes/gnome-mime-application-zip";
	iconMap48["mimetypes/deb"] = "mimetypes/gnome-mime-application-x-deb";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-sql";
	iconMap48["mimetypes/tex"] = "mimetypes/gnome-mime-text-x-tex";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-sms-rom"; //
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-rar";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-x-directory-smb-workgroup"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-literate-haskell"; //
	iconMap48["mimetypes/metafont"] = "mimetypes/gnome-mime-application-x-font-bdf";
	iconMap48["mimetypes/postscript"] = "mimetypes/gnome-mime-application-postscript";
	iconMap48["mimetypes/applix"] = "mimetypes/gnome-mime-application-x-applix-word";
	iconMap48["mimetypes/video"] = "mimetypes/gnome-mime-video-x-ms-wmv";
	iconMap48["mimetypes/shellscript"] = "mimetypes/gnome-mime-text-x-zsh";
	iconMap48["mimetypes/font_type1"] = "mimetypes/gnome-mime-application-x-font-pcf";
	iconMap48["mimetypes/source_h"] = "mimetypes/gnome-mime-text-x-c-header";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-portable-pixmap";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-rgb";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-rhythmbox-playlist"; //
	iconMap48["mimetypes/readme"] = "mimetypes/gnome-mime-text-x-readme"; 
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-lyx"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-x-portable-bitmap";
	iconMap48["mimetypes/source_pl"] = "mimetypes/gnome-mime-application-x-perl";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-xi";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-xm";
	iconMap48["mimetypes/font_type1"] = "mimetypes/gnome-mime-application-x-font-sunos-news";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-kde-app-info"; //
	iconMap48["mimetypes/vcalendar"] = "mimetypes/gnome-mime-text-x-vcalendar";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-glade"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-msx-rom"; //
	iconMap48["mimetypes/source_java"] = "mimetypes/gnome-mime-application-x-class-file"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-csharp"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-text-x-objcsrc"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-python-bytecode"; //
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-svg"; 
	iconMap48["mimetypes/document"] = "mimetypes/gnome-mime-application-msword";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-application-vnd.rn-realmedia";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-mp3";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-stm";
	iconMap48["mimetypes/audio"] = "mimetypes/gnome-mime-audio-x-aiff";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-lha"; //
	iconMap48["mimetypes/rpm"] = "mimetypes/gnome-mime-application-x-rpm";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-killustrator"; //
	iconMap48["mimetypes/tar"] = "mimetypes/gnome-mime-application-x-cpio-compressed";
	iconMap48["mimetypes/document"] = "mimetypes/gnome-mime-application-vnd.sun.xml.writer";
	iconMap48["mimetypes/image"] = "mimetypes/gnome-mime-image-gif";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-x-lhz"; //
	iconMap48["mimetypes/core"] = "mimetypes/gnome-mime-application-x-core-file"; //
	iconMap48["mimetypes/cdimage"] = "mimetypes/gnome-mime-application-x-cd-image";
	iconMap48["mimetypes/dvi"] = "mimetypes/gnome-mime-application-x-dvi";
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application-magicpoint"; //
	iconMap48["mimetypes/"] = "mimetypes/gnome-mime-application"; //
	iconMap48["mimetypes/sound"] = "mimetypes/gnome-mime-audio-x-mod"; 
	iconMap48["filesystems/exec"] = "filesystems/gnome-fs-executable";
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-smb"; //
	iconMap48["filesystems/folder_home"] = "filesystems/gnome-fs-home";
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-ssh"; //
	iconMap48["filesystems/folder"] = "filesystems/gnome-fs-regular";
	iconMap48["filesystems/desktop"] = "filesystems/gnome-fs-desktop";
	iconMap48["filesystems/folder"] = "filesystems/gnome-fs-directory";
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-nfs";
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-ftp";
	iconMap48["filesystems/"] = "filesystems/gnome-fs-loading-icon";
	iconMap48["filesystems/server"] = "filesystems/gnome-fs-server";
	iconMap48["filesystems/trashcan_full"] = "filesystems/gnome-fs-trash-full";
	iconMap48["filesystems/"] = "filesystems/gnome-fs-socket"; //
	iconMap48["filesystems/folder_open"] = "filesystems/gnome-fs-directory-visiting";
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-client";
	iconMap48["filesystems/"] = "filesystems/gnome-fs-share"; //
	iconMap48["filesystems/trashcan_empty"] = "filesystems/gnome-fs-trash-empty";
	iconMap48["filesystems/folder_favorite"] = "filesystems/gnome-fs-bookmark";
	iconMap48["filesystems/folder_html"] = "filesystems/gnome-fs-web";
	iconMap48["devices/chardevice"] = "filesystems/gnome-fs-chardev"; 
	iconMap48["filesystems/network"] = "filesystems/gnome-fs-network";
	iconMap48["devices/blockdevice"] = "filesystems/gnome-fs-blockdev";
	iconMap48["filesystems/"] = "filesystems/gnome-fs-bookmark-missing"; //
	iconMap48["filesystems/folder_open"] = "filesystems/gnome-fs-directory-accept"; //
	iconMap48["filesystems/pipe"] = "filesystems/gnome-fs-fifo";
	
	iconMap48[""] = "stock/io/stock_print-driver";
	iconMap48[""] = "stock/io/stock_print-duplex-tumble";
	iconMap48[""] = "stock/io/stock_print";
	iconMap48[""] = "stock/io/stock_print-duplex-no-tumble";
	iconMap48[""] = "stock/io/stock_print-setup";
	iconMap48[""] = "stock/io/stock_print-non-duplex";
	iconMap48[""] = "stock/io/stock_printers";
	iconMap48[""] = "stock/io/stock_print-duplex";
	iconMap48[""] = "stock/io/stock_print-preview";
	iconMap48[""] = "stock/io/stock_print-preview-print";
	iconMap48[""] = "stock/io/stock_network-printer";
	iconMap48[""] = "stock/io/stock_bluetooth";
	iconMap48[""] = "stock/net/stock_mail-send-receive";
	iconMap48[""] = "stock/net/stock_directory-server";
	iconMap48[""] = "stock/net/stock_not-spam";
	iconMap48[""] = "stock/net/stock_addressbook";
	iconMap48[""] = "stock/net/stock_spam";
	iconMap48[""] = "stock/net/stock_mail-druid-account";
	iconMap48[""] = "stock/net/stock_proxy";
	iconMap48[""] = "stock/net/stock_mail";
	iconMap48[""] = "stock/net/stock_mail-druid";
	iconMap48[""] = "stock/net/stock_mail-flag-for-followup";
	iconMap48[""] = "stock/net/stock_appointment-reminder-excl";
	iconMap48[""] = "stock/net/stock_post-message";
	iconMap48[""] = "stock/net/stock_mail-send";
	iconMap48[""] = "stock/net/stock_mail-import";
	iconMap48[""] = "stock/net/stock_mail-open";
	iconMap48[""] = "stock/net/stock_outbox";
	iconMap48[""] = "stock/net/stock_mail-compose";
	iconMap48[""] = "stock/net/stock_groupwise-connector";
	iconMap48[""] = "stock/net/stock_inbox";
	iconMap48[""] = "stock/net/stock_appointment-reminder";
	iconMap48[""] = "stock/net/stock_mail-flag-for-followup-done";
	iconMap48[""] = "stock/net/stock_exchange-connector";
	iconMap48[""] = "stock/net/stock_contact";
	iconMap48[""] = "stock/net/stock_sent-mail";
	iconMap48[""] = "stock/net/stock_mail-receive";
	iconMap48[""] = "stock/net/stock_channel";
	iconMap48[""] = "stock/data/stock_lock-broken";
	iconMap48[""] = "stock/data/stock_signature-ok";
	iconMap48[""] = "stock/data/stock_lock-open";
	iconMap48[""] = "stock/data/stock_lock-ok";
	iconMap48[""] = "stock/data/stock_signature-bad";
	iconMap48[""] = "stock/data/stock_lock";
	iconMap48[""] = "stock/data/stock_signature";
	iconMap48[""] = "stock/code/stock_script";
	iconMap48[""] = "stock/generic/stock_edit";
	iconMap48[""] = "stock/generic/stock_person";
	iconMap48[""] = "stock/generic/stock_dialog-warning";
	iconMap48[""] = "stock/generic/stock_notebook";
	iconMap48[""] = "stock/generic/stock_briefcase";
	iconMap48[""] = "stock/generic/stock_weather-sunny";
	iconMap48[""] = "stock/generic/stock_weather-few-clouds";
	iconMap48[""] = "stock/generic/stock_example";
	iconMap48[""] = "stock/generic/stock_creditcard";
	iconMap48[""] = "stock/generic/stock_cell-phone";
	iconMap48[""] = "stock/generic/stock_weather-fog";
	iconMap48[""] = "stock/generic/stock_timezone";
	iconMap48[""] = "stock/generic/stock_weather-showers";
	iconMap48[""] = "stock/generic/stock_dialog-info";
	iconMap48[""] = "stock/generic/stock_summary";
	iconMap48[""] = "stock/generic/stock_new-24h-appointment";
	iconMap48[""] = "stock/generic/stock_new-appointment";
	iconMap48[""] = "stock/generic/stock_home";
	iconMap48[""] = "stock/generic/stock_id";
	iconMap48[""] = "stock/generic/stock_landline-phone";
	iconMap48[""] = "stock/generic/stock_autopilot";
	iconMap48[""] = "stock/generic/stock_calendar-and-tasks";
	iconMap48[""] = "stock/generic/stock_unknown";
	iconMap48[""] = "stock/generic/stock_notes";
	iconMap48[""] = "stock/generic/stock_autocompletion";
	iconMap48[""] = "stock/generic/stock_people";
	iconMap48[""] = "stock/generic/stock_keyring";
	iconMap48[""] = "stock/generic/stock_weather-storm";
	iconMap48[""] = "stock/generic/stock_news";
	iconMap48[""] = "stock/generic/stock_dialog-error";
	iconMap48[""] = "stock/generic/stock_new-meeting";
	iconMap48[""] = "stock/generic/stock_web-calendar";
	iconMap48[""] = "stock/generic/stock_weather-snow";
	iconMap48[""] = "stock/generic/stock_calendar";
	iconMap48[""] = "stock/generic/stock_weather-cloudy";
	iconMap48[""] = "stock/generic/stock_alarm";
	iconMap48[""] = "stock/generic/stock_init";
	iconMap48[""] = "stock/document/stock_new-formula";
	iconMap48[""] = "stock/document/stock_new-presentation";
	iconMap48[""] = "stock/document/stock_certificate";
	iconMap48[""] = "stock/document/stock_new-spreadsheet";
	iconMap48[""] = "stock/document/stock_new-template";
	iconMap48[""] = "stock/document/stock_new-html";
	iconMap48[""] = "stock/document/stock_new-labels";
	iconMap48[""] = "stock/document/stock_todo";
	iconMap48[""] = "stock/document/stock_new-text";
	iconMap48[""] = "stock/document/stock_new-drawing";
	iconMap48[""] = "stock/document/stock_new-master-document";

	iconMap[0]  = iconMap16;
	iconMap[1]  = iconMap22;
	iconMap[2]  = iconMap32;
	iconMap[3]  = iconMap48;
}

void setGnomeIcons()
{
	KStandardDirs *dir = KGlobal::dirs();
	
	QString dirs;
	QString dirsComment;

	QStringList iconSubDirs;
		
	// TODO -- add stock icon directories
	iconSubDirs << "16x16" << "16x16/actions" << "16x16/apps" << "16x16/devices" << "16x16/filesystems" << "16x16/mimetypes";
	iconSubDirs << "24x24" << "24x24/actions" << "24x24/apps" << "24x24/devices" << "24x24/filesystems" << "24x24/mimetypes";
	iconSubDirs << "32x32" << "32x32/actions" << "32x32/apps" << "32x32/devices" << "32x32/filesystems" << "32x32/mimetypes";
	iconSubDirs << "48x48" << "48x48/actions" << "48x48/apps" << "48x48/devices" << "48x48/filesystems" << "48x48/mimetypes";

	// Create Icon Dir
	QDir iconDir(QDir::homeDirPath()+"/.icons");
	if (!iconDir.exists())
		if (!iconDir.mkdir(iconDir.absPath()))
			return;
		
	iconDir.setPath(iconDir.absPath()+"/KDE");
	if (!iconDir.exists())
		if (!iconDir.mkdir(iconDir.absPath()))
			return;

	QFile tfile(iconDir.absPath()+"/.kdetheme");
	QString theme = "";
	
	// The iconset will be recreated if .kdetheme does not exist
	if (tfile.open(IO_ReadOnly))
	{
		QTextStream tstream(&tfile);
		theme = tstream.read();
		tfile.close();
	}

	if (theme != KIconTheme::current())
	{
		// The kde theme has changed, remove iconDir and start over
		for (QStringList::Iterator it = iconSubDirs.fromLast(); it != iconSubDirs.begin(); --it)
		{
			QDir curdir(iconDir.absPath() + "/" + (*it));
		        const QFileInfoList *lst = curdir.entryInfoList(QDir::Files|QDir::Hidden|QDir::System);
			if (lst)
			{
		        	QFileInfoListIterator fileit( *lst );
			        QFileInfo *file;
	
	                        while ( (file = fileit.current()) != 0)
	                        {
		                        ++fileit;
	                                QFile::remove(file->absFilePath());
	                        }
			}
                        iconDir.rmdir(curdir.absPath());
		}
                QDir curdir(iconDir.absPath() + "/" + iconSubDirs.first());
                const QFileInfoList *lst = curdir.entryInfoList(QDir::Files|QDir::Hidden|QDir::System);
                if (lst)
                {
           	     QFileInfoListIterator fileit( *lst );
                     QFileInfo *file;

                     while ( (file = fileit.current()) != 0)
                     {
                     	++fileit;
                        QFile::remove(file->absFilePath());
                     }
                }
                iconDir.rmdir(curdir.absPath());
		// start over
	}
	else
		return;
		
	// Make the initial directories
	for (QStringList::Iterator it = iconSubDirs.begin(); it != iconSubDirs.end(); ++it)
		iconDir.mkdir(*it);

	setupIconMap();

	QFile kicon;
	QString gicon;
	QString kkey;

	QString themeDir = KGlobal::iconLoader()->theme()->dir();	
		
	QStringList iconDirList;
	QStringList appIconDir;
	QString tdir;

	iconDirList += KGlobal::iconLoader()->theme()->dir();
	iconDirList += KIconTheme("crystalsvg").dir();	

	for (QStringList::Iterator it = appDirList.begin(); it != appDirList.end(); ++it)
	{
		appIconDir = dir->findDirs("data", *it);	
		for (QStringList::Iterator ita = appIconDir.begin(); ita != appIconDir.end(); ++ita )
		{
			tdir = (*ita) + "icons/crystalsvg";
			iconDirList += tdir;
		}
	}

	
	for (int i = 0; i<4; i++)
	{
		QString dir;

		if (i == 0)
			dir = "/16x16";
		else if (i == 1)
			dir = "/22x22";
		else if (i == 2)
			dir = "/32x32";
		else if (i == 3)
			dir = "/48x48";
			
		IconMap icmap = iconMap[i];

		IconMap::Iterator it;
		
		for (it = icmap.begin(); it != icmap.end(); ++it)
		{
			// Get the key
			kkey = it.key();
			
			if (kkey.endsWith("/"))
				continue;
	
			for (QStringList::Iterator dirsit = iconDirList.begin(); dirsit != iconDirList.end(); ++dirsit)
			{
				// Get the mapping
				kicon.setName((*dirsit) + dir + "/" + kkey + ".png");
				
				//check if the file exists
				if (kicon.exists())
				{
					gicon = iconDir.absPath() + dir + "/" + it.data() + ".png";
					if (symlink(kicon.name().latin1(), gicon.latin1()) != -1)
						break;
				}
			}
		}
		
	}

	//  Update .kdetheme file
	if (!tfile.open(IO_WriteOnly))
		return;
	
	QTextStream tstream(&tfile);
	tstream << KIconTheme::current();	
	tfile.close();

	// Copy the index file from gnome icon theme to KDE icon theme
	char *fpath = gnome_program_locate_file(NULL, GNOME_FILE_DOMAIN_DATADIR, "gtk-qt-engine/kde-index.theme", 1, NULL);
	QFile ffile(fpath);
	QFile output(iconDir.absPath()+"/index.theme");
	
	if(!ffile.open(IO_ReadOnly) || !output.open(IO_WriteOnly))
	{
		g_free(fpath);
		return;
	}

	QTextStream inputstream(&ffile);
	QTextStream outputstream(&output);
	
	outputstream << inputstream.read();
	output.close();
	ffile.close();
	g_free(fpath);
	return;
}


#endif
