/* vim:tabstop=4:expandtab:shiftwidth=4
 * 
 * Idesk -- DesktopConfig.cpp
 *
 * Copyright (c) 2002, Chris (nikon) (nikon@sc.rr.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 *      Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *      
 *      Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *      
 *      Neither the name of the <ORGANIZATION> nor the names of its
 *      contributors may be used to endorse or promote products derived from
 *      this software without specific prior written permission.
 *
 * (See the included file COPYING / BSD )
 */

#include "DesktopConfig.h"

//the initilizer list just sets the program defaults for non-necessary options
DesktopConfig::DesktopConfig(Database * db, string ideskrcFile) :
                             AbstractConfig(ideskrcFile)
{
    common = new CommonOptions();

    Table * table;
    
    if ( !(table = db->Query("Config")))
    {
        cout << "Can't find config file or missing 'Config'"
             << " table in the config file.\n";
        _exit(1);
    }

    //handle the configure options
    setOptions(table);
    
    //delete table;  //CommonOptions object will delete the table
    loadIcons();
}

DesktopConfig::~DesktopConfig()
{
    delete common;
}

void DesktopConfig::setOptions(Table * table)
{
    setDefaults();

    //DesktopContainer only options
    setDesktopOnlyOptions(table);
    
    //Options that can be overridden in the icon config
    common->setCommonDefaults();
    common->setOptions(table);

    // TODO - add functionality for other protected memembers in DesktopConfig.h
}

void DesktopConfig::setDefaults()
{
    isLocked = false;
    snapOn = false;
    snapWidth = 1;
    snapHeight = 1;
    startSnapTop = startSnapLeft = true;
}

void DesktopConfig::setDesktopOnlyOptions(Table * table)
{
    string tmpStr;
    
    //locking
    if (getUpper(table->Query("Locked")) == "TRUE")
        isLocked = true;
    else if (getUpper(table->Query("Locked")) == "FALSE")
        isLocked = false;

    //snap options
    if (getUpper(table->Query("IconSnap")) == "TRUE")
        snapOn = true;
    else if (getUpper(table->Query("IconSnap")) == "FALSE")
        snapOn = false;

    snapWidth = atoi(table->Query("SnapWidth").c_str());
    snapHeight = atoi(table->Query("SnapHeight").c_str());

    tmpStr = getUpper(table->Query("SnapOrigin"));
    
    if (tmpStr == "BOTTOMRIGHT")
    {
        startSnapLeft = false;
        startSnapTop = false;
    }
    else if (tmpStr == "BOTTOMLEFT")
        startSnapTop = false;
    else if (tmpStr == "TOPRIGHT")
        startSnapLeft = false;
    // last case automatically handled with default of TOPLEFT
}


void DesktopConfig::loadIcons()
{
    struct dirent **files;
    
    string directory(getenv("HOME"));
    string filename;

    Database * db;
    Table * table;

    int fileCount;

    DesktopIconConfig * iconPtr;

    directory += "/.idesktop/";

    fileCount = scandir(directory.c_str(), &files, 0, alphasort);
    
    if (fileCount == -1)
    {
        cout << "Error: you have to create the .idesktop dir !!\n";
        _exit (1);
    }

    for(int i = 0; i < fileCount; i++)
    {
        if ( !backgroundFile(files[i]->d_name))
        {
            filename = directory + files[i]->d_name;

            db = new Database(filename);

            if (table = db->Query("Icon"))
            {
                iconPtr = new DesktopIconConfig(filename, common);
                iconConfigList.push_back(iconPtr);
            }

            free(files[i]);
            delete db;
        }
    }

    free(files);
}

void DesktopConfig::saveLockState(bool lockState)
{
    Database *db;
    Table    *table;

    db = new Database(ideskrcFile);
    
    if((table = db->Query("Config"))) 
    {
        if (lockState)
            table->Set("Locked", "true");
        else
            table->Set("Locked", "false");

        db->Write();
    }
    else
    {
        cout << "Incorrect config file\n";
        return;
    }

    delete db;
}

bool DesktopConfig::backgroundFile(const string & filename)
{
    bool returnBool = false;

    if (filename.size() > 0 && (
            filename[0] == '.' ||
            filename[filename.size() - 1] == '~' ))
        returnBool = true;

    return returnBool;
}

