/****************************************************************************
 *                           SdbrCursor.h
 * Author: Matthew Ballance
 * Desc:   Defines a cursor
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 ****************************************************************************/
#ifndef INCLUDED_SDBR_CURSOR_H
#define INCLUDED_SDBR_CURSOR_H
#include "types.h"
#include <tcl.h>
#include <string.h>

class CursorMgr;
class SdbrCursor {

public:
    SdbrCursor(Tcl_Interp *interp, CursorMgr *newCursor, Uint32 idx);
   ~SdbrCursor(void);
    void setTime(Uint32 cursorTime);
    inline Uint32 getTime(void) { return cursorTime; }
    void lock(Uint32 locked);
    inline Uint32 isLocked(void) { return locked; } 
    inline Char *getInstName(void) { return instName; }
    inline Uint32 isSelected(void) { return selected; }
    void select(Uint32 sel);

    int InstCmd(Uint32 argc, Char **argv);

    void setIdx(Uint32 i) { idx = i; }
    Uint32 getIdx() const { return idx; }

    void setTimeIdx(Uint32 i) { d_timeIdx = i; }
    Uint32 getTimeIdx() const { return d_timeIdx; }

private:
    Tcl_Interp       *interp;
    CursorMgr        *parent;
    Uint32            cursorTime;
    Uint32            locked;
    Char             *instName;
    Uint32            selected;
    Uint32            idx;
    Uint32            d_timeIdx;
};

#endif /* INCLUDED_SDBR_CURSOR_H */
