/*****************************************************************************
 *                                 VExpr.h
 *
 * Author: Matthew Ballance
 * Desc:   
 *
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 *
 *****************************************************************************/
#ifndef INCLUDED_VEXPR_H
#define INCLUDED_VEXPR_H
#include "BitVector.h"
#include "Stack.h"
#include "types.h"
#include "vector.h"

class VExpr {
    public:
        VExpr();

        typedef enum {
            VO_Unknown,
            VO_Plus,
            VO_Minus,
            VO_Times,
            VO_Div,
            VO_BitOr,
            VO_BitAnd,
            VO_BitXor,
            VO_BitNot,
            VO_LogOr,
            VO_LogAnd,
            VO_LogXor,
            VO_LogNot,
            VO_Rparen,
            VO_Lparen,
            VO_UnPlus,
            VO_EqTest,
            VO_NeqTest,
            VO_LeftShift,
            VO_RightShift,
            VO_LessTest,
            VO_LessEqTest,
            VO_GreaterTest,
            VO_GreaterEqTest,
            VO_NumOps
        } VExpr_Op;

        Uint32 strToOp(Char *str);

        void pushOperator(VExpr_Op   op);
        void pushOperand(BitVector  *op);

        BitVector *executeOp(BitVector *op1, VExpr_Op op, BitVector *op2);

    private:
        Int32 opPrec(VExpr_Op op);

        Stack<BitVector>         operandStack;
        Stack<VExpr_Op>          operatorStack;
        Stack<VExpr::VExpr_Op>   operatorFreeStore;
        Stack<BitVector>         bitVectFreeStore;
     


};

#endif /* INCLUDED_VEXPR_H */
