/* ======================================================================
 * material.cc
 * 
 * This file is part of MeshIO, the general and extensible 3D mesh I/O
 * library.
 * Copyright (c) 1999, 2000 Niklas Elmqvist. All rights reserved.
 *
 * File created 2000-08-03 by Niklas Elmqvist <d97elm@dtek.chalmers.se>.
 * 
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 *
 * ======================================================================
 */

// -- System Includes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// -- Local Includes
#include "meshio.hh"

using namespace MeshIO;

// -- Code Segment

void MeshIO::mioMaterialInit(Material *mat)
{
    // Initialize material fields
    mat->name = NULL;
    mat->texFile = NULL;
    
    // Zero material colors
    memset(mat->ambient, 0, sizeof(float) * 3);
    memset(mat->specular, 0, sizeof(float) * 3);
    memset(mat->diffuse, 0, sizeof(float) * 3);
}

void MeshIO::mioMaterialClear(Material *mat)
{
    // Deallocate strings if needed
    if (mat->name != NULL)
	free(mat->name);
    if (mat->texFile != NULL)
	free(mat->texFile);   
}

void MeshIO::mioMaterialCopy(Material *dst, Material *src)
{
    // Copy the strings
    if (src->name != NULL)
	dst->name = strdup(src->name);
    if (src->texFile != NULL)
	dst->texFile = strdup(src->texFile);
    
    // Copy the properties
    memcpy(dst->ambient, src->ambient, sizeof(float) * 3);
    memcpy(dst->diffuse, src->diffuse, sizeof(float) * 3);
    memcpy(dst->specular, src->specular, sizeof(float) * 3);
}
