\name{download.packages2}
\alias{download.packages2}
\title{A function to download packages from a reposTools repository}
\description{
  This function will download specified packages from a reposTools-style
  repository.  Users can specify specific versions of the packages,
  download methods and type of packages.
}
\usage{
download.packages2(pkgs, repEntry, destDir, versions, type, method = "auto")
}
\arguments{
  \item{pkgs}{A vector of package names to download}
  \item{repEntry}{The repository to download from}
  \item{destDir}{The directory to store the downloaded files in.  If
    none is provided, will use the current directory}
  \item{versions}{An optional vector describing version numbers to be
    used.  If provided, must be equal in length to \code{pkgs}}
  \item{type}{Type of file: e.g. 'Source' or 'Win32'}
  \item{method}{Download method.  See \code{\link{download.file}} for
    details.}
}
\details{
  This function can be used to download packages from a repository.

  The user can specify as many packages as they would like (even none,
  see below) to download and the system will attempt to retrieve them
  all.  The repository to be used is specified as the \code{repEntry}
  parameter.  The \code{\link{repositories}} function is recommended for
  non-programatical usage to obtain a valid \code{repEntry} object.

  The \code{pkgs} parameter specifies the set of packages to try to
  download.  If none is provided, all packges from the repository will
  be downloaded.

  The \code{destDir} parameter specifies where to store the downloaded
  files.  Not specifying this will result in the files being placed in
  the current directory.

  The \code{versions} parameter is optional, and can be used to specify
  version numbers of the packages to download.  If this is provided, it
  must be provided for \bold{all} packages and thus must be of the same
  length as the \code{pkgs} parameter.  Leaving it blank will result in
  the highest version available of each package being downloaded.

  By default, the system will attempt to download the appropriate type
  of package for the operating system - for instance a user on Windows
  will get a Win32 .zip binary package.  If one would like to override
  this, it can be done with \code{type}, current available values are
  \code{Source} and \code{Win32}.

  Lastly, the \code{method} parameter can be used to specify the
  download method.  See \code{\link{download.file}} for explanations of
  these values.
}
\value{
  A vector of the filenames downloaded
}
\author{Jeff Gentry}
\seealso{\code{\link{install.packages2}},
  \code{\link{update.packages2}},\code{\link{repositories}}}
\examples{
   tmpLib <- tempfile()
   dir.create(tmpLib)

   z <- getReposEntry("http://www.bioconductor.org/repository/sample/package")
   download.packages2(c("annotate", "geneplotter"), z, destDir=tmpLib)

   ## A more 'real world' example
   if (interactive()) {
       ## Using the repositories function will allow you to select
       ## a repository out of the known possibilities.  The return
       ## value is a repEntry object which can be used for download.packages2
       z <- repositories()
       download.packages2("Biobase", z, destDir=tmpLib)
   }

   
}
\keyword{utilities}
