\name{getReposList}
\alias{getReposList}
\title{A function to get a list of repository entries}
\description{
  This function will take any URLs listed by the "repositories" option,
  and will return a list of ReposEntry objects representing those repositories
}
\usage{
getReposList(reps, recurse=TRUE, method="auto")
}
\arguments{
  \item{reps}{Either a list of \code{ReposEntry} objects, or a
    \code{ReposList} object}
  \item{recurse}{Whether or not to search through subrepositories.
    Default is TRUE}
  \item{method}{Method used for file downloads.  See \code{download.file}}
}
  \value{
  A \code{ReposList} object, containing all \code{ReposEntry} objects
  that were represented in \code{reps} as well as any subrepositories if
  \code{recurse} is TRUE.  Note that this function is essentially
  useless if \code{reps} is a \code{ReposList} and \code{recurse} is FALSE.
}
\author{Jeff Gentry}
\examples{
}
\keyword{utilities}

