\name{pkgStatusList-class}
\docType{class}
\alias{pkgStatusList-class}
\alias{pkgStatusList}
\alias{getPkgStatusListInfos}
\alias{statusList}
\alias{statusList<-}
\alias{matchesList}
\alias{matchesList<-}
\alias{notFound}
\alias{notUpdated}
\alias{urls}
\alias{pkgVersions}
\alias{foundPkgs}
\alias{notFoundPkgs}
\alias{updatedPkgs}
\alias{getPackage}
\alias{getFound}
\alias{getUpdated}
\alias{getUrl}
\alias{getPkgVersion}
\alias{foundPkgs,pkgStatusList-method}
\alias{found,pkgStatusList-method}
\alias{getFound,pkgStatusList-method}
\alias{getPackage,pkgStatusList-method}
\alias{getPkgVersion,pkgStatusList-method}
\alias{getUpdated,pkgStatusList-method}
\alias{getUrl,pkgStatusList-method}
\alias{notFoundPkgs,pkgStatusList-method}
\alias{notFound,pkgStatusList-method}
\alias{notUpdated,pkgStatusList-method}
\alias{packages,pkgStatusList-method}
\alias{pkgVersions,pkgStatusList-method}
\alias{show,pkgStatusList-method}
\alias{statusList<-,pkgStatusList-method}
\alias{statusList,pkgStatusList-method}
\alias{matchesList,pkgStatusList-method}
\alias{matchesList<-,pkgStatusList-method}
\alias{updatedPkgs,pkgStatusList-method}
\alias{updated,pkgStatusList-method}
\alias{urls,pkgStatusList-method}
\title{Class "pkgStatusList", maintains status for multiple packages}
\description{Maintains a set of \code{pkgStatus} objects, and methods
  for interacting with them.}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("pkgStatusList", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{statusList}:}{Object of class \code{"list"}, a list of
      \code{pkgStatus} objects}
    \item{\code{matchesList}:}{Object of class \code{"list"}, a list
      detailing any potential matches found for packages that were not
      found, in the event there were typos.}
  }
}
\section{Methods}{
  \describe{
    \item{show}{Summarizes the information stored in the listing}
    \item{statusList}{Returns the \code{statusList} slot}
    \item{statusList<-}{Edits the \code{statusList} slot.  User can pass
      in another \code{pkgStatusList}, a \code{pkgStatus} object, or a
      list.  Appends that information on to the current
      \code{statusList}}
    \item{matchesList}{Returns the \code{matchesList} slot}
    \item{matchesList<-}{Edits the \code{matchesList} slot.  User can
      pass in a list, and the information will be appended to the
      current.}
    \item{packages}{Returns the names of all packages being handled}
    \item{found}{Returns a numerical vector representing which positions
      in the \code{statusList} have been found}
    \item{notFound}{Returns a numerical vector representing which
      positions have not been found}
    \item{updated}{Returns a numerical vector representing which
      positions have been updated}
    \item{notUpdated}{Returns a numerical vector representing which
      positions have not been updated}
    \item{urls}{Returns the urls from all of the contained
      \code{pkgStatus} instances}
    \item{pkgVersions}{Returns the version number of all handled
      packages}
    \item{foundPkgs}{Returns the names of the found packages}
    \item{notFoundPkgs}{Returns the names of the packages that were not
      found}
    \item{updatedPkgs}{Returns the names of the updated packages}
    \item{getPackage}{Gets the name of a particular package}
    \item{getFound}{Retrieves the \code{found} slot for a particular
      position}
    \item{getUpdated}{Whether or not a particular package was updated}
    \item{getUrl}{A particular package's url}
    \item{getPkgVersion}{A particular package's version number}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{pkgStatus}}}
\examples{
##---- Should be DIRECTLY executable !! ----
}
\keyword{classes}
