
// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_SimultaneousIfStatement.hh"
#include "savant.hh"
#include "IIR_Label.hh"

IIRBase_SimultaneousIfStatement::IIRBase_SimultaneousIfStatement(){
  set_condition(NULL);
  set_elsif(NULL);
}

IIRBase_SimultaneousIfStatement::~IIRBase_SimultaneousIfStatement(){}

void
IIRBase_SimultaneousIfStatement::set_condition( IIR *new_condition ){
  condition = new_condition;
}

IIR*
IIRBase_SimultaneousIfStatement::get_condition(){
  return condition;
}

void
IIRBase_SimultaneousIfStatement::set_elsif( IIR_SimultaneousElsif *new_elsif_clause ){
  elsif_clause = new_elsif_clause;
}

IIR_SimultaneousElsif*
IIRBase_SimultaneousIfStatement::get_elsif(){
  return elsif_clause;
}




