
// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRScram_AboveAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_SignalDeclaration.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "error_func.hh"
#include "StandardPackage.hh"

extern symbol_table *cgen_sym_tab_ptr;
extern symbol_table *cgen_arch_sym_tab_ptr;

IIRScram_AboveAttribute::IIRScram_AboveAttribute() {}

IIRScram_AboveAttribute::~IIRScram_AboveAttribute() {}

void
IIRScram_AboveAttribute::_publish_vhdl(ostream &_vhdl_out) {
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'ABOVE " ;
  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ")";
  }
}

IIR_TextLiteral *
IIRScram_AboveAttribute::_build_attribute_name(){
  char *name = "above";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_AboveAttribute::get_subtype(){
  return (IIR_TypeDefinition*)StandardPackage::get_boolean_type();
}

IIR_Declaration*
IIRScram_AboveAttribute::_get_implicit_declaration(const string &decl_name,
                                                   IIR_TypeDefinition *decl_type) {
  return (IIR_Declaration*)_build_signal_declaration( decl_name, decl_type );
}

void
IIRScram_AboveAttribute::_publish_cc_lvalue(published_file &_cc_out) {
  IIR_Declaration *implicit_decl = IIR_Attribute::_get_implicit_declaration();
  ASSERT( get_prefix() != NULL );
  ASSERT( get_prefix()->_is_resolved() == TRUE);
  ASSERT( get_prefix()->_is_quantity() == TRUE );
  ASSERT(implicit_decl != NULL);
  ASSERT(implicit_decl->_is_resolved() == TRUE);
  
  if(cgen_sym_tab_ptr != NULL) {
    if (!cgen_sym_tab_ptr->in_scope(implicit_decl)) {
      cgen_sym_tab_ptr->add_declaration(implicit_decl);
    }
  }
  (ostream&)_cc_out << "currentState->";
  implicit_decl->_get_declarator()->_publish_cc_lvalue((ostream&)_cc_out);
}

IIR_Boolean
IIRScram_AboveAttribute::_is_above_attribute() {
  return TRUE;
}

void
IIRScram_AboveAttribute::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  to_build->add(((IIR_AboveAttribute*)this));
}

void
IIRScram_AboveAttribute::_publish_cc_ams_function(published_file & _cc_out) {
  if (_get_currently_publishing_unit() == SIMULTANEOUS_IF) {
    IIR_Attribute::_get_implicit_declaration()->_publish_cc_ams_function(_cc_out);
  }
}

void
IIRScram_AboveAttribute::_publish_cc_necessary_decl_in_state(published_file& _cc_out ) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved());
  _publish_cc_implicit_signal_declaration(_cc_out);
}

void
IIRScram_AboveAttribute::_publish_cc_init_val(ostream& _cc_out) {
  _cc_out << "true";
};

void
IIRScram_AboveAttribute::_publish_cc_name_in_caps(ostream& _cc_out) {
  _cc_out << "ABOVE";
}

void
IIRScram_AboveAttribute::_publish_cc_attrib_type(ostream& _cc_out) {
  _cc_out << "signal";
}

void
IIRScram_AboveAttribute::_publish_cc_sigtype(ostream& _cc_out) {
  _cc_out << " EXPLICIT;\n";
}

void
IIRScram_AboveAttribute::_resolve_suffix_special() {
  ASSERT( get_suffix() != NULL );
  set<IIR_TypeDefinition> *suffix_rvals = get_suffix()->_get_rval_set();
  if ( suffix_rvals == NULL ){
    report_undefined_symbol( get_suffix() );
  }
  switch( suffix_rvals->num_elements() ){
  case 0:{
    cerr << "|" << *get_suffix() << "| was not declared in this scope." << endl;
    abort();
  }
  case 1:{
    IIR_TypeDefinition *my_rval = suffix_rvals->get_element();
    set_suffix( get_suffix()->_semantic_transform( my_rval ) );
    get_suffix()->_type_check( my_rval );
    set_suffix( get_suffix()->_rval_to_decl( my_rval ) );
    break;
  }
  default:{
    report_ambiguous_error( get_suffix(), suffix_rvals );
  }
  }
}

void
IIRScram_AboveAttribute::_publish_cc_necessary_decl_init(published_file & _cc_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved() == TRUE);
  ASSERT((get_prefix()->_is_signal() == TRUE) ||
         (get_prefix()->_is_attribute() == TRUE) ||
         (get_prefix()->_is_quantity() == TRUE));
}

void
IIRScram_AboveAttribute::_set_stmt_signal_index(IIR_Int32 *index, set<IIR_Declaration>
                                                *signal_set) {
  IIR_Declaration *implicit_decl = IIR_Attribute::_get_implicit_declaration();
  
  if (cgen_sym_tab_ptr != NULL) {
    if (!cgen_sym_tab_ptr->in_scope(implicit_decl))
      cgen_sym_tab_ptr->add_declaration(implicit_decl);
  }
  
  ASSERT(cgen_arch_sym_tab_ptr != NULL);
  if (!cgen_arch_sym_tab_ptr->in_scope(implicit_decl))
    cgen_arch_sym_tab_ptr->add_declaration(implicit_decl);
  IIR_Attribute::_get_implicit_declaration()->_set_stmt_signal_index(index, signal_set);
}

IIR_Int32
IIRScram_AboveAttribute::_get_stmt_signal_index() {
  return IIR_Attribute::_get_implicit_declaration()->_get_stmt_signal_index();
}

void
IIRScram_AboveAttribute::flush_stmt_index() {
  ((IIR_Attribute*)this)->_get_implicit_declaration()->_flush_stmt_index();
}
