
#ifndef IIRSCRAM_ABOVE_ATTRIBUTE_HH
#define IIRSCRAM_ABOVE_ATTRIBUTE_HH

// Copyright (c) 2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Author: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRBase_AboveAttribute.hh"
template <class type> class set;
class IIR_AboveAttribute;

/** The IIR node for above attribute of quantities (Q'Above).  For a
    Quantity Q, the attribute Q'Above yields a signal. */
class IIRScram_AboveAttribute : public IIRBase_AboveAttribute {

public:
  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);

  /** This returns an IIR_TextLiteral when a Dot attribute is
      instantiated. */
  IIR_TextLiteral *_build_attribute_name();

  /** Returns the type of the signal created. */
  IIR_TypeDefinition *get_subtype();

  /** Returns a pointer to the implicit quantity created using
      build_signal_declaration. */
  IIR_Declaration* _get_implicit_declaration(const string &, IIR_TypeDefinition *);

  IIR_Boolean _is_signal() { return TRUE; }
  IIR_Boolean _has_suffix(){ return TRUE; }
  
  virtual void _resolve_suffix_special();

  /** @name C++ publishing methods.  These methods relate to the publishing
      of C++. */
  void _publish_cc_lvalue(published_file &);
  
  /** Uses the index assigned to each quantity and publishes the quantities
      present in the simultaneous statement. */
  void _publish_cc_ams_function(published_file &);

  void _publish_cc_necessary_decl_in_state(published_file &);
  void _publish_cc_necessary_decl_init(published_file &);
  void _publish_cc_init_val(ostream &);
  void _publish_cc_name_in_caps(ostream &);
  void _publish_cc_attrib_type(ostream &);
  void _publish_cc_sigtype(ostream &);

  /** Returns true if it is an above attribute. */ 
  IIR_Boolean _is_above_attribute();

  /** Returns TRUE if above attribute is found. */
  IIR_Boolean _is_above_attribute_found() { return TRUE; }

  /** Builds the set of above attributes.*/ 
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);

  /** Sets an index to each signal in the equation. */
  void _set_stmt_signal_index(IIR_Int32 *, set<IIR_Declaration>*);
  IIR_Int32 _get_stmt_signal_index();
  void flush_stmt_index();

protected:
  IIRScram_AboveAttribute();
  virtual ~IIRScram_AboveAttribute() = 0;

private:

};
#endif
